/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.dict;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.JSONSerializable;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hswebframework.web.bean.ClassDescription;
import org.hswebframework.web.bean.ClassDescriptions;
import org.hswebframework.web.dict.defaults.DefaultItemDefine;
import org.hswebframework.web.exception.ValidationException;
import org.hswebframework.web.i18n.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;

@JSONType(deserializer=EnumDictJSONDeserializer.class)
@JsonDeserialize(contentUsing=EnumDictJSONDeserializer.class)
public interface EnumDict<V>
extends JSONSerializable,
Serializable {
    public static final boolean DEFAULT_WRITE_JSON_OBJECT = !Boolean.getBoolean("hsweb.enum.dict.disableWriteJSONObject");

    public V getValue();

    public String getText();

    public int ordinal();

    default public long index() {
        return this.ordinal();
    }

    default public long getMask() {
        return 1L << (int)this.index();
    }

    default public boolean eq(Object v) {
        EnumDict dict;
        if (v == null) {
            return false;
        }
        if (v instanceof Object[]) {
            v = Arrays.asList(v);
        }
        if (v instanceof Collection) {
            return ((Collection)v).stream().anyMatch(this::eq);
        }
        if (v instanceof Map) {
            v = ((Map)v).getOrDefault("value", ((Map)v).get("text"));
        }
        if (v instanceof Number) {
            v = ((Number)v).intValue();
        }
        if (v instanceof EnumDict && (v = (dict = (EnumDict)v).getValue()) == null) {
            v = dict.getText();
        }
        return this == v || this.getValue() == v || Objects.equals(this.getValue(), v) || Objects.equals(this.ordinal(), v) || String.valueOf(this.getValue()).equalsIgnoreCase(String.valueOf(v)) || this.getText().equalsIgnoreCase(String.valueOf(v));
    }

    default public boolean in(long mask) {
        return (mask & this.getMask()) != 0L;
    }

    default public boolean in(EnumDict<V> ... dict) {
        return this.in(EnumDict.toMask((EnumDict[])dict));
    }

    default public String getComments() {
        return this.getText();
    }

    public static <T extends Enum<?>> Optional<T> find(Class<T> type, Predicate<T> predicate) {
        ClassDescription description = ClassDescriptions.getDescription(type);
        if (description.isEnumType()) {
            for (Object enumDict : description.getEnums()) {
                if (!predicate.test((Enum)enumDict)) continue;
                return Optional.of((Enum)enumDict);
            }
        }
        return Optional.empty();
    }

    public static <T extends Enum<?>> List<T> findList(Class<T> type, Predicate<T> predicate) {
        ClassDescription description = ClassDescriptions.getDescription(type);
        if (description.isEnumType()) {
            return Arrays.stream(description.getEnums()).map(v -> (Enum)v).filter(predicate).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static <T extends Enum<?>> Optional<T> findByValue(Class<T> type, Object value) {
        if (value == null) {
            return Optional.empty();
        }
        return EnumDict.find(type, (T e) -> ((EnumDict)((Object)e)).getValue() == value || ((EnumDict)((Object)e)).getValue().equals(value) || String.valueOf(((EnumDict)((Object)e)).getValue()).equalsIgnoreCase(String.valueOf(value)));
    }

    public static <T extends Enum<?>> Optional<T> findByText(Class<T> type, String text) {
        return EnumDict.find(type, (T e) -> ((EnumDict)((Object)e)).getText().equalsIgnoreCase(text));
    }

    public static <T extends Enum<?>> Optional<T> find(Class<T> type, Object target) {
        return EnumDict.find(type, (T v) -> ((EnumDict)((Object)v)).eq(target));
    }

    @SafeVarargs
    public static <T extends EnumDict<?>> long toMask(T ... t) {
        if (t == null) {
            return 0L;
        }
        long value = 0L;
        for (T t1 : t) {
            value |= t1.getMask();
        }
        return value;
    }

    @SafeVarargs
    public static <T extends Enum<?>> boolean in(T target, T ... t) {
        ClassDescription description = ClassDescriptions.getDescription(target.getClass());
        Object[] all = description.getEnums();
        if (all.length >= 64) {
            HashSet<Object> allSet = new HashSet<Object>(Arrays.asList(all));
            for (T t1 : t) {
                if (!allSet.contains(t1)) continue;
                return true;
            }
            return false;
        }
        return EnumDict.maskIn((long)EnumDict.toMask((EnumDict[])((EnumDict[])t)), (EnumDict[])new Enum[]{target});
    }

    @SafeVarargs
    public static <T extends EnumDict<?>> boolean maskIn(long mask, T ... t) {
        long value = EnumDict.toMask(t);
        return (mask & value) == value;
    }

    @SafeVarargs
    public static <T extends EnumDict<?>> boolean maskInAny(long mask, T ... t) {
        long value = EnumDict.toMask(t);
        return (mask & value) != 0L;
    }

    public static <T extends EnumDict<?>> List<T> getByMask(List<T> allOptions, long mask) {
        if (allOptions.size() >= 64) {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u9009\u9879\u8d85\u8fc764\u4e2a\u6570\u636e\u5b57\u5178!");
        }
        ArrayList<EnumDict> arr = new ArrayList<EnumDict>();
        for (EnumDict t : allOptions) {
            if (!t.in(mask)) continue;
            arr.add(t);
        }
        return arr;
    }

    public static <T extends EnumDict<?>> List<T> getByMask(Supplier<List<T>> allOptionsSupplier, long mask) {
        return EnumDict.getByMask(allOptionsSupplier.get(), mask);
    }

    public static <T extends Enum<?>> List<T> getByMask(Class<T> tClass, long mask) {
        return EnumDict.getByMask(Arrays.asList(tClass.getEnumConstants()), mask);
    }

    default public boolean isWriteJSONObjectEnabled() {
        return DEFAULT_WRITE_JSON_OBJECT;
    }

    default public String getI18nCode() {
        return this.getText();
    }

    default public String getI18nMessage(Locale locale) {
        return LocaleUtils.resolveMessage(this.getI18nCode(), locale, this.getText(), new Object[0]);
    }

    @JsonValue
    default public Object getWriteJSONObject() {
        if (this.isWriteJSONObjectEnabled()) {
            HashMap<String, V> jsonObject = new HashMap<String, V>();
            jsonObject.put("value", this.getValue());
            jsonObject.put("text", this.getI18nMessage(LocaleUtils.current()));
            return jsonObject;
        }
        return this.getValue();
    }

    default public void write(JSONSerializer jsonSerializer, Object o, Type type, int i) {
        if (this.isWriteJSONObjectEnabled()) {
            jsonSerializer.write(this.getWriteJSONObject());
        } else {
            jsonSerializer.write(this.getValue());
        }
    }

    public static EnumDict<String> create(String value) {
        return EnumDict.create(value, null);
    }

    public static EnumDict<String> create(String value, String text) {
        return DefaultItemDefine.builder().value(value).text(text).build();
    }

    public static class EnumDictJSONDeserializer
    extends JsonDeserializer<Object>
    implements ObjectDeserializer {
        private static final Logger log = LoggerFactory.getLogger(EnumDictJSONDeserializer.class);
        private Function<Object, Object> mapper;

        public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
            try {
                JSONLexer lexer = parser.lexer;
                int token = lexer.token();
                if (token == 2) {
                    int intValue = lexer.intValue();
                    lexer.nextToken(16);
                    return EnumDict.find((Class)type, intValue).orElse(null);
                }
                if (token == 4) {
                    String name = lexer.stringVal();
                    lexer.nextToken(16);
                    if (name.length() == 0) {
                        return null;
                    }
                    return EnumDict.find((Class)type, name).orElse(null);
                }
                if (token == 8) {
                    lexer.nextToken(16);
                    return null;
                }
                Object value = parser.parse();
                if (value instanceof Map) {
                    return (T)EnumDict.find((Class)type, ((Map)value).get("value")).orElseGet(() -> EnumDict.find((Class)type, ((Map)value).get("text")).orElse(null));
                }
                throw new JSONException("parse enum " + type + " error, value : " + value);
            }
            catch (JSONException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JSONException(e.getMessage(), (Throwable)e);
            }
        }

        public int getFastMatchToken() {
            return 4;
        }

        public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            if (this.mapper != null) {
                if (node.isTextual()) {
                    return this.mapper.apply(node.asText());
                }
                if (node.isNumber()) {
                    return this.mapper.apply(node.asLong());
                }
            }
            String currentName = jp.currentName();
            Object currentValue = jp.getCurrentValue();
            if (StringUtils.isEmpty((Object)currentName) || StringUtils.isEmpty((Object)currentValue)) {
                return null;
            }
            Class findPropertyType = BeanUtils.findPropertyType((String)currentName, (Class[])new Class[]{currentValue.getClass()});
            Supplier<ValidationException> exceptionSupplier = () -> {
                List values = Stream.of(findPropertyType.getEnumConstants()).map(Enum.class::cast).map(e -> {
                    if (e instanceof EnumDict) {
                        return ((EnumDict)((Object)e)).getValue();
                    }
                    return e.name();
                }).collect(Collectors.toList());
                return new ValidationException(currentName, "validation.parameter_does_not_exist_in_enums", currentName);
            };
            if (EnumDict.class.isAssignableFrom(findPropertyType) && findPropertyType.isEnum()) {
                if (node.isObject()) {
                    JsonNode valueNode = node.get("value");
                    Object value = null;
                    if (valueNode != null) {
                        if (valueNode.isTextual()) {
                            value = valueNode.textValue();
                        } else if (valueNode.isNumber()) {
                            value = valueNode.numberValue();
                        }
                    }
                    return (EnumDict)EnumDict.findByValue(findPropertyType, value).orElseThrow(exceptionSupplier);
                }
                if (node.isNumber()) {
                    return (EnumDict)EnumDict.find(findPropertyType, node.numberValue()).orElseThrow(exceptionSupplier);
                }
                if (node.isTextual()) {
                    return (EnumDict)EnumDict.find(findPropertyType, node.textValue()).orElseThrow(exceptionSupplier);
                }
                return exceptionSupplier.get();
            }
            if (findPropertyType.isEnum()) {
                return Stream.of(findPropertyType.getEnumConstants()).filter(o -> {
                    if (node.isTextual()) {
                        return node.textValue().equalsIgnoreCase(((Enum)o).name());
                    }
                    if (node.isNumber()) {
                        return node.intValue() == ((Enum)o).ordinal();
                    }
                    return false;
                }).findAny().orElseThrow(exceptionSupplier);
            }
            log.warn("unsupported deserialize enum json : {} for: {}@{}", new Object[]{node, currentName, currentValue});
            return null;
        }

        public EnumDictJSONDeserializer(Function<Object, Object> mapper) {
            this.mapper = mapper;
        }

        public EnumDictJSONDeserializer() {
        }
    }
}

