/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.bean;

import com.google.common.collect.Maps;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.hswebframework.utils.time.DateFormatter;
import org.hswebframework.web.bean.BeanFactory;
import org.hswebframework.web.bean.ClassDescription;
import org.hswebframework.web.bean.ClassDescriptions;
import org.hswebframework.web.bean.Converter;
import org.hswebframework.web.bean.Copier;
import org.hswebframework.web.bean.SingleValueMap;
import org.hswebframework.web.dict.EnumDict;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ResolvableType;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.NumberUtils;
import org.springframework.util.ReflectionUtils;

public final class FastBeanCopier {
    private static final Logger log = LoggerFactory.getLogger(FastBeanCopier.class);
    private static final Map<CacheKey, Copier> CACHE = new ConcurrentHashMap<CacheKey, Copier>();
    private static final PropertyUtilsBean propertyUtils = BeanUtilsBean.getInstance().getPropertyUtils();
    private static final ConvertUtilsBean convertUtils = BeanUtilsBean.getInstance().getConvertUtils();
    private static final Map<Class<?>, Class<?>> wrapperClassMapping = new HashMap();
    public static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static BeanFactory BEAN_FACTORY;
    public static final DefaultConverter DEFAULT_CONVERT;

    public static void setBeanFactory(BeanFactory beanFactory) {
        BEAN_FACTORY = beanFactory;
        DEFAULT_CONVERT.setBeanFactory(beanFactory);
    }

    public static BeanFactory getBeanFactory() {
        return BEAN_FACTORY;
    }

    public static Set<String> include(String ... inculdeProperties) {
        return new HashSet<String>(Arrays.asList(inculdeProperties)){

            @Override
            public boolean contains(Object o) {
                return !super.contains(o);
            }
        };
    }

    public static Object getProperty(Object source, String key) {
        if (source instanceof Map) {
            return ((Map)source).get(key);
        }
        SingleValueMap map = new SingleValueMap();
        FastBeanCopier.copy(source, map, FastBeanCopier.include(key));
        return map.getValue();
    }

    public static <T, S> T copy(S source, T target, String ... ignore) {
        return FastBeanCopier.copy(source, target, (Converter)DEFAULT_CONVERT, ignore);
    }

    public static <T, S> T copy(S source, Supplier<T> target, String ... ignore) {
        return FastBeanCopier.copy(source, target.get(), (Converter)DEFAULT_CONVERT, ignore);
    }

    public static <T, S> T copy(S source, Class<T> target, String ... ignore) {
        return FastBeanCopier.copy(source, target.newInstance(), (Converter)DEFAULT_CONVERT, ignore);
    }

    public static <T, S> T copy(S source, T target, Converter converter, String ... ignore) {
        return FastBeanCopier.copy(source, target, converter, ignore == null || ignore.length == 0 ? Collections.emptySet() : new HashSet<String>(Arrays.asList(ignore)));
    }

    public static <T, S> T copy(S source, T target, Set<String> ignore) {
        return FastBeanCopier.copy(source, target, (Converter)DEFAULT_CONVERT, ignore);
    }

    public static <T, S> T copy(S source, T target, Converter converter, Set<String> ignore) {
        if (source instanceof Map && target instanceof Map) {
            if (CollectionUtils.isEmpty(ignore)) {
                ((Map)target).putAll((Map)source);
            } else {
                ((Map)source).forEach((k, v) -> {
                    if (!ignore.contains(k)) {
                        ((Map)target).put(k, v);
                    }
                });
            }
            return target;
        }
        FastBeanCopier.getCopier(source, target, true).copy(source, target, ignore, converter);
        return target;
    }

    static Class<?> getUserClass(Object object) {
        if (object instanceof Map) {
            return Map.class;
        }
        Class type = ClassUtils.getUserClass((Object)object);
        if (Proxy.isProxyClass(type)) {
            Class<?>[] interfaces = type.getInterfaces();
            return interfaces[0];
        }
        return type;
    }

    public static Copier getCopier(Object source, Object target, boolean autoCreate) {
        Class<?> sourceType = FastBeanCopier.getUserClass(source);
        Class<?> targetType = FastBeanCopier.getUserClass(target);
        CacheKey key = FastBeanCopier.createCacheKey(sourceType, targetType);
        if (autoCreate) {
            return CACHE.computeIfAbsent(key, k -> FastBeanCopier.createCopier(((CacheKey)k).sourceType, ((CacheKey)k).targetType));
        }
        return CACHE.get(key);
    }

    private static CacheKey createCacheKey(Class<?> source, Class<?> target) {
        return new CacheKey(source, target);
    }

    public static Copier createCopier(Class<?> source, Class<?> target) {
        String sourceName = source.getName();
        String tartName = target.getName();
        if (sourceName.startsWith("package ")) {
            sourceName = sourceName.substring("package ".length());
        }
        if (tartName.startsWith("package ")) {
            tartName = tartName.substring("package ".length());
        }
        String method = "public void copy(Object s, Object t, java.util.Set ignore, org.hswebframework.web.bean.Converter converter){\ntry{\n\t" + sourceName + " $$__source=(" + sourceName + ")s;\n\t" + tartName + " $$__target=(" + tartName + ")t;\n\t" + FastBeanCopier.createCopierCode(source, target) + "}catch(Throwable e){\n\tthrow e;\n}\n\n}";
        try {
            org.hswebframework.web.proxy.Proxy<Copier> proxy = org.hswebframework.web.proxy.Proxy.create(Copier.class, new Class[]{source, target}, new String[0]).addMethod(method);
            return proxy.newInstance();
        }
        catch (Exception e) {
            log.error("\u521b\u5efabean copy \u4ee3\u7406\u5bf9\u8c61\u5931\u8d25:\n{}", (Object)method, (Object)e);
            throw new UnsupportedOperationException(e.getMessage(), e);
        }
    }

    private static Map<String, ClassProperty> createProperty(Class<?> type) {
        List fieldNames = Arrays.stream(type.getDeclaredFields()).map(Field::getName).collect(Collectors.toList());
        return Stream.of(propertyUtils.getPropertyDescriptors(type)).filter(property -> !property.getName().equals("class") && property.getReadMethod() != null && property.getWriteMethod() != null).map(BeanClassProperty::new).sorted(Comparator.comparing(property -> fieldNames.indexOf(property.name))).collect(Collectors.toMap(ClassProperty::getName, Function.identity(), (k, k2) -> k, LinkedHashMap::new));
    }

    private static Map<String, ClassProperty> createMapProperty(Map<String, ClassProperty> template) {
        return template.values().stream().map(classProperty -> new MapClassProperty(classProperty.name)).collect(Collectors.toMap(ClassProperty::getName, Function.identity(), (k, k2) -> k, LinkedHashMap::new));
    }

    private static String createCopierCode(Class<?> source, Class<?> target) {
        Map<String, ClassProperty> sourceProperties = null;
        Map<String, ClassProperty> targetProperties = null;
        if (Map.class.isAssignableFrom(source)) {
            if (!Map.class.isAssignableFrom(target)) {
                targetProperties = FastBeanCopier.createProperty(target);
                sourceProperties = FastBeanCopier.createMapProperty(targetProperties);
            }
        } else if (Map.class.isAssignableFrom(target)) {
            if (!Map.class.isAssignableFrom(source)) {
                sourceProperties = FastBeanCopier.createProperty(source);
                targetProperties = FastBeanCopier.createMapProperty(sourceProperties);
            }
        } else {
            targetProperties = FastBeanCopier.createProperty(target);
            sourceProperties = FastBeanCopier.createProperty(source);
        }
        if (sourceProperties == null || targetProperties == null) {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b,source:" + source + " target:" + target);
        }
        StringBuilder code = new StringBuilder();
        for (ClassProperty sourceProperty : sourceProperties.values()) {
            ClassProperty targetProperty = targetProperties.get(sourceProperty.getName());
            if (targetProperty == null) continue;
            code.append("if(!ignore.contains(\"").append(sourceProperty.getName()).append("\")){\n\t");
            if (!sourceProperty.isPrimitive()) {
                code.append("if($$__source.").append(sourceProperty.getReadMethod()).append("!=null){\n");
            }
            code.append(targetProperty.generateVar(targetProperty.getName())).append("=").append(sourceProperty.generateGetter(target, targetProperty.getType())).append(";\n");
            if (!targetProperty.isPrimitive()) {
                code.append("\tif(").append(sourceProperty.getName()).append("!=null){\n");
            }
            code.append("\t$$__target.").append(targetProperty.generateSetter(targetProperty.getType(), sourceProperty.getName())).append(";\n");
            if (!targetProperty.isPrimitive()) {
                code.append("\t}\n");
            }
            if (!sourceProperty.isPrimitive()) {
                code.append("\t}\n");
            }
            code.append("}\n");
        }
        return code.toString();
    }

    static /* synthetic */ BeanFactory access$100() {
        return BEAN_FACTORY;
    }

    static {
        wrapperClassMapping.put(Byte.TYPE, Byte.class);
        wrapperClassMapping.put(Short.TYPE, Short.class);
        wrapperClassMapping.put(Integer.TYPE, Integer.class);
        wrapperClassMapping.put(Float.TYPE, Float.class);
        wrapperClassMapping.put(Double.TYPE, Double.class);
        wrapperClassMapping.put(Character.TYPE, Character.class);
        wrapperClassMapping.put(Boolean.TYPE, Boolean.class);
        wrapperClassMapping.put(Long.TYPE, Long.class);
        BEAN_FACTORY = new BeanFactory(){

            @Override
            public <T> T newInstance(Class<T> beanType) {
                return (T)(beanType == Map.class ? new HashMap() : beanType.newInstance());
            }
        };
        DEFAULT_CONVERT = new DefaultConverter();
        DEFAULT_CONVERT.setBeanFactory(BEAN_FACTORY);
    }

    public static class CacheKey {
        private final Class<?> sourceType;
        private final Class<?> targetType;

        public boolean equals(Object obj) {
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey target = (CacheKey)obj;
            return target.targetType == this.targetType && target.sourceType == this.sourceType;
        }

        public int hashCode() {
            int result = this.targetType != null ? this.targetType.hashCode() : 0;
            result = 31 * result + (this.sourceType != null ? this.sourceType.hashCode() : 0);
            return result;
        }

        public CacheKey(Class<?> sourceType, Class<?> targetType) {
            this.sourceType = sourceType;
            this.targetType = targetType;
        }
    }

    public static final class DefaultConverter
    implements Converter {
        private BeanFactory beanFactory = FastBeanCopier.access$100();

        public void setBeanFactory(BeanFactory beanFactory) {
            this.beanFactory = beanFactory;
        }

        public Collection<?> newCollection(Class<?> targetClass) {
            if (targetClass == List.class) {
                return new ArrayList();
            }
            if (targetClass == ConcurrentHashMap.KeySetView.class) {
                return ConcurrentHashMap.newKeySet();
            }
            if (targetClass == Set.class) {
                return new HashSet();
            }
            if (targetClass == Queue.class) {
                return new LinkedList();
            }
            try {
                return (Collection)targetClass.newInstance();
            }
            catch (Exception e) {
                throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b:" + targetClass, e);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public <T> T convert(Object source, Class<T> targetClass, Class[] genericType) {
            if (source == null) {
                return null;
            }
            ClassDescription target = ClassDescriptions.getDescription(targetClass);
            if (target.isEnumType() && source instanceof EnumDict) {
                Object val = ((EnumDict)source).getValue();
                if (targetClass.isInstance(val)) {
                    return (T)val;
                }
                return this.convert(val, targetClass, genericType);
            }
            if (targetClass == String.class) {
                if (source instanceof Date) {
                    return (T)DateFormatter.toString((Date)((Date)source), (String)"yyyy-MM-dd HH:mm:ss");
                }
                return (T)String.valueOf(source);
            }
            if (targetClass == Object.class) {
                return (T)source;
            }
            if (targetClass == Date.class) {
                if (source instanceof String) {
                    Date parsed = DateFormatter.fromString((String)((String)source));
                    if (parsed == null) {
                        return (T)this.converterByApache(Date.class, source);
                    }
                    return (T)parsed;
                }
                if (source instanceof Number) {
                    return (T)new Date(((Number)source).longValue());
                }
                if (source instanceof Date) {
                    return (T)new Date(((Date)source).getTime());
                }
            }
            if (target.isCollectionType()) {
                Collection<Object> sourceCollection;
                Collection<?> collection = this.newCollection(targetClass);
                if (source instanceof Collection) {
                    sourceCollection = (List<Object>)source;
                } else if (source instanceof Object[]) {
                    sourceCollection = Arrays.asList((Object[])source);
                } else if (source instanceof Map) {
                    sourceCollection = ((Map)source).values();
                } else if (source instanceof String) {
                    String stringValue = (String)source;
                    sourceCollection = Arrays.asList(stringValue.split("[,]"));
                } else {
                    sourceCollection = Arrays.asList(source);
                }
                if (genericType != null && genericType.length > 0 && genericType[0] != Object.class) {
                    for (Object e : sourceCollection) {
                        collection.add(this.convert(e, genericType[0], null));
                    }
                } else {
                    collection.addAll(sourceCollection);
                }
                return (T)collection;
            }
            if (target.isEnumType()) {
                void var8_27;
                if (target.isEnumDict()) {
                    String strVal = String.valueOf(source);
                    Object val = null;
                    for (Object anEnum : target.getEnums()) {
                        EnumDict dic = (EnumDict)anEnum;
                        Enum e = (Enum)anEnum;
                        if (!dic.eq(source) && !e.name().equalsIgnoreCase(strVal)) continue;
                        val = anEnum;
                        break;
                    }
                    if (val == null) {
                        return null;
                    }
                    if (targetClass.isInstance(val)) {
                        return (T)val;
                    }
                    return this.convert(val, targetClass, genericType);
                }
                String strSource = String.valueOf(source);
                Object[] val = target.getEnums();
                int stringValue = val.length;
                boolean bl = false;
                while (var8_27 < stringValue) {
                    Object e = val[var8_27];
                    Enum t = (Enum)e;
                    if (t.name().equalsIgnoreCase(strSource) || Objects.equals(String.valueOf(t.ordinal()), strSource)) {
                        return (T)e;
                    }
                    ++var8_27;
                }
                log.warn("\u65e0\u6cd5\u5c06:{}\u8f6c\u4e3a\u679a\u4e3e:{}", source, targetClass);
                return null;
            }
            if (target.isArrayType()) {
                Class<?> componentType = targetClass.getComponentType();
                List val = this.convert(source, List.class, new Class[]{componentType});
                return (T)val.toArray((Object[])Array.newInstance(componentType, val.size()));
            }
            if (target.isNumber()) {
                if (source instanceof String) {
                    return (T)NumberUtils.parseNumber((String)String.valueOf(source), targetClass);
                }
                if (source instanceof Date) {
                    source = ((Date)source).getTime();
                }
            }
            try {
                org.apache.commons.beanutils.Converter converter = convertUtils.lookup(targetClass);
                if (null != converter) {
                    return (T)converter.convert(targetClass, source);
                }
                if (targetClass == Map.class) {
                    if (source instanceof Map) {
                        return (T)this.copyMap((Map)source);
                    }
                    if (source instanceof Collection) {
                        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
                        int i = 0;
                        for (Object o : (Collection)source) {
                            if (genericType.length >= 2) {
                                map.put(this.convert(i++, genericType[0], EMPTY_CLASS_ARRAY), this.convert(o, genericType[1], EMPTY_CLASS_ARRAY));
                                continue;
                            }
                            map.put(i++, o);
                        }
                        return (T)map;
                    }
                    ClassDescription sourType = ClassDescriptions.getDescription(source.getClass());
                    return (T)FastBeanCopier.copy(source, Maps.newHashMapWithExpectedSize((int)sourType.getFieldSize()), new String[0]);
                }
                return FastBeanCopier.copy(source, this.beanFactory.newInstance(targetClass), (Converter)this, new String[0]);
            }
            catch (Exception e) {
                log.warn("\u590d\u5236\u7c7b\u578b{}->{}\u5931\u8d25", targetClass, (Object)e);
                throw e;
            }
        }

        private Map<?, ?> copyMap(Map<?, ?> map) {
            if (map instanceof TreeMap) {
                return new TreeMap(map);
            }
            if (map instanceof LinkedHashMap) {
                return new LinkedHashMap(map);
            }
            if (map instanceof ConcurrentHashMap) {
                return new ConcurrentHashMap(map);
            }
            return new HashMap(map);
        }

        private Object converterByApache(Class<?> targetClass, Object source) {
            org.apache.commons.beanutils.Converter converter = convertUtils.lookup(targetClass);
            if (null != converter) {
                return converter.convert(targetClass, source);
            }
            return null;
        }
    }

    static class MapClassProperty
    extends ClassProperty {
        public MapClassProperty(String name) {
            this.type = Object.class;
            this.name = name;
            this.readMethodName = "get";
            this.writeMethodName = "put";
            this.getter = this.createGetterFunction();
            this.setter = this.createSetterFunction(paramGetter -> "put(\"" + name + "\"," + paramGetter + ")");
            this.beanType = Map.class;
        }

        @Override
        public String getReadMethod() {
            return "get(\"" + this.name + "\")";
        }

        @Override
        public String getReadMethodName() {
            return "get(\"" + this.name + "\")";
        }
    }

    static class BeanClassProperty
    extends ClassProperty {
        public BeanClassProperty(PropertyDescriptor descriptor) {
            this.type = descriptor.getPropertyType();
            this.readMethodName = descriptor.getReadMethod().getName();
            this.writeMethodName = descriptor.getWriteMethod().getName();
            this.getter = this.createGetterFunction();
            this.setter = this.createSetterFunction(paramGetter -> this.writeMethodName + "(" + paramGetter + ")");
            this.name = descriptor.getName();
            this.beanType = descriptor.getReadMethod().getDeclaringClass();
        }
    }

    static abstract class ClassProperty {
        protected String name;
        protected String readMethodName;
        protected String writeMethodName;
        protected BiFunction<Class<?>, Class<?>, String> getter;
        protected BiFunction<Class<?>, String, String> setter;
        protected Class<?> type;
        protected Class<?> beanType;

        ClassProperty() {
        }

        public String getReadMethod() {
            return this.readMethodName + "()";
        }

        public String generateVar(String name) {
            return this.getTypeName().concat(" ").concat(name);
        }

        public String getTypeName() {
            return this.getTypeName(this.type);
        }

        public String getTypeName(Class<?> type) {
            String targetTypeName = type.getName();
            if (type.isArray()) {
                targetTypeName = type.getComponentType().getName() + "[]";
            }
            return targetTypeName;
        }

        public boolean isPrimitive() {
            return this.isPrimitive(this.getType());
        }

        public boolean isPrimitive(Class<?> type) {
            return type.isPrimitive();
        }

        public boolean isWrapper() {
            return this.isWrapper(this.getType());
        }

        public boolean isWrapper(Class<?> type) {
            return wrapperClassMapping.containsValue(type);
        }

        protected Class<?> getPrimitiveType(Class<?> type) {
            return wrapperClassMapping.entrySet().stream().filter(entry -> entry.getValue() == type).map(Map.Entry::getKey).findFirst().orElse(null);
        }

        protected Class<?> getWrapperType() {
            return (Class)wrapperClassMapping.get(this.type);
        }

        protected String castWrapper(String getter) {
            return this.getWrapperType().getSimpleName().concat(".valueOf(").concat(getter).concat(")");
        }

        public BiFunction<Class<?>, Class<?>, String> createGetterFunction() {
            return (targetBeanType, targetType) -> {
                CharSequence[] arr;
                String getterCode = "$$__source." + this.getReadMethod();
                String generic = "org.hswebframework.web.bean.FastBeanCopier.EMPTY_CLASS_ARRAY";
                Field field = ReflectionUtils.findField((Class)targetBeanType, (String)this.name);
                boolean hasGeneric = false;
                if (field != null && (arr = (String[])Arrays.stream(ResolvableType.forField((Field)field).getGenerics()).map(ResolvableType::getRawClass).filter(Objects::nonNull).map(t -> t.getName().concat(".class")).toArray(String[]::new)).length > 0) {
                    generic = "new Class[]{" + String.join((CharSequence)",", arr) + "}";
                    hasGeneric = true;
                }
                String convert = "converter.convert((Object)(" + (this.isPrimitive() ? this.castWrapper(getterCode) : getterCode) + ")," + this.getTypeName((Class<?>)targetType) + ".class," + generic + ")";
                StringBuilder convertCode = new StringBuilder();
                if (targetType != this.getType()) {
                    if (this.isPrimitive((Class<?>)targetType)) {
                        boolean sourceIsWrapper = this.isWrapper();
                        Class targetWrapperClass = (Class)wrapperClassMapping.get(targetType);
                        Class<?> sourcePrimitive = this.getPrimitiveType(this.getType());
                        if (sourceIsWrapper) {
                            convertCode.append(getterCode).append(".").append(sourcePrimitive.getName()).append("Value()");
                        } else {
                            convertCode.append("((").append(targetWrapperClass.getName()).append(")").append(convert).append(").").append(targetType.getName()).append("Value()");
                        }
                    } else if (this.isPrimitive()) {
                        boolean targetIsWrapper = this.isWrapper((Class<?>)targetType);
                        if (targetIsWrapper) {
                            convertCode.append(targetType.getName()).append(".valueOf(").append(getterCode).append(")");
                        } else {
                            convertCode.append("(").append(targetType.getName()).append(")(").append(convert).append(")");
                        }
                    } else {
                        convertCode.append("(").append(this.getTypeName((Class<?>)targetType)).append(")(").append(convert).append(")");
                    }
                } else if (Cloneable.class.isAssignableFrom((Class<?>)targetType)) {
                    try {
                        convertCode.append("(").append(this.getTypeName()).append(")").append(getterCode).append(".clone()");
                    }
                    catch (Exception e) {
                        convertCode.append(getterCode);
                    }
                } else if ((Map.class.isAssignableFrom((Class<?>)targetType) || Collection.class.isAssignableFrom(this.type)) && hasGeneric) {
                    convertCode.append("(").append(this.getTypeName()).append(")").append(convert);
                } else {
                    convertCode.append("(").append(this.getTypeName()).append(")").append(getterCode);
                }
                return convertCode.toString();
            };
        }

        public BiFunction<Class<?>, String, String> createSetterFunction(Function<String, String> settingNameSupplier) {
            return (sourceType, paramGetter) -> (String)settingNameSupplier.apply((String)paramGetter);
        }

        public String generateGetter(Class<?> targetBeanType, Class<?> targetType) {
            return this.getGetter().apply(targetBeanType, targetType);
        }

        public String generateSetter(Class<?> targetType, String getter) {
            return this.getSetter().apply(targetType, getter);
        }

        public String getName() {
            return this.name;
        }

        public String getReadMethodName() {
            return this.readMethodName;
        }

        public String getWriteMethodName() {
            return this.writeMethodName;
        }

        public BiFunction<Class<?>, Class<?>, String> getGetter() {
            return this.getter;
        }

        public BiFunction<Class<?>, String, String> getSetter() {
            return this.setter;
        }

        public Class<?> getType() {
            return this.type;
        }

        public Class<?> getBeanType() {
            return this.beanType;
        }
    }
}

