/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.bean;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.hswebframework.web.bean.CompareUtils;
import org.hswebframework.web.bean.FastBeanCopier;

public class Diff {
    private String property;
    private Object before;
    private Object after;

    public static List<Diff> of(Object before, Object after, String ... ignoreProperty) {
        ArrayList<Diff> diffs = new ArrayList<Diff>();
        HashSet ignores = Sets.newHashSet((Object[])ignoreProperty);
        Map beforeMap = FastBeanCopier.copy(before, HashMap::new, new String[0]);
        Map afterMap = FastBeanCopier.copy(after, HashMap::new, new String[0]);
        for (Map.Entry entry : afterMap.entrySet()) {
            if (ignores.contains(entry.getKey())) continue;
            Object afterValue = entry.getValue();
            String key = (String)entry.getKey();
            Object beforeValue = beforeMap.get(key);
            if (CompareUtils.compare(beforeValue, afterValue)) continue;
            diffs.add(new Diff(key, beforeValue, afterValue));
        }
        return diffs;
    }

    public String toString() {
        return JSON.toJSONString((Object)this);
    }

    public String getProperty() {
        return this.property;
    }

    public Object getBefore() {
        return this.before;
    }

    public Object getAfter() {
        return this.after;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setBefore(Object before) {
        this.before = before;
    }

    public void setAfter(Object after) {
        this.after = after;
    }

    public Diff(String property, Object before, Object after) {
        this.property = property;
        this.before = before;
        this.after = after;
    }

    public Diff() {
    }
}

