/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.bean;

import java.util.Collection;
import org.hswebframework.web.dict.EnumDict;

public class ClassDescription {
    private final Class<?> type;
    private final boolean collectionType;
    private final boolean arrayType;
    private final boolean enumType;
    private final boolean enumDict;
    private final int fieldSize;
    private final boolean number;
    private final Object[] enums;

    public ClassDescription(Class<?> type) {
        this.type = type;
        this.collectionType = Collection.class.isAssignableFrom(type);
        this.enumDict = EnumDict.class.isAssignableFrom(type);
        this.arrayType = type.isArray();
        this.enumType = type.isEnum();
        this.fieldSize = type.getDeclaredFields().length;
        this.number = Number.class.isAssignableFrom(type);
        this.enums = this.enumType ? type.getEnumConstants() : null;
    }

    public Class<?> getType() {
        return this.type;
    }

    public boolean isCollectionType() {
        return this.collectionType;
    }

    public boolean isArrayType() {
        return this.arrayType;
    }

    public boolean isEnumType() {
        return this.enumType;
    }

    public boolean isEnumDict() {
        return this.enumDict;
    }

    public int getFieldSize() {
        return this.fieldSize;
    }

    public boolean isNumber() {
        return this.number;
    }

    public Object[] getEnums() {
        return this.enums;
    }
}

