/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.aop;

import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.aopalliance.intercept.MethodInvocation;
import org.hswebframework.web.aop.MethodInterceptorContext;
import org.hswebframework.web.utils.AnnotationUtils;
import org.hswebframework.web.utils.DigestUtils;
import org.reactivestreams.Publisher;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;

public class MethodInterceptorHolder {
    public static final ParameterNameDiscoverer nameDiscoverer = new DefaultParameterNameDiscoverer();
    private String id;
    private final Method method;
    private final Object target;
    private final Object[] arguments;
    private final String[] argumentsNames;
    private Map<String, Object> namedArguments;

    public static MethodInterceptorHolder create(MethodInvocation invocation) {
        String[] names;
        String[] argNames = nameDiscoverer.getParameterNames(invocation.getMethod());
        Object[] args = invocation.getArguments();
        if (argNames == null || argNames.length != args.length) {
            names = new String[args.length];
            int len = args.length;
            for (int i = 0; i < len; ++i) {
                names[i] = argNames == null || argNames.length <= i || argNames[i] == null ? "arg" + i : argNames[i];
            }
        } else {
            names = argNames;
        }
        return new MethodInterceptorHolder(null, invocation.getMethod(), invocation.getThis(), args, names, null);
    }

    public String getId() {
        if (this.id == null) {
            this.id = DigestUtils.md5Hex(this.method.toString());
        }
        return this.id;
    }

    protected Map<String, Object> createNamedArguments() {
        LinkedHashMap namedArguments = Maps.newLinkedHashMapWithExpectedSize((int)this.arguments.length);
        int len = this.arguments.length;
        for (int i = 0; i < len; ++i) {
            namedArguments.put(this.argumentsNames[i], this.arguments[i]);
        }
        return namedArguments;
    }

    public Map<String, Object> getNamedArguments() {
        return this.namedArguments == null ? (this.namedArguments = this.createNamedArguments()) : this.namedArguments;
    }

    public <T extends Annotation> T findMethodAnnotation(Class<T> annClass) {
        return AnnotationUtils.findMethodAnnotation(annClass, this.method, annClass);
    }

    public <T extends Annotation> T findClassAnnotation(Class<T> annClass) {
        return AnnotationUtils.findAnnotation(this.target.getClass(), annClass);
    }

    public <T extends Annotation> T findAnnotation(Class<T> annClass) {
        return AnnotationUtils.findAnnotation(this.target.getClass(), this.method, annClass);
    }

    public MethodInterceptorContext createParamContext() {
        return this.createParamContext(null);
    }

    public MethodInterceptorContext createParamContext(final Object invokeResult) {
        return new MethodInterceptorContext(){
            private static final long serialVersionUID = -4102787561601219273L;
            private Object result;
            {
                this.result = invokeResult;
            }

            @Override
            public Object[] getArguments() {
                return MethodInterceptorHolder.this.arguments;
            }

            @Override
            public boolean handleReactiveArguments(Function<Publisher<?>, Publisher<?>> handler) {
                boolean handled = false;
                Object[] args = this.getArguments();
                if (args == null || args.length == 0) {
                    return false;
                }
                for (int i = 0; i < args.length; ++i) {
                    Object arg = args[i];
                    if (!(arg instanceof Publisher)) continue;
                    args[i] = handler.apply((Publisher)arg);
                    handled = true;
                }
                return handled;
            }

            @Override
            public Object getTarget() {
                return MethodInterceptorHolder.this.target;
            }

            @Override
            public Method getMethod() {
                return MethodInterceptorHolder.this.method;
            }

            @Override
            public <T> Optional<T> getArgument(String name) {
                if (MethodInterceptorHolder.this.namedArguments == null) {
                    return Optional.empty();
                }
                return Optional.ofNullable(MethodInterceptorHolder.this.namedArguments.get(name));
            }

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> annClass) {
                return MethodInterceptorHolder.this.findAnnotation(annClass);
            }

            @Override
            public Map<String, Object> getNamedArguments() {
                return MethodInterceptorHolder.this.getNamedArguments();
            }

            @Override
            public Object getInvokeResult() {
                return this.result;
            }

            @Override
            public void setInvokeResult(Object result) {
                this.result = result;
            }
        };
    }

    public MethodInterceptorHolder(String id, Method method, Object target, Object[] arguments, String[] argumentsNames, Map<String, Object> namedArguments) {
        this.id = id;
        this.method = method;
        this.target = target;
        this.arguments = arguments;
        this.argumentsNames = argumentsNames;
        this.namedArguments = namedArguments;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object getTarget() {
        return this.target;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public String[] getArgumentsNames() {
        return this.argumentsNames;
    }
}

