/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.id;

import io.netty.util.concurrent.FastThreadLocal;
import java.time.Duration;
import java.util.Base64;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.codec.binary.Base64;
import org.hswebframework.web.id.IDGenerator;

public class RandomIdGenerator
implements IDGenerator<String> {
    static final RandomIdGenerator GLOBAL = new RandomIdGenerator(Integer.getInteger("generator.random.instance-id", ThreadLocalRandom.current().nextInt(1, 127)).byteValue());
    static final Base64.Encoder encoder = java.util.Base64.getUrlEncoder().withoutPadding();
    private static final FastThreadLocal<byte[]> HOLDER = new FastThreadLocal<byte[]>(){

        protected byte[] initialValue() {
            return new byte[24];
        }
    };
    private final byte instanceId;

    public static RandomIdGenerator create(byte instanceId) {
        return new RandomIdGenerator(instanceId);
    }

    @Override
    public String generate() {
        long now = System.currentTimeMillis();
        byte[] value = (byte[])HOLDER.get();
        value[0] = this.instanceId;
        value[1] = (byte)(now >>> 32);
        value[2] = (byte)(now >>> 24);
        value[3] = (byte)(now >>> 16);
        value[4] = (byte)(now >>> 8);
        value[5] = (byte)now;
        RandomIdGenerator.nextBytes(value, 6, 8);
        RandomIdGenerator.nextBytes(value, 8, 16);
        RandomIdGenerator.nextBytes(value, 16, 24);
        return encoder.encodeToString(value);
    }

    public static boolean isRandomId(String id) {
        if (id.length() < 16 || id.length() > 48) {
            return false;
        }
        return Base64.isBase64((String)id);
    }

    public static boolean timestampRangeOf(String id, Duration duration) {
        try {
            long ts;
            if (!RandomIdGenerator.isRandomId(id)) {
                return false;
            }
            long now = System.currentTimeMillis();
            return Math.abs(now - (ts = RandomIdGenerator.getTimestampInId(id))) <= duration.toMillis();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static long getTimestampInId(String id) {
        byte[] bytes = java.util.Base64.getUrlDecoder().decode(id);
        if (bytes.length < 6) {
            return -1L;
        }
        long now = System.currentTimeMillis();
        return (now >>> 56 & 0xFFL) << 56 | (now >>> 48 & 0xFFL) << 48 | (now >>> 40 & 0xFFL) << 40 | ((long)bytes[1] & 0xFFL) << 32 | ((long)bytes[2] & 0xFFL) << 24 | ((long)bytes[3] & 0xFFL) << 16 | ((long)bytes[4] & 0xFFL) << 8 | (long)bytes[5] & 0xFFL;
    }

    private static void nextBytes(byte[] bytes, int offset, int len) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int i = offset;
        while (i < len) {
            int rnd = random.nextInt();
            int n = Math.min(len - i, 4);
            while (n-- > 0) {
                bytes[i++] = (byte)rnd;
                rnd >>= 8;
            }
        }
    }

    private RandomIdGenerator(byte instanceId) {
        this.instanceId = instanceId;
    }
}

