/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.id;

import java.util.UUID;
import org.hswebframework.web.id.RandomIdGenerator;
import org.hswebframework.web.id.SnowflakeIdGenerator;
import org.hswebframework.web.utils.DigestUtils;

@FunctionalInterface
public interface IDGenerator<T> {
    public static final IDGenerator<?> NULL = () -> null;
    public static final IDGenerator<String> UUID = () -> java.util.UUID.randomUUID().toString();
    public static final IDGenerator<String> RANDOM = RandomIdGenerator.GLOBAL;
    public static final IDGenerator<String> MD5 = () -> DigestUtils.md5Hex(UUID.generate());
    public static final IDGenerator<Long> SNOW_FLAKE = SnowflakeIdGenerator.getInstance()::nextId;
    public static final IDGenerator<String> SNOW_FLAKE_STRING = () -> String.valueOf(SNOW_FLAKE.generate());
    public static final IDGenerator<String> SNOW_FLAKE_HEX = () -> Long.toHexString(SNOW_FLAKE.generate());

    public T generate();

    public static <T> IDGenerator<T> getNullGenerator() {
        return NULL;
    }
}

