/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.exception;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import org.hswebframework.web.exception.I18nSupportException;
import org.hswebframework.web.i18n.LocaleUtils;
import org.springframework.http.HttpStatus;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ResponseStatus;

@ResponseStatus(value=HttpStatus.BAD_REQUEST)
public class ValidationException
extends I18nSupportException {
    private static final boolean propertyI18nEnabled = Boolean.getBoolean("i18n.validation.property.enabled");
    private List<Detail> details;

    public ValidationException(String message) {
        super(message, new Object[0]);
    }

    public ValidationException(String property, String message, Object ... args) {
        this(message, Collections.singletonList(new Detail(property, message, null)), args);
    }

    public ValidationException(String message, List<Detail> details, Object ... args) {
        super(message, args);
        this.details = details;
    }

    public ValidationException(Set<? extends ConstraintViolation<?>> violations) {
        ConstraintViolation<?> first = violations.iterator().next();
        if (Objects.equals(first.getMessageTemplate(), first.getMessage())) {
            this.setI18nCode(first.getMessage());
        } else {
            this.setI18nCode("validation.property_validate_failed");
        }
        String property = first.getPropertyPath().toString();
        String propertyI18n = propertyI18nEnabled ? first.getRootBeanClass().getName() + "." + property : property;
        this.setArgs(new Object[]{propertyI18n, first.getMessage()});
        this.details = new ArrayList<Detail>(violations.size());
        for (ConstraintViolation<?> violation : violations) {
            this.details.add(new Detail(violation.getPropertyPath().toString(), violation.getMessage(), null));
        }
    }

    public List<Detail> getDetails(Locale locale) {
        return CollectionUtils.isEmpty(this.details) ? Collections.emptyList() : this.details.stream().map(detail -> detail.translateI18n(locale)).collect(Collectors.toList());
    }

    @Override
    public String getLocalizedMessage(Locale locale) {
        if (propertyI18nEnabled && "validation.property_validate_failed".equals(this.getI18nCode()) && this.getArgs().length > 0) {
            Object[] args = (Object[])this.getArgs().clone();
            args[0] = LocaleUtils.resolveMessage(String.valueOf(args[0]), locale, String.valueOf(args[0]), new Object[0]);
            return LocaleUtils.resolveMessage(this.getI18nCode(), locale, this.getOriginalMessage(), args);
        }
        return super.getLocalizedMessage(locale);
    }

    public List<Detail> getDetails() {
        return this.details;
    }

    public void setDetails(List<Detail> details) {
        this.details = details;
    }

    public static class Detail {
        @Schema(description="\u5b57\u6bb5")
        String property;
        @Schema(description="\u8bf4\u660e")
        String message;
        @Schema(description="\u8be6\u60c5")
        Object detail;

        public Detail translateI18n(Locale locale) {
            if (StringUtils.hasText((String)this.message) && this.message.contains(".")) {
                return new Detail(this.property, LocaleUtils.resolveMessage(this.message, locale, this.message, new Object[0]), this.detail);
            }
            return this;
        }

        public String getProperty() {
            return this.property;
        }

        public String getMessage() {
            return this.message;
        }

        public Object getDetail() {
            return this.detail;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public void setDetail(Object detail) {
            this.detail = detail;
        }

        public Detail(String property, String message, Object detail) {
            this.property = property;
            this.message = message;
            this.detail = detail;
        }
    }
}

