/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.exception;

import java.util.Locale;
import org.hswebframework.web.exception.TraceSourceException;
import org.hswebframework.web.i18n.LocaleUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public class I18nSupportException
extends TraceSourceException {
    private String i18nCode;
    private Object[] args;

    protected I18nSupportException() {
    }

    public I18nSupportException(String code, Object ... args) {
        super(code);
        this.i18nCode = code;
        this.args = args;
    }

    public I18nSupportException(String code, Throwable cause, Object ... args) {
        super(code, cause);
        this.args = args;
        this.i18nCode = code;
    }

    public String getOriginalMessage() {
        return super.getMessage() != null ? super.getMessage() : this.getI18nCode();
    }

    @Override
    public String getMessage() {
        return super.getMessage() != null ? super.getMessage() : this.getLocalizedMessage();
    }

    @Override
    public final String getLocalizedMessage() {
        return this.getLocalizedMessage(LocaleUtils.current());
    }

    public String getLocalizedMessage(Locale locale) {
        return LocaleUtils.resolveMessage(this.i18nCode, locale, this.getOriginalMessage(), this.args);
    }

    public final Mono<String> getLocalizedMessageReactive() {
        return LocaleUtils.currentReactive().map(this::getLocalizedMessage);
    }

    public static String tryGetLocalizedMessage(Throwable error, Locale locale) {
        if (error instanceof I18nSupportException) {
            return ((I18nSupportException)error).getLocalizedMessage(locale);
        }
        String msg = error.getMessage();
        if (!StringUtils.hasText((String)msg)) {
            msg = "error." + error.getClass().getSimpleName();
        }
        if (msg.contains(".")) {
            return LocaleUtils.resolveMessage(msg, locale, msg, new Object[0]);
        }
        return msg;
    }

    public static String tryGetLocalizedMessage(Throwable error) {
        return I18nSupportException.tryGetLocalizedMessage(error, LocaleUtils.current());
    }

    public static Mono<String> tryGetLocalizedMessageReactive(Throwable error) {
        return LocaleUtils.currentReactive().map(locale -> I18nSupportException.tryGetLocalizedMessage(error, locale));
    }

    public String getI18nCode() {
        return this.i18nCode;
    }

    public Object[] getArgs() {
        return this.args;
    }

    protected void setI18nCode(String i18nCode) {
        this.i18nCode = i18nCode;
    }

    protected void setArgs(Object[] args) {
        this.args = args;
    }
}

