/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.bean;

import com.alibaba.fastjson.JSON;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.hswebframework.utils.time.DateFormatter;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.bean.ToString;
import org.hswebframework.web.bean.ToStringOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public class DefaultToStringOperator<T>
implements ToStringOperator<T> {
    private static final Logger log = LoggerFactory.getLogger(DefaultToStringOperator.class);
    private final PropertyDescriptor[] descriptors;
    private Set<String> defaultIgnoreProperties;
    private long defaultFeatures = ToString.DEFAULT_FEATURE;
    private Map<String, PropertyDescriptor> descriptorMap;
    private Map<String, BiFunction<Object, ConvertConfig, Object>> converts;
    private final Function<Object, String> coverStringConvert = o -> DefaultToStringOperator.coverString(String.valueOf(o), 80.0);
    private final Function<Class<?>, BiFunction<Object, ConvertConfig, Object>> simpleConvertBuilder = type -> {
        if (Date.class.isAssignableFrom((Class<?>)type)) {
            return (value, f) -> DateFormatter.toString((Date)((Date)value), (String)"yyyy-MM-dd HH:mm:ss");
        }
        return (value, f) -> value;
    };
    private final Predicate<Class<?>> simpleTypePredicate = ((Predicate<Class>)String.class::isAssignableFrom).or(Class::isEnum).or(Class::isPrimitive).or(Date.class::isAssignableFrom).or(Number.class::isAssignableFrom).or(Boolean.class::isAssignableFrom);
    private final Class<T> targetType;

    public DefaultToStringOperator(Class<T> targetType) {
        this.targetType = targetType;
        this.descriptors = BeanUtils.getPropertyDescriptors(targetType);
        this.init();
    }

    public static String coverString(String str, double percent) {
        if (str.length() == 1) {
            return "*";
        }
        if (percent > 1.0) {
            percent /= 100.0;
        }
        percent = 1.0 - percent;
        long size = Math.round((double)str.length() * percent);
        long end = (long)str.length() - size / 2L;
        long start = (long)str.length() - end;
        start = start == 0L && percent > 0.0 ? 1L : start;
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if ((long)i < start || (long)i > end - 1L) continue;
            chars[i] = 42;
        }
        return new String(chars);
    }

    protected void init() {
        this.converts = new HashMap<String, BiFunction<Object, ConvertConfig, Object>>();
        this.descriptorMap = Arrays.stream(this.descriptors).collect(Collectors.toMap(FeatureDescriptor::getName, Function.identity()));
        ToString.Ignore classIgnore = (ToString.Ignore)AnnotationUtils.getAnnotation(this.targetType, ToString.Ignore.class);
        ToString.Features features = (ToString.Features)AnnotationUtils.getAnnotation(this.targetType, ToString.Features.class);
        this.defaultFeatures = null != features && features.value().length > 0 ? ToString.Feature.createFeatures(features.value()) : ToString.DEFAULT_FEATURE;
        this.defaultIgnoreProperties = classIgnore == null ? new HashSet<String>(new HashSet()) : new HashSet<String>(Arrays.asList(classIgnore.value()));
        boolean defaultCover = classIgnore != null && classIgnore.cover();
        for (PropertyDescriptor descriptor : this.descriptors) {
            BiFunction<Object, ConvertConfig, Object> convert;
            if ("class".equals(descriptor.getName())) continue;
            Class<?> propertyType = descriptor.getPropertyType();
            String propertyName = descriptor.getName();
            ToString.Ignore propertyIgnore = null;
            long propertyFeature = 0L;
            try {
                Field field = ReflectionUtils.findField(this.targetType, (String)descriptor.getName());
                propertyIgnore = field.getAnnotation(ToString.Ignore.class);
                features = (ToString.Features)AnnotationUtils.getAnnotation((AnnotatedElement)field, ToString.Features.class);
                if (propertyIgnore != null) {
                    for (String val : propertyIgnore.value()) {
                        this.defaultIgnoreProperties.add(field.getName().concat(".").concat(val));
                    }
                }
                if (null != features && features.value().length > 0) {
                    propertyFeature = ToString.Feature.createFeatures(features.value());
                }
            }
            catch (Exception field) {
                // empty catch block
            }
            boolean cover = propertyIgnore == null && defaultCover || propertyIgnore != null && propertyIgnore.cover();
            boolean hide = propertyIgnore != null;
            long finalPropertyFeature = propertyFeature;
            if (this.simpleTypePredicate.test(propertyType)) {
                BiFunction<Object, ConvertConfig, Object> simpleConvert = this.simpleConvertBuilder.apply(propertyType);
                convert = (value, f) -> {
                    long feature = finalPropertyFeature == 0L ? f.features : finalPropertyFeature;
                    value = simpleConvert.apply(value, (ConvertConfig)f);
                    if (hide || f.ignoreProperty.contains(propertyName)) {
                        if (ToString.Feature.hasFeature(feature, ToString.Feature.coverIgnoreProperty)) {
                            return this.coverStringConvert.apply(value);
                        }
                        return null;
                    }
                    return value;
                };
            } else {
                boolean toStringOverride = false;
                try {
                    toStringOverride = propertyType.getMethod("toString", new Class[0]).getDeclaringClass() != Object.class;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                boolean finalToStringOverride = toStringOverride;
                boolean justReturn = propertyType.isArray() || Collection.class.isAssignableFrom(propertyType) || Map.class.isAssignableFrom(propertyType);
                convert = (value, f) -> {
                    if (f.ignoreProperty.contains(propertyName)) {
                        return null;
                    }
                    long feature = finalPropertyFeature == 0L ? f.features : finalPropertyFeature;
                    boolean jsonFormat = ToString.Feature.hasFeature(feature, ToString.Feature.jsonFormat);
                    boolean propertyJsonFormat = ToString.Feature.hasFeature(finalPropertyFeature, ToString.Feature.jsonFormat);
                    if (ToString.Feature.hasFeature(f.features, ToString.Feature.disableNestProperty)) {
                        return null;
                    }
                    if (!jsonFormat && finalToStringOverride) {
                        return String.valueOf(value);
                    }
                    Set<String> newIgnoreProperty = f.ignoreProperty.stream().filter(property -> property.startsWith(propertyName.concat("."))).map(property -> property.substring(propertyName.length() + 1)).collect(Collectors.toSet());
                    if (justReturn) {
                        if (value instanceof Object[]) {
                            value = Arrays.asList((Object[])value);
                        }
                        if (value instanceof Map) {
                            value = this.convertMap((Map)value, feature, newIgnoreProperty);
                        }
                        if (value instanceof Collection) {
                            value = ((Collection)value).stream().map(val -> {
                                if (val instanceof Map) {
                                    return this.convertMap((Map)val, feature, newIgnoreProperty);
                                }
                                if (this.simpleTypePredicate.test(val.getClass())) {
                                    return val;
                                }
                                ToStringOperator<?> operator = ToString.getOperator(val.getClass());
                                if (operator instanceof DefaultToStringOperator) {
                                    return ((DefaultToStringOperator)operator).toMap(val, feature, newIgnoreProperty);
                                }
                                return operator.toString(val, feature, newIgnoreProperty);
                            }).collect(Collectors.toList());
                        }
                        if (value instanceof Map) {
                            value = this.convertMap((Map)value, feature, newIgnoreProperty);
                        }
                        if (propertyJsonFormat) {
                            return JSON.toJSONString((Object)value);
                        }
                        return value;
                    }
                    ToStringOperator<?> operator = ToString.getOperator(value.getClass());
                    if (!propertyJsonFormat && operator instanceof DefaultToStringOperator) {
                        return ((DefaultToStringOperator)operator).toMap(value, feature, newIgnoreProperty);
                    }
                    return operator.toString(value, feature, newIgnoreProperty);
                };
            }
            this.converts.put(descriptor.getName(), convert);
        }
    }

    protected Map<String, Object> convertMap(Map<String, Object> obj, long features, Set<String> ignoreProperty) {
        if (ignoreProperty.isEmpty()) {
            return obj;
        }
        boolean cover = ToString.Feature.hasFeature(features, ToString.Feature.coverIgnoreProperty);
        boolean isNullPropertyToEmpty = ToString.Feature.hasFeature(features, ToString.Feature.nullPropertyToEmpty);
        boolean isDisableNestProperty = ToString.Feature.hasFeature(features, ToString.Feature.disableNestProperty);
        HashMap<String, Object> newMap = new HashMap<String, Object>(obj);
        HashSet<String> ignore = new HashSet<String>(ignoreProperty.size());
        ignore.addAll(this.defaultIgnoreProperties);
        for (Map.Entry entry : newMap.entrySet()) {
            Object value = entry.getValue();
            if (value == null) {
                if (!isNullPropertyToEmpty) continue;
                entry.setValue("");
                continue;
            }
            Class<?> type = value.getClass();
            if (this.simpleTypePredicate.test(type)) {
                value = this.simpleConvertBuilder.apply(type).apply(value, null);
                if (!ignoreProperty.contains(entry.getKey())) continue;
                if (cover) {
                    value = this.coverStringConvert.apply(value);
                } else {
                    ignore.add((String)entry.getKey());
                }
                entry.setValue((String)value);
                continue;
            }
            if (!isDisableNestProperty) continue;
            ignore.add((String)entry.getKey());
        }
        ignore.forEach(newMap::remove);
        return newMap;
    }

    protected Map<String, Object> toMap(T target, long features, Set<String> ignoreProperty) {
        Map map = target instanceof Map ? (Map)target : (Map)FastBeanCopier.copy(target, new LinkedHashMap(), new String[0]);
        Set<String> ignore = ignoreProperty == null || ignoreProperty.isEmpty() ? this.defaultIgnoreProperties : ignoreProperty;
        ConvertConfig convertConfig = new ConvertConfig();
        convertConfig.ignoreProperty = ignore;
        convertConfig.features = features == -1L ? this.defaultFeatures : features;
        HashSet realIgnore = new HashSet();
        for (Map.Entry entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value == null) {
                if (!ToString.Feature.hasFeature(features, ToString.Feature.nullPropertyToEmpty)) continue;
                boolean isSimpleType = false;
                PropertyDescriptor propertyDescriptor = this.descriptorMap.get(entry.getKey());
                Class<?> propertyType = null;
                if (propertyDescriptor != null) {
                    propertyType = propertyDescriptor.getPropertyType();
                    isSimpleType = this.simpleTypePredicate.test(propertyType);
                }
                if (isSimpleType || propertyType == null) {
                    entry.setValue("");
                    continue;
                }
                if (propertyType.isArray() || Collection.class.isAssignableFrom(propertyType)) {
                    entry.setValue(new ArrayList());
                    continue;
                }
                entry.setValue(new HashMap());
                continue;
            }
            BiFunction<Object, ConvertConfig, Object> converter = this.converts.get(entry.getKey());
            if (null != converter) {
                entry.setValue(converter.apply(value, convertConfig));
            }
            if (entry.getValue() != null) continue;
            realIgnore.add(entry.getKey());
        }
        realIgnore.forEach(map::remove);
        return map;
    }

    @Override
    public String toString(T target, long features, Set<String> ignoreProperty) {
        if (target == null) {
            return "";
        }
        if (features == -1L) {
            features = this.defaultFeatures;
        }
        Map<String, Object> mapValue = this.toMap(target, features, ignoreProperty);
        if (ToString.Feature.hasFeature(features, ToString.Feature.jsonFormat)) {
            return JSON.toJSONString(mapValue);
        }
        boolean writeClassName = ToString.Feature.hasFeature(features, ToString.Feature.writeClassname);
        StringJoiner joiner = new StringJoiner(", ", (writeClassName ? target.getClass().getSimpleName() : "") + "{", "}");
        mapValue.forEach((key, value) -> joiner.add(key.concat("=").concat(String.valueOf(value))));
        return joiner.toString();
    }

    static class ConvertConfig {
        long features;
        Set<String> ignoreProperty;

        ConvertConfig() {
        }
    }
}

