/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.handler;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hswebframework.web.authorization.define.AuthorizingContext;
import org.hswebframework.web.authorization.define.HandleType;
import org.hswebframework.web.authorization.events.AuthorizingHandleBeforeEvent;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.event.EventListener;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.ClassUtils;
import org.springframework.util.PathMatcher;

@ConfigurationProperties(value="hsweb.authorize")
public class UserAllowPermissionHandler {
    private Map<String, Map<String, String>> allows = new HashMap<String, Map<String, String>>();
    private final PathMatcher pathMatcher = new AntPathMatcher(".");

    @EventListener
    public void handEvent(AuthorizingHandleBeforeEvent event) {
        if (this.allows.isEmpty() || event.getHandleType() == HandleType.DATA) {
            return;
        }
        AuthorizingContext context = event.getContext();
        String path = ClassUtils.getUserClass((Object)context.getParamContext().getTarget()).getName().concat(".").concat(context.getParamContext().getMethod().getName());
        AtomicBoolean allow = new AtomicBoolean();
        for (Map.Entry<String, Map<String, String>> entry : this.allows.entrySet()) {
            String dimension = entry.getKey();
            if ("user".equals(dimension)) {
                String userId = context.getAuthentication().getUser().getId();
                allow.set(Optional.ofNullable(entry.getValue().get(userId)).filter(pattern -> "*".equals(pattern) || this.pathMatcher.match(pattern, path)).isPresent());
            } else {
                for (Map.Entry<String, String> confEntry : entry.getValue().entrySet()) {
                    context.getAuthentication().getDimension(dimension, confEntry.getKey()).ifPresent(dim -> {
                        String pattern = (String)confEntry.getValue();
                        allow.set("*".equals(pattern) || this.pathMatcher.match((String)confEntry.getValue(), path));
                    });
                }
            }
            if (!allow.get()) continue;
            event.setAllow(true);
            return;
        }
    }

    public Map<String, Map<String, String>> getAllows() {
        return this.allows;
    }

    public void setAllows(Map<String, Map<String, String>> allows) {
        this.allows = allows;
    }
}

