/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.authorization.basic.define;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.DataAccess;
import org.hswebframework.web.authorization.annotation.DataAccessType;
import org.hswebframework.web.authorization.annotation.Dimension;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.authorization.annotation.ResourceAction;
import org.hswebframework.web.authorization.basic.define.AopAuthorizeDefinitionParser;
import org.hswebframework.web.authorization.define.AopAuthorizeDefinition;
import org.hswebframework.web.authorization.define.DataAccessTypeDefinition;
import org.hswebframework.web.authorization.define.DimensionDefinition;
import org.hswebframework.web.authorization.define.DimensionsDefinition;
import org.hswebframework.web.authorization.define.Phased;
import org.hswebframework.web.authorization.define.ResourceActionDefinition;
import org.hswebframework.web.authorization.define.ResourceDefinition;
import org.hswebframework.web.authorization.define.ResourcesDefinition;
import org.springframework.util.StringUtils;

public class DefaultBasicAuthorizeDefinition
implements AopAuthorizeDefinition {
    @JsonIgnore
    private Class<?> targetClass;
    @JsonIgnore
    private Method targetMethod;
    private ResourcesDefinition resources = new ResourcesDefinition();
    private DimensionsDefinition dimensions = new DimensionsDefinition();
    private String message = "error.access_denied";
    private Phased phased = Phased.before;
    private static final Set<Class<? extends Annotation>> types = new HashSet<Class>(Arrays.asList(Authorize.class, DataAccess.class, Dimension.class, Resource.class, ResourceAction.class, DataAccessType.class));

    public boolean isEmpty() {
        return false;
    }

    public static AopAuthorizeDefinition from(Class<?> targetClass, Method method) {
        AopAuthorizeDefinitionParser parser = new AopAuthorizeDefinitionParser(targetClass, method);
        return parser.parse();
    }

    public void putAnnotation(Authorize ann) {
        if (!ann.merge()) {
            this.getResources().getResources().clear();
            this.getDimensions().getDimensions().clear();
        }
        this.setPhased(ann.phased());
        this.getResources().setPhased(ann.phased());
        for (Resource resource : ann.resources()) {
            this.putAnnotation(resource);
        }
        for (Resource resource : ann.dimension()) {
            this.putAnnotation((Dimension)resource);
        }
    }

    public void putAnnotation(Dimension ann) {
        if (ann.ignore()) {
            this.getDimensions().getDimensions().clear();
            return;
        }
        DimensionDefinition definition = new DimensionDefinition();
        definition.setTypeId(ann.type());
        definition.setDimensionId(new HashSet<String>(Arrays.asList(ann.id())));
        definition.setLogical(ann.logical());
        this.getDimensions().addDimension(definition);
    }

    public void putAnnotation(Resource ann) {
        ResourceDefinition resource = new ResourceDefinition();
        resource.setId(ann.id());
        resource.setName(ann.name());
        resource.setLogical(ann.logical());
        resource.setPhased(ann.phased());
        resource.setDescription(String.join((CharSequence)"\n", ann.description()));
        for (ResourceAction action : ann.actions()) {
            this.putAnnotation(resource, action);
        }
        resource.setGroup(new ArrayList<String>(Arrays.asList(ann.group())));
        this.setPhased(ann.phased());
        this.getResources().setPhased(ann.phased());
        this.resources.addResource(resource, ann.merge());
    }

    public ResourceActionDefinition putAnnotation(ResourceDefinition definition, ResourceAction ann) {
        ResourceActionDefinition actionDefinition = new ResourceActionDefinition();
        actionDefinition.setId(ann.id());
        actionDefinition.setName(ann.name());
        actionDefinition.setDescription(String.join((CharSequence)"\n", ann.description()));
        for (DataAccess dataAccess : ann.dataAccess()) {
            this.putAnnotation(actionDefinition, dataAccess);
        }
        definition.addAction(actionDefinition);
        return actionDefinition;
    }

    public void putAnnotation(ResourceActionDefinition definition, DataAccess ann) {
        if (ann.ignore()) {
            return;
        }
        DataAccessTypeDefinition typeDefinition = new DataAccessTypeDefinition();
        for (DataAccessType dataAccessType : ann.type()) {
            if (dataAccessType.ignore()) continue;
            typeDefinition.setId(dataAccessType.id());
            typeDefinition.setName(dataAccessType.name());
            typeDefinition.setController(dataAccessType.controller());
            typeDefinition.setConfiguration(dataAccessType.configuration());
            typeDefinition.setDescription(String.join((CharSequence)"\n", dataAccessType.description()));
        }
        if (StringUtils.isEmpty((Object)typeDefinition.getId())) {
            return;
        }
        definition.getDataAccess().getDataAccessTypes().add(typeDefinition);
    }

    public void putAnnotation(ResourceActionDefinition definition, DataAccessType dataAccessType) {
        if (dataAccessType.ignore()) {
            return;
        }
        DataAccessTypeDefinition typeDefinition = new DataAccessTypeDefinition();
        typeDefinition.setId(dataAccessType.id());
        typeDefinition.setName(dataAccessType.name());
        typeDefinition.setController(dataAccessType.controller());
        typeDefinition.setConfiguration(dataAccessType.configuration());
        typeDefinition.setDescription(String.join((CharSequence)"\n", dataAccessType.description()));
        definition.getDataAccess().getDataAccessTypes().add(typeDefinition);
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public Method getTargetMethod() {
        return this.targetMethod;
    }

    public ResourcesDefinition getResources() {
        return this.resources;
    }

    public DimensionsDefinition getDimensions() {
        return this.dimensions;
    }

    public String getMessage() {
        return this.message;
    }

    public Phased getPhased() {
        return this.phased;
    }

    public void setTargetClass(Class<?> targetClass) {
        this.targetClass = targetClass;
    }

    public void setTargetMethod(Method targetMethod) {
        this.targetMethod = targetMethod;
    }

    public void setResources(ResourcesDefinition resources) {
        this.resources = resources;
    }

    public void setDimensions(DimensionsDefinition dimensions) {
        this.dimensions = dimensions;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setPhased(Phased phased) {
        this.phased = phased;
    }

    public DefaultBasicAuthorizeDefinition() {
    }

    public DefaultBasicAuthorizeDefinition(Class<?> targetClass, Method targetMethod, ResourcesDefinition resources, DimensionsDefinition dimensions, String message, Phased phased) {
        this.targetClass = targetClass;
        this.targetMethod = targetMethod;
        this.resources = resources;
        this.dimensions = dimensions;
        this.message = message;
        this.phased = phased;
    }

    public String toString() {
        return "DefaultBasicAuthorizeDefinition(targetClass=" + this.getTargetClass() + ", targetMethod=" + this.getTargetMethod() + ", resources=" + this.getResources() + ", dimensions=" + this.getDimensions() + ", message=" + this.getMessage() + ", phased=" + this.getPhased() + ")";
    }
}

