/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection.internal;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.hibernate.HibernateException;
import org.hibernate.collection.internal.AbstractPersistentCollection;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.loader.CollectionAliases;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.Type;

public class PersistentBag
extends AbstractPersistentCollection
implements List {
    protected List bag;

    public PersistentBag(SessionImplementor session) {
        super(session);
    }

    public PersistentBag(SessionImplementor session, Collection coll) {
        super(session);
        if (coll instanceof List) {
            this.bag = (List)coll;
        } else {
            this.bag = new ArrayList();
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                this.bag.add(iter.next());
            }
        }
        this.setInitialized();
        this.setDirectlyAccessible(true);
    }

    public PersistentBag() {
    }

    @Override
    public boolean isWrapper(Object collection) {
        return this.bag == collection;
    }

    @Override
    public boolean empty() {
        return this.bag.isEmpty();
    }

    @Override
    public Iterator entries(CollectionPersister persister) {
        return this.bag.iterator();
    }

    @Override
    public Object readFrom(ResultSet rs, CollectionPersister persister, CollectionAliases descriptor, Object owner) throws HibernateException, SQLException {
        Object element = persister.readElement(rs, owner, descriptor.getSuffixedElementAliases(), this.getSession());
        if (element != null) {
            this.bag.add(element);
        }
        return element;
    }

    @Override
    public void beforeInitialize(CollectionPersister persister, int anticipatedSize) {
        this.bag = (List)persister.getCollectionType().instantiate(anticipatedSize);
    }

    @Override
    public boolean equalsSnapshot(CollectionPersister persister) throws HibernateException {
        Type elementType = persister.getElementType();
        List sn = (List)((Object)this.getSnapshot());
        if (sn.size() != this.bag.size()) {
            return false;
        }
        for (Object elt : this.bag) {
            boolean unequal = this.countOccurrences(elt, this.bag, elementType) != this.countOccurrences(elt, sn, elementType);
            if (!unequal) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSnapshotEmpty(Serializable snapshot) {
        return ((Collection)((Object)snapshot)).isEmpty();
    }

    private int countOccurrences(Object element, List list, Type elementType) throws HibernateException {
        Iterator iter = list.iterator();
        int result = 0;
        while (iter.hasNext()) {
            if (!elementType.isSame(element, iter.next())) continue;
            ++result;
        }
        return result;
    }

    @Override
    public Serializable getSnapshot(CollectionPersister persister) throws HibernateException {
        ArrayList<Object> clonedList = new ArrayList<Object>(this.bag.size());
        Iterator iter = this.bag.iterator();
        while (iter.hasNext()) {
            clonedList.add(persister.getElementType().deepCopy(iter.next(), persister.getFactory()));
        }
        return clonedList;
    }

    @Override
    public Collection getOrphans(Serializable snapshot, String entityName) throws HibernateException {
        List sn = (List)((Object)snapshot);
        return PersistentBag.getOrphans(sn, this.bag, entityName, this.getSession());
    }

    @Override
    public Serializable disassemble(CollectionPersister persister) throws HibernateException {
        int length = this.bag.size();
        Serializable[] result = new Serializable[length];
        for (int i = 0; i < length; ++i) {
            result[i] = persister.getElementType().disassemble(this.bag.get(i), this.getSession(), null);
        }
        return result;
    }

    @Override
    public void initializeFromCache(CollectionPersister persister, Serializable disassembled, Object owner) throws HibernateException {
        Serializable[] array = (Serializable[])disassembled;
        int size = array.length;
        this.beforeInitialize(persister, size);
        for (int i = 0; i < size; ++i) {
            Object element = persister.getElementType().assemble(array[i], this.getSession(), owner);
            if (element == null) continue;
            this.bag.add(element);
        }
    }

    @Override
    public boolean needsRecreate(CollectionPersister persister) {
        return !persister.isOneToMany();
    }

    @Override
    public Iterator getDeletes(CollectionPersister persister, boolean indexIsFormula) throws HibernateException {
        Type elementType = persister.getElementType();
        ArrayList deletes = new ArrayList();
        List sn = (List)((Object)this.getSnapshot());
        Iterator olditer = sn.iterator();
        int i = 0;
        while (olditer.hasNext()) {
            Object old = olditer.next();
            Iterator newiter = this.bag.iterator();
            boolean found = false;
            if (this.bag.size() > i && elementType.isSame(old, this.bag.get(i++))) {
                found = true;
            } else {
                while (newiter.hasNext()) {
                    if (!elementType.isSame(old, newiter.next())) continue;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            deletes.add(old);
        }
        return deletes.iterator();
    }

    @Override
    public boolean needsInserting(Object entry, int i, Type elemType) throws HibernateException {
        List sn = (List)((Object)this.getSnapshot());
        if (sn.size() > i && elemType.isSame(sn.get(i), entry)) {
            return false;
        }
        for (Object old : sn) {
            if (!elemType.isSame(old, entry)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isRowUpdatePossible() {
        return false;
    }

    @Override
    public boolean needsUpdating(Object entry, int i, Type elemType) {
        return false;
    }

    @Override
    public int size() {
        return this.readSize() ? this.getCachedSize() : this.bag.size();
    }

    @Override
    public boolean isEmpty() {
        return this.readSize() ? this.getCachedSize() == 0 : this.bag.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        Boolean exists = this.readElementExistence(object);
        return exists == null ? this.bag.contains(object) : exists.booleanValue();
    }

    @Override
    public Iterator iterator() {
        this.read();
        return new AbstractPersistentCollection.IteratorProxy(this, this.bag.iterator());
    }

    @Override
    public Object[] toArray() {
        this.read();
        return this.bag.toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        this.read();
        return this.bag.toArray(a);
    }

    @Override
    public boolean add(Object object) {
        if (!this.isOperationQueueEnabled()) {
            this.write();
            return this.bag.add(object);
        }
        this.queueOperation(new SimpleAdd(object));
        return true;
    }

    @Override
    public boolean remove(Object o) {
        this.initialize(true);
        if (this.bag.remove(o)) {
            this.dirty();
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection c) {
        this.read();
        return this.bag.containsAll(c);
    }

    @Override
    public boolean addAll(Collection values) {
        if (values.size() == 0) {
            return false;
        }
        if (!this.isOperationQueueEnabled()) {
            this.write();
            return this.bag.addAll(values);
        }
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            this.queueOperation(new SimpleAdd(iter.next()));
        }
        return values.size() > 0;
    }

    @Override
    public boolean removeAll(Collection c) {
        if (c.size() > 0) {
            this.initialize(true);
            if (this.bag.removeAll(c)) {
                this.dirty();
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection c) {
        this.initialize(true);
        if (this.bag.retainAll(c)) {
            this.dirty();
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.isClearQueueEnabled()) {
            this.queueOperation(new Clear());
        } else {
            this.initialize(true);
            if (!this.bag.isEmpty()) {
                this.bag.clear();
                this.dirty();
            }
        }
    }

    @Override
    public Object getIndex(Object entry, int i, CollectionPersister persister) {
        throw new UnsupportedOperationException("Bags don't have indexes");
    }

    @Override
    public Object getElement(Object entry) {
        return entry;
    }

    @Override
    public Object getSnapshotElement(Object entry, int i) {
        List sn = (List)((Object)this.getSnapshot());
        return sn.get(i);
    }

    public int occurrences(Object o) {
        this.read();
        Iterator iter = this.bag.iterator();
        int result = 0;
        while (iter.hasNext()) {
            if (!o.equals(iter.next())) continue;
            ++result;
        }
        return result;
    }

    public void add(int i, Object o) {
        this.write();
        this.bag.add(i, o);
    }

    public boolean addAll(int i, Collection c) {
        if (c.size() > 0) {
            this.write();
            return this.bag.addAll(i, c);
        }
        return false;
    }

    public Object get(int i) {
        this.read();
        return this.bag.get(i);
    }

    @Override
    public int indexOf(Object o) {
        this.read();
        return this.bag.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        this.read();
        return this.bag.lastIndexOf(o);
    }

    public ListIterator listIterator() {
        this.read();
        return new AbstractPersistentCollection.ListIteratorProxy(this, this.bag.listIterator());
    }

    public ListIterator listIterator(int i) {
        this.read();
        return new AbstractPersistentCollection.ListIteratorProxy(this, this.bag.listIterator(i));
    }

    public Object remove(int i) {
        this.write();
        return this.bag.remove(i);
    }

    public Object set(int i, Object o) {
        this.write();
        return this.bag.set(i, o);
    }

    public List subList(int start, int end) {
        this.read();
        return new AbstractPersistentCollection.ListProxy(this, this.bag.subList(start, end));
    }

    public String toString() {
        this.read();
        return this.bag.toString();
    }

    @Override
    public boolean entryExists(Object entry, int i) {
        return entry != null;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    final class SimpleAdd
    implements AbstractPersistentCollection.DelayedOperation {
        private Object value;

        public SimpleAdd(Object value) {
            this.value = value;
        }

        @Override
        public void operate() {
            PersistentBag.this.bag.add(this.value);
        }

        @Override
        public Object getAddedInstance() {
            return this.value;
        }

        @Override
        public Object getOrphan() {
            return null;
        }
    }

    final class Clear
    implements AbstractPersistentCollection.DelayedOperation {
        Clear() {
        }

        @Override
        public void operate() {
            PersistentBag.this.bag.clear();
        }

        @Override
        public Object getAddedInstance() {
            return null;
        }

        @Override
        public Object getOrphan() {
            throw new UnsupportedOperationException("queued clear cannot be used with orphan delete");
        }
    }
}

