
/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later.
 * See the lgpl.txt file in the root directory or <http://www.gnu.org/licenses/lgpl-2.1.html>.
 */
package org.hibernate.grammars.graph;

import org.antlr.v4.runtime.tree.ParseTreeListener;

/**
 * This interface defines a complete listener for a parse tree produced by
 * {@link GraphLanguageParser}.
 */
public interface GraphLanguageParserListener extends ParseTreeListener {
	/**
	 * Enter a parse tree produced by {@link GraphLanguageParser#graph}.
	 * @param ctx the parse tree
	 */
	void enterGraph(GraphLanguageParser.GraphContext ctx);
	/**
	 * Exit a parse tree produced by {@link GraphLanguageParser#graph}.
	 * @param ctx the parse tree
	 */
	void exitGraph(GraphLanguageParser.GraphContext ctx);
	/**
	 * Enter a parse tree produced by {@link GraphLanguageParser#attributeList}.
	 * @param ctx the parse tree
	 */
	void enterAttributeList(GraphLanguageParser.AttributeListContext ctx);
	/**
	 * Exit a parse tree produced by {@link GraphLanguageParser#attributeList}.
	 * @param ctx the parse tree
	 */
	void exitAttributeList(GraphLanguageParser.AttributeListContext ctx);
	/**
	 * Enter a parse tree produced by {@link GraphLanguageParser#attributeNode}.
	 * @param ctx the parse tree
	 */
	void enterAttributeNode(GraphLanguageParser.AttributeNodeContext ctx);
	/**
	 * Exit a parse tree produced by {@link GraphLanguageParser#attributeNode}.
	 * @param ctx the parse tree
	 */
	void exitAttributeNode(GraphLanguageParser.AttributeNodeContext ctx);
	/**
	 * Enter a parse tree produced by {@link GraphLanguageParser#attributePath}.
	 * @param ctx the parse tree
	 */
	void enterAttributePath(GraphLanguageParser.AttributePathContext ctx);
	/**
	 * Exit a parse tree produced by {@link GraphLanguageParser#attributePath}.
	 * @param ctx the parse tree
	 */
	void exitAttributePath(GraphLanguageParser.AttributePathContext ctx);
	/**
	 * Enter a parse tree produced by {@link GraphLanguageParser#attributeQualifier}.
	 * @param ctx the parse tree
	 */
	void enterAttributeQualifier(GraphLanguageParser.AttributeQualifierContext ctx);
	/**
	 * Exit a parse tree produced by {@link GraphLanguageParser#attributeQualifier}.
	 * @param ctx the parse tree
	 */
	void exitAttributeQualifier(GraphLanguageParser.AttributeQualifierContext ctx);
	/**
	 * Enter a parse tree produced by {@link GraphLanguageParser#subGraph}.
	 * @param ctx the parse tree
	 */
	void enterSubGraph(GraphLanguageParser.SubGraphContext ctx);
	/**
	 * Exit a parse tree produced by {@link GraphLanguageParser#subGraph}.
	 * @param ctx the parse tree
	 */
	void exitSubGraph(GraphLanguageParser.SubGraphContext ctx);
	/**
	 * Enter a parse tree produced by {@link GraphLanguageParser#subType}.
	 * @param ctx the parse tree
	 */
	void enterSubType(GraphLanguageParser.SubTypeContext ctx);
	/**
	 * Exit a parse tree produced by {@link GraphLanguageParser#subType}.
	 * @param ctx the parse tree
	 */
	void exitSubType(GraphLanguageParser.SubTypeContext ctx);
}
