
package org.hibernate.boot.jaxb.mapping;

import java.io.Serializable;
import jakarta.persistence.ConstraintMode;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * 
 *                 See `@jakarta.persistence.ForeignKey`
 *             
 * 
 * <p>Java class for foreign-key complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="foreign-key">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="description" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *       </sequence>
 *       <attribute name="name" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="constraint-mode" type="{http://www.hibernate.org/xsd/orm/mapping}constraint-mode" />
 *       <attribute name="foreign-key-definition" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "foreign-key", namespace = "http://www.hibernate.org/xsd/orm/mapping", propOrder = {
    "description"
})
public class JaxbForeignKey
    implements Serializable
{

    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected String description;
    @XmlAttribute(name = "name")
    protected String name;
    @XmlAttribute(name = "constraint-mode")
    @XmlJavaTypeAdapter(Adapter5 .class)
    protected ConstraintMode constraintMode;
    @XmlAttribute(name = "foreign-key-definition")
    protected String foreignKeyDefinition;

    /**
     * Gets the value of the description property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDescription(String value) {
        this.description = value;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setName(String value) {
        this.name = value;
    }

    /**
     * Gets the value of the constraintMode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public ConstraintMode getConstraintMode() {
        return constraintMode;
    }

    /**
     * Sets the value of the constraintMode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setConstraintMode(ConstraintMode value) {
        this.constraintMode = value;
    }

    /**
     * Gets the value of the foreignKeyDefinition property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getForeignKeyDefinition() {
        return foreignKeyDefinition;
    }

    /**
     * Sets the value of the foreignKeyDefinition property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setForeignKeyDefinition(String value) {
        this.foreignKeyDefinition = value;
    }

}
