
package org.hibernate.boot.jaxb.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jakarta.persistence.AccessType;
import jakarta.persistence.EnumType;
import jakarta.persistence.FetchType;
import jakarta.persistence.TemporalType;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * 
 *                 See `jakarta.persistence.ElementCollection`
 *                 See `jakarta.persistence.OrderBy`
 *                 See `jakarta.persistence.OrderColumn`
 *                 See `@org.hibernate.annotations.AttributeAccessor`
 *                 See `@org.hibernate.annotations.OptimisticLock`
 *                 See `@org.hibernate.annotations.SortComparator`
 *                 See `@org.hibernate.annotations.SortNatural`
 *                 See `@jakarta.persistence.Lob`
 *                 See `@jakarta.persistence.Temporal`
 *                 See `@jakarta.persistence.Enumerated`
 *                 See `@jakarta.persistence.Convert`
 *                 See `@org.hibernate.annotations.Nationalized`
 *             
 * 
 * <p>Java class for element-collection complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="element-collection">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <choice>
 *           <element name="order-by" type="{http://www.hibernate.org/xsd/orm/mapping}order-by" minOccurs="0"/>
 *           <element name="order-column" type="{http://www.hibernate.org/xsd/orm/mapping}order-column" minOccurs="0"/>
 *           <element name="sort" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         </choice>
 *         <choice>
 *           <element name="map-key" type="{http://www.hibernate.org/xsd/orm/mapping}map-key" minOccurs="0"/>
 *           <sequence>
 *             <element name="map-key-class" type="{http://www.hibernate.org/xsd/orm/mapping}map-key-class" minOccurs="0"/>
 *             <choice>
 *               <element name="map-key-temporal" type="{http://www.hibernate.org/xsd/orm/mapping}temporal" minOccurs="0"/>
 *               <element name="map-key-enumerated" type="{http://www.hibernate.org/xsd/orm/mapping}enumerated" minOccurs="0"/>
 *               <sequence>
 *                 <element name="map-key-attribute-override" type="{http://www.hibernate.org/xsd/orm/mapping}attribute-override" maxOccurs="unbounded" minOccurs="0"/>
 *                 <element name="map-key-convert" type="{http://www.hibernate.org/xsd/orm/mapping}convert" maxOccurs="unbounded" minOccurs="0"/>
 *               </sequence>
 *             </choice>
 *             <choice>
 *               <choice>
 *                 <element name="map-key-column" type="{http://www.hibernate.org/xsd/orm/mapping}map-key-column" minOccurs="0"/>
 *                 <element name="map-key-formula" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *               </choice>
 *               <sequence>
 *                 <element name="map-key-join-column" type="{http://www.hibernate.org/xsd/orm/mapping}map-key-join-column" maxOccurs="unbounded" minOccurs="0"/>
 *                 <element name="map-key-foreign-key" type="{http://www.hibernate.org/xsd/orm/mapping}foreign-key" minOccurs="0"/>
 *               </sequence>
 *             </choice>
 *           </sequence>
 *         </choice>
 *         <choice>
 *           <sequence>
 *             <choice>
 *               <element name="column" type="{http://www.hibernate.org/xsd/orm/mapping}column" minOccurs="0"/>
 *               <element name="formula" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *             </choice>
 *             <choice>
 *               <element name="temporal" type="{http://www.hibernate.org/xsd/orm/mapping}temporal" minOccurs="0"/>
 *               <element name="enumerated" type="{http://www.hibernate.org/xsd/orm/mapping}enumerated" minOccurs="0"/>
 *               <element name="lob" type="{http://www.hibernate.org/xsd/orm/mapping}lob" minOccurs="0"/>
 *               <element name="nationalized" type="{http://www.hibernate.org/xsd/orm/mapping}nationalized" minOccurs="0"/>
 *             </choice>
 *           </sequence>
 *           <sequence>
 *             <element name="attribute-override" type="{http://www.hibernate.org/xsd/orm/mapping}attribute-override" maxOccurs="unbounded" minOccurs="0"/>
 *             <element name="association-override" type="{http://www.hibernate.org/xsd/orm/mapping}association-override" maxOccurs="unbounded" minOccurs="0"/>
 *             <element name="convert" type="{http://www.hibernate.org/xsd/orm/mapping}convert" maxOccurs="unbounded" minOccurs="0"/>
 *           </sequence>
 *         </choice>
 *         <element name="collection-table" type="{http://www.hibernate.org/xsd/orm/mapping}collection-table" minOccurs="0"/>
 *       </sequence>
 *       <attribute name="name" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="target-class" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="fetch" type="{http://www.hibernate.org/xsd/orm/mapping}fetch-type" />
 *       <attribute name="fetch-mode" type="{http://www.hibernate.org/xsd/orm/mapping}plural-fetch-mode" />
 *       <attribute name="access" type="{http://www.hibernate.org/xsd/orm/mapping}access-type" />
 *       <attribute name="attribute-accessor" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="optimistic-lock" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "element-collection", namespace = "http://www.hibernate.org/xsd/orm/mapping", propOrder = {
    "orderBy",
    "orderColumn",
    "sort",
    "mapKey",
    "mapKeyClass",
    "mapKeyTemporal",
    "mapKeyEnumerated",
    "mapKeyAttributeOverride",
    "mapKeyConvert",
    "mapKeyColumn",
    "mapKeyFormula",
    "mapKeyJoinColumn",
    "mapKeyForeignKey",
    "column",
    "formula",
    "temporal",
    "enumerated",
    "lob",
    "nationalized",
    "attributeOverride",
    "associationOverride",
    "convert",
    "collectionTable"
})
public class JaxbElementCollection
    implements Serializable, CollectionAttribute
{

    @XmlElement(name = "order-by", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected String orderBy;
    @XmlElement(name = "order-column", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbOrderColumn orderColumn;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected String sort;
    @XmlElement(name = "map-key", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbMapKey mapKey;
    @XmlElement(name = "map-key-class", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbMapKeyClass mapKeyClass;
    @XmlElement(name = "map-key-temporal", namespace = "http://www.hibernate.org/xsd/orm/mapping", type = String.class)
    @XmlJavaTypeAdapter(Adapter13 .class)
    @XmlSchemaType(name = "token")
    protected TemporalType mapKeyTemporal;
    @XmlElement(name = "map-key-enumerated", namespace = "http://www.hibernate.org/xsd/orm/mapping", type = String.class)
    @XmlJavaTypeAdapter(Adapter7 .class)
    @XmlSchemaType(name = "token")
    protected EnumType mapKeyEnumerated;
    @XmlElement(name = "map-key-attribute-override", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbAttributeOverride> mapKeyAttributeOverride;
    @XmlElement(name = "map-key-convert", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbConvert> mapKeyConvert;
    @XmlElement(name = "map-key-column", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbMapKeyColumn mapKeyColumn;
    @XmlElement(name = "map-key-formula", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected String mapKeyFormula;
    @XmlElement(name = "map-key-join-column", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbMapKeyJoinColumn> mapKeyJoinColumn;
    @XmlElement(name = "map-key-foreign-key", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbForeignKey mapKeyForeignKey;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbColumn column;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected String formula;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping", type = String.class)
    @XmlJavaTypeAdapter(Adapter13 .class)
    @XmlSchemaType(name = "token")
    protected TemporalType temporal;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping", type = String.class)
    @XmlJavaTypeAdapter(Adapter7 .class)
    @XmlSchemaType(name = "token")
    protected EnumType enumerated;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbLob lob;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbNationalized nationalized;
    @XmlElement(name = "attribute-override", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbAttributeOverride> attributeOverride;
    @XmlElement(name = "association-override", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbAssociationOverride> associationOverride;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbConvert> convert;
    @XmlElement(name = "collection-table", namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbCollectionTable collectionTable;
    @XmlAttribute(name = "name", required = true)
    protected String name;
    @XmlAttribute(name = "target-class")
    protected String targetClass;
    @XmlAttribute(name = "fetch")
    @XmlJavaTypeAdapter(Adapter8 .class)
    protected FetchType fetch;
    @XmlAttribute(name = "fetch-mode")
    protected JaxbPluralFetchMode fetchMode;
    @XmlAttribute(name = "access")
    @XmlJavaTypeAdapter(Adapter1 .class)
    protected AccessType access;
    @XmlAttribute(name = "attribute-accessor")
    protected String attributeAccessor;
    @XmlAttribute(name = "optimistic-lock")
    protected Boolean optimisticLock;

    /**
     * Gets the value of the orderBy property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getOrderBy() {
        return orderBy;
    }

    /**
     * Sets the value of the orderBy property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setOrderBy(String value) {
        this.orderBy = value;
    }

    /**
     * Gets the value of the orderColumn property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbOrderColumn }
     *     
     */
    public JaxbOrderColumn getOrderColumn() {
        return orderColumn;
    }

    /**
     * Sets the value of the orderColumn property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbOrderColumn }
     *     
     */
    public void setOrderColumn(JaxbOrderColumn value) {
        this.orderColumn = value;
    }

    /**
     * Gets the value of the sort property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSort() {
        return sort;
    }

    /**
     * Sets the value of the sort property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSort(String value) {
        this.sort = value;
    }

    /**
     * Gets the value of the mapKey property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbMapKey }
     *     
     */
    public JaxbMapKey getMapKey() {
        return mapKey;
    }

    /**
     * Sets the value of the mapKey property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbMapKey }
     *     
     */
    public void setMapKey(JaxbMapKey value) {
        this.mapKey = value;
    }

    /**
     * Gets the value of the mapKeyClass property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbMapKeyClass }
     *     
     */
    public JaxbMapKeyClass getMapKeyClass() {
        return mapKeyClass;
    }

    /**
     * Sets the value of the mapKeyClass property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbMapKeyClass }
     *     
     */
    public void setMapKeyClass(JaxbMapKeyClass value) {
        this.mapKeyClass = value;
    }

    /**
     * Gets the value of the mapKeyTemporal property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public TemporalType getMapKeyTemporal() {
        return mapKeyTemporal;
    }

    /**
     * Sets the value of the mapKeyTemporal property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setMapKeyTemporal(TemporalType value) {
        this.mapKeyTemporal = value;
    }

    /**
     * Gets the value of the mapKeyEnumerated property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public EnumType getMapKeyEnumerated() {
        return mapKeyEnumerated;
    }

    /**
     * Sets the value of the mapKeyEnumerated property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setMapKeyEnumerated(EnumType value) {
        this.mapKeyEnumerated = value;
    }

    /**
     * Gets the value of the mapKeyAttributeOverride property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the mapKeyAttributeOverride property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getMapKeyAttributeOverride().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbAttributeOverride }
     * 
     * 
     * @return
     *     The value of the mapKeyAttributeOverride property.
     */
    public List<JaxbAttributeOverride> getMapKeyAttributeOverride() {
        if (mapKeyAttributeOverride == null) {
            mapKeyAttributeOverride = new ArrayList<>();
        }
        return this.mapKeyAttributeOverride;
    }

    /**
     * Gets the value of the mapKeyConvert property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the mapKeyConvert property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getMapKeyConvert().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbConvert }
     * 
     * 
     * @return
     *     The value of the mapKeyConvert property.
     */
    public List<JaxbConvert> getMapKeyConvert() {
        if (mapKeyConvert == null) {
            mapKeyConvert = new ArrayList<>();
        }
        return this.mapKeyConvert;
    }

    /**
     * Gets the value of the mapKeyColumn property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbMapKeyColumn }
     *     
     */
    public JaxbMapKeyColumn getMapKeyColumn() {
        return mapKeyColumn;
    }

    /**
     * Sets the value of the mapKeyColumn property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbMapKeyColumn }
     *     
     */
    public void setMapKeyColumn(JaxbMapKeyColumn value) {
        this.mapKeyColumn = value;
    }

    /**
     * Gets the value of the mapKeyFormula property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getMapKeyFormula() {
        return mapKeyFormula;
    }

    /**
     * Sets the value of the mapKeyFormula property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setMapKeyFormula(String value) {
        this.mapKeyFormula = value;
    }

    /**
     * Gets the value of the mapKeyJoinColumn property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the mapKeyJoinColumn property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getMapKeyJoinColumn().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbMapKeyJoinColumn }
     * 
     * 
     * @return
     *     The value of the mapKeyJoinColumn property.
     */
    public List<JaxbMapKeyJoinColumn> getMapKeyJoinColumn() {
        if (mapKeyJoinColumn == null) {
            mapKeyJoinColumn = new ArrayList<>();
        }
        return this.mapKeyJoinColumn;
    }

    /**
     * Gets the value of the mapKeyForeignKey property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbForeignKey }
     *     
     */
    public JaxbForeignKey getMapKeyForeignKey() {
        return mapKeyForeignKey;
    }

    /**
     * Sets the value of the mapKeyForeignKey property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbForeignKey }
     *     
     */
    public void setMapKeyForeignKey(JaxbForeignKey value) {
        this.mapKeyForeignKey = value;
    }

    /**
     * Gets the value of the column property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbColumn }
     *     
     */
    public JaxbColumn getColumn() {
        return column;
    }

    /**
     * Sets the value of the column property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbColumn }
     *     
     */
    public void setColumn(JaxbColumn value) {
        this.column = value;
    }

    /**
     * Gets the value of the formula property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getFormula() {
        return formula;
    }

    /**
     * Sets the value of the formula property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setFormula(String value) {
        this.formula = value;
    }

    /**
     * Gets the value of the temporal property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public TemporalType getTemporal() {
        return temporal;
    }

    /**
     * Sets the value of the temporal property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTemporal(TemporalType value) {
        this.temporal = value;
    }

    /**
     * Gets the value of the enumerated property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public EnumType getEnumerated() {
        return enumerated;
    }

    /**
     * Sets the value of the enumerated property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setEnumerated(EnumType value) {
        this.enumerated = value;
    }

    /**
     * Gets the value of the lob property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbLob }
     *     
     */
    public JaxbLob getLob() {
        return lob;
    }

    /**
     * Sets the value of the lob property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbLob }
     *     
     */
    public void setLob(JaxbLob value) {
        this.lob = value;
    }

    /**
     * Gets the value of the nationalized property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbNationalized }
     *     
     */
    public JaxbNationalized getNationalized() {
        return nationalized;
    }

    /**
     * Sets the value of the nationalized property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbNationalized }
     *     
     */
    public void setNationalized(JaxbNationalized value) {
        this.nationalized = value;
    }

    /**
     * Gets the value of the attributeOverride property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the attributeOverride property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAttributeOverride().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbAttributeOverride }
     * 
     * 
     * @return
     *     The value of the attributeOverride property.
     */
    public List<JaxbAttributeOverride> getAttributeOverride() {
        if (attributeOverride == null) {
            attributeOverride = new ArrayList<>();
        }
        return this.attributeOverride;
    }

    /**
     * Gets the value of the associationOverride property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the associationOverride property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAssociationOverride().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbAssociationOverride }
     * 
     * 
     * @return
     *     The value of the associationOverride property.
     */
    public List<JaxbAssociationOverride> getAssociationOverride() {
        if (associationOverride == null) {
            associationOverride = new ArrayList<>();
        }
        return this.associationOverride;
    }

    /**
     * Gets the value of the convert property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the convert property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getConvert().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbConvert }
     * 
     * 
     * @return
     *     The value of the convert property.
     */
    public List<JaxbConvert> getConvert() {
        if (convert == null) {
            convert = new ArrayList<>();
        }
        return this.convert;
    }

    /**
     * Gets the value of the collectionTable property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbCollectionTable }
     *     
     */
    public JaxbCollectionTable getCollectionTable() {
        return collectionTable;
    }

    /**
     * Sets the value of the collectionTable property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbCollectionTable }
     *     
     */
    public void setCollectionTable(JaxbCollectionTable value) {
        this.collectionTable = value;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setName(String value) {
        this.name = value;
    }

    /**
     * Gets the value of the targetClass property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTargetClass() {
        return targetClass;
    }

    /**
     * Sets the value of the targetClass property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTargetClass(String value) {
        this.targetClass = value;
    }

    /**
     * Gets the value of the fetch property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FetchType getFetch() {
        return fetch;
    }

    /**
     * Sets the value of the fetch property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setFetch(FetchType value) {
        this.fetch = value;
    }

    /**
     * Gets the value of the fetchMode property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbPluralFetchMode }
     *     
     */
    public JaxbPluralFetchMode getFetchMode() {
        return fetchMode;
    }

    /**
     * Sets the value of the fetchMode property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbPluralFetchMode }
     *     
     */
    public void setFetchMode(JaxbPluralFetchMode value) {
        this.fetchMode = value;
    }

    /**
     * Gets the value of the access property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public AccessType getAccess() {
        return access;
    }

    /**
     * Sets the value of the access property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAccess(AccessType value) {
        this.access = value;
    }

    /**
     * Gets the value of the attributeAccessor property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAttributeAccessor() {
        return attributeAccessor;
    }

    /**
     * Sets the value of the attributeAccessor property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAttributeAccessor(String value) {
        this.attributeAccessor = value;
    }

    /**
     * Gets the value of the optimisticLock property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isOptimisticLock() {
        if (optimisticLock == null) {
            return true;
        } else {
            return optimisticLock;
        }
    }

    /**
     * Sets the value of the optimisticLock property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setOptimisticLock(Boolean value) {
        this.optimisticLock = value;
    }

}
