
package org.hibernate.boot.jaxb.hbm.spi;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for OuterJoinEnum.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="OuterJoinEnum">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}token">
 *     <enumeration value="auto"/>
 *     <enumeration value="false"/>
 *     <enumeration value="true"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "OuterJoinEnum", namespace = "http://www.hibernate.org/xsd/orm/hbm")
@XmlEnum
public enum JaxbHbmOuterJoinEnum {

    @XmlEnumValue("auto")
    AUTO("auto"),
    @XmlEnumValue("false")
    FALSE("false"),
    @XmlEnumValue("true")
    TRUE("true");
    private final String value;

    JaxbHbmOuterJoinEnum(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static JaxbHbmOuterJoinEnum fromValue(String v) {
        for (JaxbHbmOuterJoinEnum c: JaxbHbmOuterJoinEnum.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
