
package org.hibernate.boot.jaxb.cfg.spi;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType>
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="session-factory">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <sequence>
 *                   <element name="property" type="{http://www.hibernate.org/xsd/orm/cfg}ConfigPropertyType" maxOccurs="unbounded" minOccurs="0"/>
 *                   <element name="mapping" type="{http://www.hibernate.org/xsd/orm/cfg}MappingReferenceType" maxOccurs="unbounded" minOccurs="0"/>
 *                   <choice maxOccurs="unbounded" minOccurs="0">
 *                     <element name="class-cache" type="{http://www.hibernate.org/xsd/orm/cfg}EntityCacheType"/>
 *                     <element name="collection-cache" type="{http://www.hibernate.org/xsd/orm/cfg}CollectionCacheType"/>
 *                   </choice>
 *                   <element name="event" type="{http://www.hibernate.org/xsd/orm/cfg}EventListenerGroupType" maxOccurs="unbounded" minOccurs="0"/>
 *                   <element name="listener" type="{http://www.hibernate.org/xsd/orm/cfg}EventListenerType" maxOccurs="unbounded" minOccurs="0"/>
 *                 </sequence>
 *                 <attribute name="name" type="{http://www.w3.org/2001/XMLSchema}string" />
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *         <element name="security" minOccurs="0">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <sequence>
 *                   <element name="grant" maxOccurs="unbounded" minOccurs="0">
 *                     <complexType>
 *                       <complexContent>
 *                         <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                           <attribute name="actions" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *                           <attribute name="entity-name" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *                           <attribute name="role" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *                         </restriction>
 *                       </complexContent>
 *                     </complexType>
 *                   </element>
 *                 </sequence>
 *                 <attribute name="context" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "sessionFactory",
    "security"
})
@XmlRootElement(name = "hibernate-configuration", namespace = "http://www.hibernate.org/xsd/orm/cfg")
public class JaxbCfgHibernateConfiguration {

    @XmlElement(name = "session-factory", namespace = "http://www.hibernate.org/xsd/orm/cfg", required = true)
    protected JaxbCfgHibernateConfiguration.JaxbCfgSessionFactory sessionFactory;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/cfg")
    protected JaxbCfgHibernateConfiguration.JaxbCfgSecurity security;

    /**
     * Gets the value of the sessionFactory property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbCfgHibernateConfiguration.JaxbCfgSessionFactory }
     *     
     */
    public JaxbCfgHibernateConfiguration.JaxbCfgSessionFactory getSessionFactory() {
        return sessionFactory;
    }

    /**
     * Sets the value of the sessionFactory property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbCfgHibernateConfiguration.JaxbCfgSessionFactory }
     *     
     */
    public void setSessionFactory(JaxbCfgHibernateConfiguration.JaxbCfgSessionFactory value) {
        this.sessionFactory = value;
    }

    /**
     * Gets the value of the security property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbCfgHibernateConfiguration.JaxbCfgSecurity }
     *     
     */
    public JaxbCfgHibernateConfiguration.JaxbCfgSecurity getSecurity() {
        return security;
    }

    /**
     * Sets the value of the security property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbCfgHibernateConfiguration.JaxbCfgSecurity }
     *     
     */
    public void setSecurity(JaxbCfgHibernateConfiguration.JaxbCfgSecurity value) {
        this.security = value;
    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <sequence>
     *         <element name="grant" maxOccurs="unbounded" minOccurs="0">
     *           <complexType>
     *             <complexContent>
     *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *                 <attribute name="actions" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
     *                 <attribute name="entity-name" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
     *                 <attribute name="role" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
     *               </restriction>
     *             </complexContent>
     *           </complexType>
     *         </element>
     *       </sequence>
     *       <attribute name="context" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "grant"
    })
    public static class JaxbCfgSecurity {

        @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/cfg")
        protected List<JaxbCfgHibernateConfiguration.JaxbCfgSecurity.JaxbCfgGrant> grant;
        @XmlAttribute(name = "context", required = true)
        protected String context;

        /**
         * Gets the value of the grant property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the Jakarta XML Binding object.
         * This is why there is not a {@code set} method for the grant property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getGrant().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link JaxbCfgHibernateConfiguration.JaxbCfgSecurity.JaxbCfgGrant }
         * 
         * 
         * @return
         *     The value of the grant property.
         */
        public List<JaxbCfgHibernateConfiguration.JaxbCfgSecurity.JaxbCfgGrant> getGrant() {
            if (grant == null) {
                grant = new ArrayList<>();
            }
            return this.grant;
        }

        /**
         * Gets the value of the context property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getContext() {
            return context;
        }

        /**
         * Sets the value of the context property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setContext(String value) {
            this.context = value;
        }


        /**
         * <p>Java class for anonymous complex type.
         * 
         * <p>The following schema fragment specifies the expected content contained within this class.
         * 
         * <pre>{@code
         * <complexType>
         *   <complexContent>
         *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
         *       <attribute name="actions" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
         *       <attribute name="entity-name" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
         *       <attribute name="role" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
         *     </restriction>
         *   </complexContent>
         * </complexType>
         * }</pre>
         * 
         * 
         */
        @XmlAccessorType(XmlAccessType.FIELD)
        @XmlType(name = "")
        public static class JaxbCfgGrant {

            @XmlAttribute(name = "actions", required = true)
            protected String actions;
            @XmlAttribute(name = "entity-name", required = true)
            protected String entityName;
            @XmlAttribute(name = "role", required = true)
            protected String role;

            /**
             * Gets the value of the actions property.
             * 
             * @return
             *     possible object is
             *     {@link String }
             *     
             */
            public String getActions() {
                return actions;
            }

            /**
             * Sets the value of the actions property.
             * 
             * @param value
             *     allowed object is
             *     {@link String }
             *     
             */
            public void setActions(String value) {
                this.actions = value;
            }

            /**
             * Gets the value of the entityName property.
             * 
             * @return
             *     possible object is
             *     {@link String }
             *     
             */
            public String getEntityName() {
                return entityName;
            }

            /**
             * Sets the value of the entityName property.
             * 
             * @param value
             *     allowed object is
             *     {@link String }
             *     
             */
            public void setEntityName(String value) {
                this.entityName = value;
            }

            /**
             * Gets the value of the role property.
             * 
             * @return
             *     possible object is
             *     {@link String }
             *     
             */
            public String getRole() {
                return role;
            }

            /**
             * Sets the value of the role property.
             * 
             * @param value
             *     allowed object is
             *     {@link String }
             *     
             */
            public void setRole(String value) {
                this.role = value;
            }

        }

    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <sequence>
     *         <element name="property" type="{http://www.hibernate.org/xsd/orm/cfg}ConfigPropertyType" maxOccurs="unbounded" minOccurs="0"/>
     *         <element name="mapping" type="{http://www.hibernate.org/xsd/orm/cfg}MappingReferenceType" maxOccurs="unbounded" minOccurs="0"/>
     *         <choice maxOccurs="unbounded" minOccurs="0">
     *           <element name="class-cache" type="{http://www.hibernate.org/xsd/orm/cfg}EntityCacheType"/>
     *           <element name="collection-cache" type="{http://www.hibernate.org/xsd/orm/cfg}CollectionCacheType"/>
     *         </choice>
     *         <element name="event" type="{http://www.hibernate.org/xsd/orm/cfg}EventListenerGroupType" maxOccurs="unbounded" minOccurs="0"/>
     *         <element name="listener" type="{http://www.hibernate.org/xsd/orm/cfg}EventListenerType" maxOccurs="unbounded" minOccurs="0"/>
     *       </sequence>
     *       <attribute name="name" type="{http://www.w3.org/2001/XMLSchema}string" />
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "property",
        "mapping",
        "classCacheOrCollectionCache",
        "event",
        "listener"
    })
    public static class JaxbCfgSessionFactory {

        @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/cfg")
        protected List<JaxbCfgConfigPropertyType> property;
        @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/cfg")
        protected List<JaxbCfgMappingReferenceType> mapping;
        @XmlElements({
            @XmlElement(name = "class-cache", namespace = "http://www.hibernate.org/xsd/orm/cfg", type = JaxbCfgEntityCacheType.class),
            @XmlElement(name = "collection-cache", namespace = "http://www.hibernate.org/xsd/orm/cfg", type = JaxbCfgCollectionCacheType.class)
        })
        protected List<Object> classCacheOrCollectionCache;
        @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/cfg")
        protected List<JaxbCfgEventListenerGroupType> event;
        @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/cfg")
        protected List<JaxbCfgEventListenerType> listener;
        @XmlAttribute(name = "name")
        protected String name;

        /**
         * Gets the value of the property property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the Jakarta XML Binding object.
         * This is why there is not a {@code set} method for the property property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getProperty().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link JaxbCfgConfigPropertyType }
         * 
         * 
         * @return
         *     The value of the property property.
         */
        public List<JaxbCfgConfigPropertyType> getProperty() {
            if (property == null) {
                property = new ArrayList<>();
            }
            return this.property;
        }

        /**
         * Gets the value of the mapping property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the Jakarta XML Binding object.
         * This is why there is not a {@code set} method for the mapping property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getMapping().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link JaxbCfgMappingReferenceType }
         * 
         * 
         * @return
         *     The value of the mapping property.
         */
        public List<JaxbCfgMappingReferenceType> getMapping() {
            if (mapping == null) {
                mapping = new ArrayList<>();
            }
            return this.mapping;
        }

        /**
         * Gets the value of the classCacheOrCollectionCache property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the Jakarta XML Binding object.
         * This is why there is not a {@code set} method for the classCacheOrCollectionCache property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getClassCacheOrCollectionCache().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link JaxbCfgCollectionCacheType }
         * {@link JaxbCfgEntityCacheType }
         * 
         * 
         * @return
         *     The value of the classCacheOrCollectionCache property.
         */
        public List<Object> getClassCacheOrCollectionCache() {
            if (classCacheOrCollectionCache == null) {
                classCacheOrCollectionCache = new ArrayList<>();
            }
            return this.classCacheOrCollectionCache;
        }

        /**
         * Gets the value of the event property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the Jakarta XML Binding object.
         * This is why there is not a {@code set} method for the event property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getEvent().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link JaxbCfgEventListenerGroupType }
         * 
         * 
         * @return
         *     The value of the event property.
         */
        public List<JaxbCfgEventListenerGroupType> getEvent() {
            if (event == null) {
                event = new ArrayList<>();
            }
            return this.event;
        }

        /**
         * Gets the value of the listener property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the Jakarta XML Binding object.
         * This is why there is not a {@code set} method for the listener property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getListener().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link JaxbCfgEventListenerType }
         * 
         * 
         * @return
         *     The value of the listener property.
         */
        public List<JaxbCfgEventListenerType> getListener() {
            if (listener == null) {
                listener = new ArrayList<>();
            }
            return this.listener;
        }

        /**
         * Gets the value of the name property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getName() {
            return name;
        }

        /**
         * Sets the value of the name property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setName(String value) {
            this.name = value;
        }

    }

}
