/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later.
 * See the lgpl.txt file in the root directory or <http://www.gnu.org/licenses/lgpl-2.1.html>.
 */
package org.hibernate.annotations;

/**
 * Specifies the source of a generated value, either the virtual machine,
 * or the database.
 *
 * @see CurrentTimestamp#source()
 * @see UpdateTimestamp#source()
 * @see CreationTimestamp#source()
 * @see Source
 *
 * @author Hardy Ferentschik
 */
public enum SourceType {
	/**
	 * Indicates that values are generated in the Java virtual machine.
	 * <p>
	 * For a generated timestamp, {@link java.time.Clock#instant()} might
	 * be the source.
	 */
	VM,

	/**
	 * Indicates that values are generated by the database.
	 * <p>
     * For a generated timestamp, the {@code current_timestamp} function
	 * might be the source.
	 */
	DB;
}
