
package org.hibernate.boot.jaxb.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * <p>Java class for fetch-profile complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="fetch-profile">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="fetch" maxOccurs="unbounded" minOccurs="0">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <attribute name="association" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *                 <attribute name="entity" type="{http://www.w3.org/2001/XMLSchema}string" />
 *                 <attribute name="style">
 *                   <simpleType>
 *                     <restriction base="{http://www.w3.org/2001/XMLSchema}token">
 *                       <enumeration value="join"/>
 *                       <enumeration value="select"/>
 *                     </restriction>
 *                   </simpleType>
 *                 </attribute>
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *       </sequence>
 *       <attribute name="name" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "fetch-profile", namespace = "http://www.hibernate.org/xsd/orm/mapping", propOrder = {
    "fetch"
})
public class JaxbFetchProfile
    implements Serializable
{

    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected List<JaxbFetchProfile.JaxbFetch> fetch;
    @XmlAttribute(name = "name", required = true)
    protected String name;

    /**
     * Gets the value of the fetch property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the fetch property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getFetch().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbFetchProfile.JaxbFetch }
     * 
     * 
     * @return
     *     The value of the fetch property.
     */
    public List<JaxbFetchProfile.JaxbFetch> getFetch() {
        if (fetch == null) {
            fetch = new ArrayList<>();
        }
        return this.fetch;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setName(String value) {
        this.name = value;
    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <attribute name="association" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
     *       <attribute name="entity" type="{http://www.w3.org/2001/XMLSchema}string" />
     *       <attribute name="style">
     *         <simpleType>
     *           <restriction base="{http://www.w3.org/2001/XMLSchema}token">
     *             <enumeration value="join"/>
     *             <enumeration value="select"/>
     *           </restriction>
     *         </simpleType>
     *       </attribute>
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    public static class JaxbFetch
        implements Serializable
    {

        @XmlAttribute(name = "association", required = true)
        protected String association;
        @XmlAttribute(name = "entity")
        protected String entity;
        @XmlAttribute(name = "style")
        @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
        protected String style;

        /**
         * Gets the value of the association property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getAssociation() {
            return association;
        }

        /**
         * Sets the value of the association property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setAssociation(String value) {
            this.association = value;
        }

        /**
         * Gets the value of the entity property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getEntity() {
            return entity;
        }

        /**
         * Sets the value of the entity property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setEntity(String value) {
            this.entity = value;
        }

        /**
         * Gets the value of the style property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getStyle() {
            return style;
        }

        /**
         * Sets the value of the style property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setStyle(String value) {
            this.style = value;
        }

    }

}
