
package org.hibernate.boot.jaxb.hbm.spi;

import java.io.Serializable;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.hibernate.cache.spi.access.AccessType;


/**
 * <p>Java class for CacheType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="CacheType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="include" type="{http://www.hibernate.org/xsd/orm/hbm}CacheInclusionEnum" default="all" />
 *       <attribute name="region" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="usage" use="required" type="{http://www.hibernate.org/xsd/orm/hbm}CacheUsageEnum" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CacheType", namespace = "http://www.hibernate.org/xsd/orm/hbm")
public class JaxbHbmCacheType
    implements Serializable
{

    @XmlAttribute(name = "include")
    protected JaxbHbmCacheInclusionEnum include;
    @XmlAttribute(name = "region")
    protected String region;
    @XmlAttribute(name = "usage", required = true)
    @XmlJavaTypeAdapter(Adapter2 .class)
    protected AccessType usage;

    /**
     * Gets the value of the include property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbHbmCacheInclusionEnum }
     *     
     */
    public JaxbHbmCacheInclusionEnum getInclude() {
        if (include == null) {
            return JaxbHbmCacheInclusionEnum.ALL;
        } else {
            return include;
        }
    }

    /**
     * Sets the value of the include property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbHbmCacheInclusionEnum }
     *     
     */
    public void setInclude(JaxbHbmCacheInclusionEnum value) {
        this.include = value;
    }

    /**
     * Gets the value of the region property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getRegion() {
        return region;
    }

    /**
     * Sets the value of the region property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setRegion(String value) {
        this.region = value;
    }

    /**
     * Gets the value of the usage property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public AccessType getUsage() {
        return usage;
    }

    /**
     * Sets the value of the usage property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setUsage(AccessType value) {
        this.usage = value;
    }

}
