/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.host;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.host.HostClassDesc;
import com.oracle.truffle.host.HostContext;
import com.oracle.truffle.host.HostEngineException;
import com.oracle.truffle.host.HostInteropErrors;
import com.oracle.truffle.host.HostInteropReflect;
import com.oracle.truffle.host.HostLanguage;
import com.oracle.truffle.host.HostMethodScope;
import com.oracle.truffle.host.HostObject;
import com.oracle.truffle.host.HostTargetMappingNode;
import com.oracle.truffle.host.HostToTypeNodeGen;
import com.oracle.truffle.host.HostUtil;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.graalvm.polyglot.HostAccess;

@GenerateUncached
@GenerateInline
@GenerateCached
abstract class HostToTypeNode
extends Node {
    static final int LIMIT = 5;
    static final int HIGHEST = 0;
    static final int STRICT = 1;
    static final int LOOSE = 2;
    static final int COERCE = 3;
    static final int FUNCTION_PROXY = 4;
    static final int OBJECT_PROXY_IFACE = 5;
    static final int OBJECT_PROXY_CLASS = 6;
    static final int HOST_PROXY = 7;
    static final int LOWEST = 8;
    static final int[] PRIORITIES = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};

    HostToTypeNode() {
    }

    public abstract Object execute(Node var1, HostContext var2, Object var3, Class<?> var4, Type var5, boolean var6);

    @Specialization(guards={"targetType == cachedTargetType"}, limit="LIMIT")
    protected static Object doCached(Node node, HostContext context, Object operand, Class<?> targetType, Type genericType, boolean useCustomTargetTypes, @CachedLibrary(value="operand") InteropLibrary interop, @Cached(value="targetType") Class<?> cachedTargetType, @Cached(value="isPrimitiveOrBigIntegerTarget(context, cachedTargetType)") boolean primitiveOrBigIntegerTarget, @Cached(value="allowsImplementation(context, targetType)") boolean allowsImplementation, @Cached HostTargetMappingNode targetMapping, @Cached InlinedBranchProfile error) {
        return HostToTypeNode.convertImpl(node, operand, cachedTargetType, genericType, allowsImplementation, primitiveOrBigIntegerTarget, context, interop, useCustomTargetTypes, targetMapping, error);
    }

    @CompilerDirectives.TruffleBoundary
    static boolean allowsImplementation(HostContext hostContext, Class<?> type) {
        if (hostContext == null) {
            return false;
        }
        if (!HostInteropReflect.isAbstractType(type)) {
            return false;
        }
        HostClassDesc classDesc = hostContext.getHostClassCache().forClass(type);
        return classDesc.isAllowsImplementation() && classDesc.isAllowedTargetType();
    }

    @Specialization(replaces={"doCached"})
    @CompilerDirectives.TruffleBoundary
    protected static Object doGeneric(Node node, HostContext context, Object operand, Class<?> targetType, Type genericType, boolean useTargetMapping) {
        return HostToTypeNode.convertImpl(node, operand, targetType, genericType, HostToTypeNode.allowsImplementation(context, targetType), HostToTypeNode.isPrimitiveOrBigIntegerTarget(context, targetType), context, InteropLibrary.getUncached(operand), useTargetMapping, HostTargetMappingNode.getUncached(), InlinedBranchProfile.getUncached());
    }

    @CompilerDirectives.TruffleBoundary
    private static String toString(Object value) {
        return value.toString();
    }

    private static Object convertImpl(Node node, Object value, Class<?> targetType, Type genericType, boolean allowsImplementation, boolean primitiveOrBigIntegerTargetType, HostContext context, InteropLibrary interop, boolean useCustomTargetTypes, HostTargetMappingNode targetMapping, InlinedBranchProfile error) {
        Object result;
        Object convertedValue;
        Object result2;
        if (useCustomTargetTypes && (result2 = targetMapping.execute(node, value, targetType, context, interop, false, 0, 1)) != HostTargetMappingNode.NO_RESULT) {
            return result2;
        }
        if (primitiveOrBigIntegerTargetType && (convertedValue = HostUtil.convertLossLess(value, targetType, interop)) != null) {
            return convertedValue;
        }
        HostLanguage language = HostLanguage.get(interop);
        if (HostObject.isJavaInstance(language, targetType, value)) {
            return HostObject.valueOf(language, value);
        }
        if (useCustomTargetTypes && (convertedValue = targetMapping.execute(node, value, targetType, context, interop, false, 2, 2)) != HostTargetMappingNode.NO_RESULT) {
            return convertedValue;
        }
        if (primitiveOrBigIntegerTargetType && (convertedValue = HostUtil.convertLossy(value, targetType, interop)) != null) {
            return convertedValue;
        }
        if (targetType == language.valueClass && context != null) {
            return language.valueClass.isInstance(value) ? value : context.asValue(interop, value);
        }
        if (interop.isNull(value)) {
            if (targetType.isPrimitive()) {
                throw HostInteropErrors.nullCoercion(context, value, targetType);
            }
            return null;
        }
        if (value instanceof TruffleObject) {
            convertedValue = HostToTypeNode.asJavaObject(node, context, (TruffleObject)value, targetType, genericType, allowsImplementation);
            if (convertedValue != null) {
                return convertedValue;
            }
        } else if (value instanceof TruffleString && targetType.isAssignableFrom(String.class)) {
            try {
                return interop.asString(value);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere(e);
            }
        }
        if (targetType.isInstance(value)) {
            convertedValue = value;
            return targetType.cast(convertedValue);
        }
        if (useCustomTargetTypes && (result = targetMapping.execute(node, value, targetType, context, interop, false, 3, 8)) != HostTargetMappingNode.NO_RESULT) {
            return result;
        }
        error.enter(node);
        throw HostInteropErrors.cannotConvertPrimitive(context, value, targetType);
    }

    @HostCompilerDirectives.InliningCutoff
    static boolean canConvert(Node node, Object value, Class<?> targetType, Type genericType, Boolean allowsImplementation, HostContext hostContext, int priority, InteropLibrary interop, HostTargetMappingNode targetMapping) {
        Object convertedValue;
        if (targetMapping != null && targetMapping.execute(node, value, targetType, hostContext, interop, true, 0, priority) == Boolean.TRUE) {
            return true;
        }
        if (priority <= 0) {
            return false;
        }
        HostLanguage language = HostLanguage.get(interop);
        if (interop.isNull(value)) {
            return !targetType.isPrimitive();
        }
        if (targetType == language.valueClass && hostContext != null) {
            return true;
        }
        if (HostToTypeNode.isPrimitiveOrBigIntegerTarget(hostContext, targetType) && (convertedValue = HostUtil.convertLossLess(value, targetType, interop)) != null) {
            return true;
        }
        if (HostObject.isJavaInstance(language, targetType, value)) {
            return true;
        }
        if (priority <= 1) {
            return false;
        }
        if (targetType == Object.class) {
            return true;
        }
        if (targetType == List.class) {
            return interop.hasArrayElements(value);
        }
        if (targetType == Map.class) {
            return interop.hasMembers(value);
        }
        if (targetType == Function.class) {
            return interop.isExecutable(value) || interop.isInstantiable(value);
        }
        if (targetType == LocalDate.class) {
            return interop.isDate(value);
        }
        if (targetType == LocalTime.class) {
            return interop.isTime(value);
        }
        if (targetType == LocalDateTime.class) {
            return interop.isDate(value) && interop.isTime(value);
        }
        if (targetType == ZonedDateTime.class || targetType == Date.class || targetType == Instant.class) {
            return interop.isInstant(value);
        }
        if (targetType == ZoneId.class) {
            return interop.isTimeZone(value);
        }
        if (targetType == Duration.class) {
            return interop.isDuration(value);
        }
        if (targetType == language.polyglotEngineClass) {
            return interop.isException(value);
        }
        if (priority <= 2) {
            return false;
        }
        if (targetType.isArray()) {
            return interop.hasArrayElements(value);
        }
        if (HostToTypeNode.isPrimitiveOrBigIntegerTarget(hostContext, targetType) && (convertedValue = HostUtil.convertLossy(value, targetType, interop)) != null) {
            return true;
        }
        if (value instanceof TruffleObject) {
            if (priority < 7 && HostObject.isInstance(language, value)) {
                return false;
            }
            if (priority >= 4 && HostInteropReflect.isFunctionalInterface(targetType) && (interop.isExecutable(value) || interop.isInstantiable(value)) && HostToTypeNode.checkAllowsImplementation(targetType, allowsImplementation, hostContext)) {
                return true;
            }
            return (priority >= 5 && targetType.isInterface() || priority >= 6 && HostInteropReflect.isAbstractType(targetType)) && interop.hasMembers(value) && HostToTypeNode.checkAllowsImplementation(targetType, allowsImplementation, hostContext);
        }
        assert (!(value instanceof TruffleObject));
        return targetType.isInstance(value);
    }

    private static boolean checkAllowsImplementation(Class<?> targetType, Boolean allowsImplementation, HostContext hostContext) {
        boolean implementations = allowsImplementation == null ? HostToTypeNode.allowsImplementation(hostContext, targetType) : allowsImplementation;
        return implementations;
    }

    static boolean isPrimitiveTarget(Class<?> clazz) {
        return clazz == Integer.TYPE || clazz == Integer.class || clazz == Boolean.TYPE || clazz == Boolean.class || clazz == Byte.TYPE || clazz == Byte.class || clazz == Short.TYPE || clazz == Short.class || clazz == Long.TYPE || clazz == Long.class || clazz == Float.TYPE || clazz == Float.class || clazz == Double.TYPE || clazz == Double.class || clazz == Character.TYPE || clazz == Character.class || clazz == Number.class || CharSequence.class.isAssignableFrom(clazz);
    }

    static boolean isPrimitiveOrBigIntegerTarget(HostContext context, Class<?> clazz) {
        return HostToTypeNode.isPrimitiveTarget(clazz) || HostToTypeNode.isBigIntegerNumberAccess(context) && clazz == BigInteger.class;
    }

    static boolean isBigIntegerNumberAccess(HostContext context) {
        if (context != null) {
            return context.getHostClassCache().isBigIntegerNumberAccess();
        }
        return true;
    }

    static Object convertToObject(Node node, HostContext hostContext, Object value, InteropLibrary interop) {
        try {
            if (interop.isNull(value)) {
                return null;
            }
            if (interop.isString(value)) {
                if (value instanceof HostMethodScope.ScopedObject) {
                    HostMethodScope.ScopedObject s = (HostMethodScope.ScopedObject)value;
                    Object delegate = s.delegate;
                    if (delegate instanceof Character) {
                        return delegate;
                    }
                }
                return interop.asString(value);
            }
            if (interop.isBoolean(value)) {
                return interop.asBoolean(value);
            }
            if (interop.isNumber(value)) {
                Object result = HostUtil.convertToNumber(value, interop);
                if (result != null) {
                    return result;
                }
            } else {
                if (interop.hasArrayElements(value)) {
                    return HostToTypeNode.asJavaObject(node, hostContext, value, List.class, null, false);
                }
                if (interop.hasHashEntries(value) || interop.hasMembers(value)) {
                    return HostToTypeNode.asJavaObject(node, hostContext, value, Map.class, null, false);
                }
                if (interop.hasIterator(value)) {
                    return HostToTypeNode.asJavaObject(node, hostContext, value, Iterable.class, null, false);
                }
                if (interop.isIterator(value)) {
                    return HostToTypeNode.asJavaObject(node, hostContext, value, Iterator.class, null, false);
                }
                if (interop.isExecutable(value) || interop.isInstantiable(value)) {
                    return HostToTypeNode.asJavaObject(node, hostContext, value, Function.class, null, false);
                }
            }
            return hostContext.language.access.toValue(hostContext.internalContext, value);
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @CompilerDirectives.TruffleBoundary
    private static <T> T asJavaObject(Node node, HostContext hostContext, Object value, Class<T> targetType, Type genericType, boolean allowsImplementation) {
        Object obj;
        InteropLibrary interop = InteropLibrary.getFactory().getUncached(value);
        assert (!interop.isNull(value));
        if (HostObject.isJavaInstance(hostContext.language, targetType, value)) {
            obj = HostObject.valueOf(hostContext.language, value);
        } else if (targetType == Object.class) {
            obj = HostToTypeNode.convertToObject(node, hostContext, value, interop);
        } else if (targetType == List.class) {
            if (!interop.hasArrayElements(value)) throw HostInteropErrors.cannotConvert(hostContext, value, targetType, "Value must have array elements.");
            if (!hostContext.getMutableTargetMappings().contains((Object)HostAccess.MutableTargetMapping.ARRAY_TO_JAVA_LIST)) {
                return null;
            }
            boolean implementsFunction = HostToTypeNode.shouldImplementFunction(value, interop);
            TypeAndClass<?> elementType = HostToTypeNode.getGenericParameterType(genericType, 0);
            obj = hostContext.language.access.toList(hostContext.internalContext, value, implementsFunction, elementType.clazz, elementType.type);
        } else if (targetType == Map.class) {
            boolean hasKeys;
            TypeAndClass<?> keyType = HostToTypeNode.getGenericParameterType(genericType, 0);
            TypeAndClass<?> valueType = HostToTypeNode.getGenericParameterType(genericType, 1);
            boolean hasHashEntries = interop.hasHashEntries(value);
            if (!hasHashEntries && !HostToTypeNode.isSupportedMapKeyType(keyType.clazz)) {
                throw HostToTypeNode.newInvalidKeyTypeException(keyType.clazz, hostContext);
            }
            boolean hasSize = Number.class.isAssignableFrom(keyType.clazz) && interop.hasArrayElements(value);
            boolean bl = hasKeys = (keyType.clazz == Object.class || keyType.clazz == String.class) && interop.hasMembers(value);
            if (hasKeys || hasSize) {
                if (!hostContext.getMutableTargetMappings().contains((Object)HostAccess.MutableTargetMapping.MEMBERS_TO_JAVA_MAP)) {
                    return null;
                }
                boolean implementsFunction = HostToTypeNode.shouldImplementFunction(value, interop);
                obj = hostContext.language.access.toMap(hostContext.internalContext, value, implementsFunction, keyType.clazz, keyType.type, valueType.clazz, valueType.type);
            } else {
                if (!hasHashEntries) throw HostInteropErrors.cannotConvert(hostContext, value, targetType, "Value must have members, array elements or hash entries.");
                if (!hostContext.getMutableTargetMappings().contains((Object)HostAccess.MutableTargetMapping.HASH_TO_JAVA_MAP)) {
                    return null;
                }
                boolean implementsFunction = HostToTypeNode.shouldImplementFunction(value, interop);
                obj = hostContext.language.access.toMap(hostContext.internalContext, value, implementsFunction, keyType.clazz, keyType.type, valueType.clazz, valueType.type);
            }
        } else if (targetType == Map.Entry.class) {
            if (!hostContext.getMutableTargetMappings().contains((Object)HostAccess.MutableTargetMapping.MEMBERS_TO_JAVA_MAP) && !hostContext.getMutableTargetMappings().contains((Object)HostAccess.MutableTargetMapping.HASH_TO_JAVA_MAP)) {
                return null;
            }
            if (!interop.hasArrayElements(value)) throw HostInteropErrors.cannotConvert(hostContext, value, targetType, "Value must have array elements.");
            TypeAndClass<?> keyType = HostToTypeNode.getGenericParameterType(genericType, 0);
            TypeAndClass<?> valueType = HostToTypeNode.getGenericParameterType(genericType, 1);
            boolean implementsFunction = HostToTypeNode.shouldImplementFunction(value, interop);
            obj = hostContext.language.access.toMapEntry(hostContext.internalContext, value, implementsFunction, keyType.clazz, keyType.type, valueType.clazz, valueType.type);
        } else if (targetType == Function.class) {
            TypeAndClass<?> paramType = HostToTypeNode.getGenericParameterType(genericType, 0);
            TypeAndClass<?> returnType = HostToTypeNode.getGenericParameterType(genericType, 1);
            if (interop.isExecutable(value) || interop.isInstantiable(value)) {
                obj = hostContext.language.access.toFunction(hostContext.internalContext, value, returnType.clazz, returnType.type, paramType.clazz, paramType.type);
            } else {
                if (!interop.hasMembers(value)) throw HostInteropErrors.cannotConvert(hostContext, value, targetType, "Value must be executable or instantiable.");
                obj = hostContext.language.access.toObjectProxy(hostContext.internalContext, targetType, value);
            }
        } else if (targetType.isArray()) {
            if (!interop.hasArrayElements(value)) throw HostInteropErrors.cannotConvert(hostContext, value, targetType, "Value must have array elements.");
            obj = HostToTypeNode.truffleObjectToArray(hostContext, interop, value, targetType, genericType);
        } else {
            if (targetType == LocalDate.class) {
                if (!interop.isDate(value)) throw HostInteropErrors.cannotConvert(hostContext, value, targetType, "Value must have date and time information.");
                try {
                    obj = interop.asDate(value);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere(e);
                }
            }
            if (targetType == LocalTime.class) {
                if (!interop.isTime(value)) throw HostInteropErrors.cannotConvert(hostContext, value, targetType, "Value must have date and time information.");
                try {
                    obj = interop.asTime(value);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere(e);
                }
            }
            if (targetType == LocalDateTime.class) {
                LocalTime time;
                LocalDate date;
                if (!interop.isDate(value) || !interop.isTime(value)) throw HostInteropErrors.cannotConvert(hostContext, value, targetType, "Value must have date and time information.");
                try {
                    date = interop.asDate(value);
                    time = interop.asTime(value);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere(e);
                }
                obj = HostToTypeNode.createDateTime(date, time);
            } else if (targetType == ZonedDateTime.class) {
                ZoneId timeZone;
                LocalTime time;
                LocalDate date;
                if (!interop.isDate(value) || !interop.isTime(value) || !interop.isTimeZone(value)) throw HostInteropErrors.cannotConvert(hostContext, value, targetType, "Value must have date, time and time-zone information.");
                try {
                    date = interop.asDate(value);
                    time = interop.asTime(value);
                    timeZone = interop.asTimeZone(value);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere(e);
                }
                obj = HostToTypeNode.createZonedDateTime(date, time, timeZone);
            } else {
                if (targetType == ZoneId.class) {
                    if (!interop.isTimeZone(value)) throw HostInteropErrors.cannotConvert(hostContext, value, targetType, "Value must have time-zone information.");
                    try {
                        obj = interop.asTimeZone(value);
                    }
                    catch (UnsupportedMessageException e) {
                        throw CompilerDirectives.shouldNotReachHere(e);
                    }
                }
                if (targetType == Instant.class || targetType == Date.class) {
                    Instant instantValue;
                    if (!interop.isDate(value) || !interop.isTime(value) || !interop.isTimeZone(value)) throw HostInteropErrors.cannotConvert(hostContext, value, targetType, "Value must have date, time and time-zone information.");
                    try {
                        instantValue = interop.asInstant(value);
                    }
                    catch (UnsupportedMessageException e) {
                        throw CompilerDirectives.shouldNotReachHere(e);
                    }
                    obj = targetType == Date.class ? Date.from(instantValue) : targetType.cast(instantValue);
                } else if (targetType == Duration.class) {
                    if (!interop.isDuration(value)) throw HostInteropErrors.cannotConvert(hostContext, value, targetType, "Value must have duration information.");
                    try {
                        obj = interop.asDuration(value);
                    }
                    catch (UnsupportedMessageException e) {
                        throw CompilerDirectives.shouldNotReachHere(e);
                    }
                } else if (targetType == hostContext.language.polyglotEngineClass) {
                    if (!interop.isException(value)) throw HostInteropErrors.cannotConvert(hostContext, value, targetType, "Value must be an exception.");
                    obj = HostToTypeNode.asPolyglotException(hostContext, value, interop);
                } else if (targetType == Iterable.class) {
                    if (!hostContext.getMutableTargetMappings().contains((Object)HostAccess.MutableTargetMapping.ITERABLE_TO_JAVA_ITERABLE)) {
                        return null;
                    }
                    if (interop.hasIterator(value)) {
                        boolean implementsFunction = HostToTypeNode.shouldImplementFunction(value, interop);
                        TypeAndClass<?> elementType = HostToTypeNode.getGenericParameterType(genericType, 0);
                        obj = hostContext.language.access.toIterable(hostContext.internalContext, value, implementsFunction, elementType.clazz, elementType.type);
                    } else {
                        if (!allowsImplementation || !interop.hasMembers(value)) throw HostInteropErrors.cannotConvert(hostContext, value, targetType, "Value must have an iterator.");
                        obj = hostContext.language.access.toObjectProxy(hostContext.internalContext, targetType, value);
                    }
                } else if (targetType == Iterator.class) {
                    if (!hostContext.getMutableTargetMappings().contains((Object)HostAccess.MutableTargetMapping.ITERATOR_TO_JAVA_ITERATOR)) {
                        return null;
                    }
                    if (interop.isIterator(value)) {
                        boolean implementsFunction = HostToTypeNode.shouldImplementFunction(value, interop);
                        TypeAndClass<?> elementType = HostToTypeNode.getGenericParameterType(genericType, 0);
                        obj = hostContext.language.access.toIterator(hostContext.internalContext, value, implementsFunction, elementType.clazz, elementType.type);
                    } else {
                        if (!allowsImplementation || !interop.hasMembers(value)) throw HostInteropErrors.cannotConvert(hostContext, value, targetType, "Value must be an iterator.");
                        obj = hostContext.language.access.toObjectProxy(hostContext.internalContext, targetType, value);
                    }
                } else {
                    if (!allowsImplementation || !HostInteropReflect.isAbstractType(targetType)) return null;
                    if (HostInteropReflect.isFunctionalInterface(targetType) && (interop.isExecutable(value) || interop.isInstantiable(value))) {
                        if (!hostContext.getMutableTargetMappings().contains((Object)HostAccess.MutableTargetMapping.EXECUTABLE_TO_JAVA_INTERFACE)) {
                            return null;
                        }
                        obj = hostContext.language.access.toFunctionProxy(hostContext.internalContext, targetType, value);
                    } else {
                        if (!interop.hasMembers(value)) throw HostInteropErrors.cannotConvert(hostContext, value, targetType, "Value must have members.");
                        if (!hostContext.getMutableTargetMappings().contains((Object)HostAccess.MutableTargetMapping.MEMBERS_TO_JAVA_INTERFACE)) {
                            return null;
                        }
                        obj = targetType.isInterface() ? hostContext.language.access.toObjectProxy(hostContext.internalContext, targetType, value) : HostInteropReflect.newAdapterInstance(node, hostContext, targetType, value);
                    }
                }
            }
        }
        assert (targetType.isInstance(obj));
        return targetType.cast(obj);
    }

    private static Object asPolyglotException(HostContext hostContext, Object value, InteropLibrary interop) {
        try {
            interop.throwException(value);
            throw UnsupportedMessageException.create();
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            return hostContext.language.access.toPolyglotException(hostContext.internalContext, e);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static ZonedDateTime createZonedDateTime(LocalDate date, LocalTime time, ZoneId timeZone) {
        return ZonedDateTime.of(date, time, timeZone);
    }

    @CompilerDirectives.TruffleBoundary
    private static LocalDateTime createDateTime(LocalDate date, LocalTime time) {
        return LocalDateTime.of(date, time);
    }

    private static boolean shouldImplementFunction(Object truffleObject, InteropLibrary interop) {
        boolean executable = interop.isExecutable(truffleObject);
        boolean instantiable = false;
        if (!executable) {
            instantiable = interop.isInstantiable(truffleObject);
        }
        boolean implementsFunction = executable || instantiable;
        return implementsFunction;
    }

    private static boolean isSupportedMapKeyType(Class<?> keyType) {
        return keyType == Object.class || keyType == String.class || keyType == Long.class || keyType == Integer.class || keyType == Number.class;
    }

    @CompilerDirectives.TruffleBoundary
    private static RuntimeException newInvalidKeyTypeException(Type targetType, HostContext context) {
        String message = "Unsupported Map key type: " + targetType;
        return HostEngineException.classCast(context.access, message);
    }

    private static TypeAndClass<?> getGenericParameterType(Type genericType, int index) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parametrizedType = (ParameterizedType)genericType;
            Type[] typeArguments = parametrizedType.getActualTypeArguments();
            Class elementClass = Object.class;
            if (index < typeArguments.length) {
                Type elementType = typeArguments[index];
                if (elementType instanceof ParameterizedType) {
                    elementType = ((ParameterizedType)elementType).getRawType();
                }
                if (elementType instanceof Class) {
                    elementClass = (Class)elementType;
                }
                return new TypeAndClass(typeArguments[index], elementClass);
            }
        }
        return TypeAndClass.ANY;
    }

    private static Type getGenericArrayComponentType(Type genericType) {
        Type genericComponentType = null;
        if (genericType instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)genericType;
            genericComponentType = genericArrayType.getGenericComponentType();
        }
        return genericComponentType;
    }

    private static Object truffleObjectToArray(HostContext hostContext, InteropLibrary interop, Object receiver, Class<?> arrayType, Type genericArrayType) {
        long size;
        Class<?> componentType = arrayType.getComponentType();
        try {
            size = interop.getArraySize(receiver);
        }
        catch (UnsupportedMessageException e1) {
            assert (false) : "unexpected language behavior";
            size = 0L;
        }
        size = Math.min(size, Integer.MAX_VALUE);
        Object array = Array.newInstance(componentType, (int)size);
        Type genericComponentType = HostToTypeNode.getGenericArrayComponentType(genericArrayType);
        int i = 0;
        while ((long)i < size) {
            Object guestValue;
            try {
                guestValue = interop.readArrayElement(receiver, i);
            }
            catch (InvalidArrayIndexException e) {
                throw HostInteropErrors.invalidArrayIndex(hostContext, receiver, componentType, i);
            }
            catch (UnsupportedMessageException e) {
                throw HostInteropErrors.arrayReadUnsupported(hostContext, receiver, componentType);
            }
            Object hostValue = HostToTypeNodeGen.getUncached().execute(null, hostContext, guestValue, componentType, genericComponentType, true);
            Array.set(array, i, hostValue);
            ++i;
        }
        return array;
    }

    public static HostToTypeNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=3, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
        return HostToTypeNodeGen.inline(target);
    }

    static final class TypeAndClass<T> {
        static final TypeAndClass<Object> ANY = new TypeAndClass<Object>(null, Object.class);
        final Type type;
        final Class<T> clazz;

        TypeAndClass(Type type, Class<T> clazz) {
            this.type = type;
            this.clazz = clazz;
        }

        public String toString() {
            return "[" + this.clazz + ": " + Objects.toString(this.type) + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TypeAndClass)) {
                return false;
            }
            TypeAndClass other = (TypeAndClass)obj;
            return Objects.equals(this.clazz, other.clazz) && Objects.equals(this.type, other.type);
        }
    }
}

