/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.arrow;

import com.oracle.graal.python.nodes.arrow.capsule.ArrowArrayCapsuleDestructor;
import com.oracle.graal.python.nodes.arrow.capsule.ArrowSchemaCapsuleDestructor;
import com.oracle.graal.python.nodes.arrow.release_callback.ArrowSchemaReleaseCallback;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.arrow.ArrowUtil;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.nfi.api.SignatureLibrary;

public class ArrowSupport {
    protected final PythonContext ctx;
    private Object arrowArrayDestructorNFIClosure;
    @CompilerDirectives.CompilationFinal
    private long arrowArrayDestructor;
    private Object arrowSchemaDestructorNFIClosure;
    @CompilerDirectives.CompilationFinal
    private long arrowSchemaDestructorCallback;
    private Object arrowSchemaNFIClosure;
    @CompilerDirectives.CompilationFinal
    private long arrowSchemaReleaseCallback;

    public ArrowSupport(PythonContext ctx) {
        this.ctx = ctx;
    }

    public long getArrowSchemaDestructor() {
        if (this.arrowSchemaDestructorCallback == 0L) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.initArrowSchemaDestructor();
        }
        return this.arrowSchemaDestructorCallback;
    }

    public long getArrowArrayDestructor() {
        if (this.arrowArrayDestructor == 0L) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.initArrowArrayDestructor();
        }
        return this.arrowArrayDestructor;
    }

    public long getArrowSchemaReleaseCallback() {
        if (this.arrowSchemaReleaseCallback == 0L) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.initArrowSchemaReleaseCallback();
        }
        return this.arrowSchemaReleaseCallback;
    }

    @CompilerDirectives.TruffleBoundary
    private void initArrowArrayDestructor() {
        CompilerAsserts.neverPartOfCompilation();
        Object signature = ArrowUtil.createNfiSignature("(POINTER):VOID", this.ctx);
        ArrowArrayCapsuleDestructor executable = new ArrowArrayCapsuleDestructor();
        this.arrowArrayDestructorNFIClosure = SignatureLibrary.getUncached().createClosure(signature, (Object)executable);
        this.arrowArrayDestructor = PythonUtils.coerceToLong(this.arrowArrayDestructorNFIClosure, InteropLibrary.getUncached());
    }

    @CompilerDirectives.TruffleBoundary
    private void initArrowSchemaDestructor() {
        CompilerAsserts.neverPartOfCompilation();
        Object signature = ArrowUtil.createNfiSignature("(POINTER):VOID", this.ctx);
        ArrowSchemaCapsuleDestructor executable = new ArrowSchemaCapsuleDestructor();
        this.arrowSchemaDestructorNFIClosure = SignatureLibrary.getUncached().createClosure(signature, (Object)executable);
        this.arrowSchemaDestructorCallback = PythonUtils.coerceToLong(this.arrowSchemaDestructorNFIClosure, InteropLibrary.getUncached());
    }

    @CompilerDirectives.TruffleBoundary
    private void initArrowSchemaReleaseCallback() {
        CompilerAsserts.neverPartOfCompilation();
        Object signature = ArrowUtil.createNfiSignature("(UINT64):VOID", this.ctx);
        ArrowSchemaReleaseCallback executable = new ArrowSchemaReleaseCallback();
        this.arrowSchemaNFIClosure = SignatureLibrary.getUncached().createClosure(signature, (Object)executable);
        this.arrowSchemaReleaseCallback = PythonUtils.coerceToLong(this.arrowSchemaNFIClosure, InteropLibrary.getUncached());
    }
}

