/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.type.slots;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTiming;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.type.slots.BuiltinDispatchers;
import com.oracle.graal.python.builtins.objects.type.slots.BuiltinSlotWrapperSignature;
import com.oracle.graal.python.builtins.objects.type.slots.NodeFactoryUtils;
import com.oracle.graal.python.builtins.objects.type.slots.PythonDispatchers;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.attributes.LookupAttributeInMRONode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.utilities.TruffleWeakReference;
import java.util.Objects;

public final class TpSlotMpAssSubscript {
    private TpSlotMpAssSubscript() {
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    @ImportStatic(value={PGuards.class})
    public static abstract class CallManagedSlotMpAssSubscriptNode
    extends Node {
        public abstract void execute(VirtualFrame var1, Node var2, TpSlot.TpSlotManaged var3, Object var4, Object var5, Object var6);

        @Specialization(guards={"slot == cachedSlot"}, limit="3")
        static void callCachedBuiltin(VirtualFrame frame, TpSlotMpAssSubscriptBuiltin slot, Object self, Object key, Object value, @Cached(value="slot") TpSlotMpAssSubscriptBuiltin cachedSlot, @Cached(value="cachedSlot.createSlotNode()") MpAssSubscriptBuiltinNode slotNode) {
            slotNode.executeVoid(frame, self, key, value);
        }

        @Specialization(guards={"!isNoValue(value)"})
        static void callPythonSimpleSet(VirtualFrame frame, Node inliningTarget, TpSlotMpAssSubscriptPython slot, Object self, Object key, Object value, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached PythonDispatchers.TernaryPythonSlotDispatcherNode callPythonFun) {
            Object callable = slot.getSetitem();
            if (callable == null) {
                throw CallManagedSlotMpAssSubscriptNode.raiseAttributeError(inliningTarget, raiseNode, SpecialMethodNames.T___SETITEM__);
            }
            callPythonFun.execute(frame, inliningTarget, callable, slot.getType(), self, key, value);
        }

        @Specialization(guards={"isNoValue(value)"})
        @HostCompilerDirectives.InliningCutoff
        static void callPythonSimpleDel(VirtualFrame frame, Node inliningTarget, TpSlotMpAssSubscriptPython slot, Object self, Object key, Object value, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached PythonDispatchers.BinaryPythonSlotDispatcherNode callPythonFun) {
            Object callable = slot.getDelitem();
            if (callable == null) {
                throw CallManagedSlotMpAssSubscriptNode.raiseAttributeError(inliningTarget, raiseNode, SpecialMethodNames.T___DELITEM__);
            }
            callPythonFun.execute(frame, inliningTarget, callable, slot.getType(), self, key);
        }

        @HostCompilerDirectives.InliningCutoff
        private static PException raiseAttributeError(Node inliningTarget, PRaiseNode.Lazy raiseNode, TruffleString attrName) {
            return raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.AttributeError, attrName);
        }

        @Specialization(replaces={"callCachedBuiltin"})
        @HostCompilerDirectives.InliningCutoff
        static void callGenericBuiltin(VirtualFrame frame, Node inliningTarget, TpSlotMpAssSubscriptBuiltin slot, Object self, Object key, Object value, @Cached(inline=false) ExecutionContext.CallContext callContext, @Cached InlinedConditionProfile isNullFrameProfile, @Cached(inline=false) IndirectCallNode indirectCallNode) {
            Object[] arguments = PArguments.create(3);
            PArguments.setArgument(arguments, 0, self);
            PArguments.setArgument(arguments, 1, key);
            PArguments.setArgument(arguments, 2, value);
            BuiltinDispatchers.callGenericBuiltin(frame, inliningTarget, slot.callTargetIndex, arguments, callContext, isNullFrameProfile, indirectCallNode);
        }
    }

    @GenerateInline(value=false)
    @GenerateUncached
    static abstract class CallNativeSlotMpAssSubscriptNode
    extends Node {
        private static final CApiTiming C_API_TIMING = CApiTiming.create(true, "sq_ass_item");

        CallNativeSlotMpAssSubscriptNode() {
        }

        abstract void execute(VirtualFrame var1, TpSlot.TpSlotNative var2, Object var3, Object var4, Object var5);

        @Specialization
        static void callNative(VirtualFrame frame, TpSlot.TpSlotNative slot, Object self, Object key, Object value, @Bind(value="this") Node inliningTarget, @Cached PythonContext.GetThreadStateNode getThreadStateNode, @Cached CApiTransitions.PythonToNativeNode selfToNativeNode, @Cached CApiTransitions.PythonToNativeNode keyToNativeNode, @Cached CApiTransitions.PythonToNativeNode valueToNativeNode, @Cached ExternalFunctionNodes.ExternalFunctionInvokeNode externalInvokeNode, @Cached ExternalFunctionNodes.CheckInquiryResultNode checkResultNode) {
            PythonContext.PythonThreadState threadState = getThreadStateNode.execute(inliningTarget);
            Object result = externalInvokeNode.call(frame, inliningTarget, threadState, C_API_TIMING, SpecialMethodNames.T___SETITEM__, slot.callable, selfToNativeNode.execute(self), keyToNativeNode.execute(key), valueToNativeNode.execute(value));
            checkResultNode.execute(threadState, SpecialMethodNames.T___SETITEM__, result);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class CallSlotMpAssSubscriptNode
    extends Node {
        public abstract void execute(VirtualFrame var1, Node var2, TpSlot var3, Object var4, Object var5, Object var6);

        @Specialization
        static void callManagedSlot(VirtualFrame frame, Node inliningTarget, TpSlot.TpSlotManaged slot, Object self, Object key, Object value, @Cached CallManagedSlotMpAssSubscriptNode slotNode) {
            slotNode.execute(frame, inliningTarget, slot, self, key, value);
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static void callNative(VirtualFrame frame, TpSlot.TpSlotNative slot, Object self, Object key, Object value, @Cached(inline=false) CallNativeSlotMpAssSubscriptNode callNativeSlot) {
            callNativeSlot.execute(frame, slot, self, key, value);
        }
    }

    public static final class TpSlotMpAssSubscriptPython
    extends TpSlot.TpSlotPython {
        private final TruffleWeakReference<Object> setitem;
        private final TruffleWeakReference<Object> delitem;
        private final TruffleWeakReference<Object> type;

        public TpSlotMpAssSubscriptPython(Object setitem, Object delitem, Object type) {
            this.setitem = TpSlotMpAssSubscriptPython.asWeakRef(setitem);
            this.delitem = TpSlotMpAssSubscriptPython.asWeakRef(delitem);
            this.type = new TruffleWeakReference(type);
        }

        public static TpSlotMpAssSubscriptPython create(Object[] callables, TruffleString[] callableNames, Object type) {
            assert (callables.length == 2);
            assert (callableNames == null || callableNames[0].equals((Object)SpecialMethodNames.T___SETITEM__) && callableNames[1].equals((Object)SpecialMethodNames.T___DELITEM__));
            return new TpSlotMpAssSubscriptPython(callables[0], callables[1], type);
        }

        @Override
        public TpSlot.TpSlotPython forNewType(Object klass) {
            Object newSet = LookupAttributeInMRONode.Dynamic.getUncached().execute(klass, SpecialMethodNames.T___SETITEM__);
            Object newDel = LookupAttributeInMRONode.Dynamic.getUncached().execute(klass, SpecialMethodNames.T___DELITEM__);
            if (newSet != this.getSetitem() || newDel != this.getDelitem()) {
                return new TpSlotMpAssSubscriptPython(newSet, newDel, this.getType());
            }
            return this;
        }

        public Object getSetitem() {
            return this.safeGet(this.setitem);
        }

        public Object getDelitem() {
            return this.safeGet(this.delitem);
        }

        public Object getType() {
            return this.safeGet(this.type);
        }
    }

    @GenerateInline(value=false, inherit=true)
    public static abstract class MpAssSubscriptBuiltinNode
    extends PythonTernaryBuiltinNode {
        public abstract void executeVoid(VirtualFrame var1, Object var2, Object var3, Object var4);

        @Override
        public final Object execute(VirtualFrame frame, Object self, Object key, Object value) {
            this.executeVoid(frame, self, key, value);
            return PNone.NONE;
        }
    }

    public static abstract class TpSlotMpAssSubscriptBuiltin<T extends MpAssSubscriptBuiltinNode>
    extends TpSlot.TpSlotBuiltinBase<T> {
        public static final BuiltinSlotWrapperSignature SET_SIGNATURE = BuiltinSlotWrapperSignature.of(BuiltinSlotWrapperSignature.J_DOLLAR_SELF, "key", "value");
        private final int callTargetIndex = TpSlot.TpSlotBuiltinCallTargetRegistry.getNextCallTargetIndex();

        protected TpSlotMpAssSubscriptBuiltin(NodeFactory<T> nodeFactory) {
            super(nodeFactory, BuiltinSlotWrapperSignature.BINARY, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC);
        }

        final MpAssSubscriptBuiltinNode createSlotNode() {
            return (MpAssSubscriptBuiltinNode)((Object)this.createNode());
        }

        @Override
        public void initialize(PythonLanguage language) {
            RootCallTarget target = TpSlotMpAssSubscriptBuiltin.createBuiltinCallTarget(language, SET_SIGNATURE, this.getNodeFactory(), "__setitem__");
            language.setBuiltinSlotCallTarget(this.callTargetIndex, target);
        }

        @Override
        public PBuiltinFunction createBuiltin(Python3Core core, Object type, TruffleString tsName, ExternalFunctionNodes.PExternalFunctionWrapper wrapper) {
            return switch (wrapper) {
                case ExternalFunctionNodes.PExternalFunctionWrapper.OBJOBJARGPROC -> this.createBuiltin(core, type, SpecialMethodNames.T___SETITEM__, SET_SIGNATURE, wrapper, this.getNodeFactory());
                case ExternalFunctionNodes.PExternalFunctionWrapper.MP_DELITEM -> this.createBuiltin(core, type, SpecialMethodNames.T___DELITEM__, BuiltinSlotWrapperSignature.BINARY, wrapper, NodeFactoryUtils.BinaryToTernaryBuiltinNode.wrapFactory(this.getNodeFactory()));
                default -> throw new IllegalStateException(Objects.toString(wrapper));
            };
        }
    }
}

