/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.type;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeClass;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.BuiltinMethodDescriptor;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.GetMethodsFlagsNodeGen;
import com.oracle.graal.python.nodes.HiddenAttr;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.attributes.LookupAttributeInMRONode;
import com.oracle.graal.python.nodes.attributes.LookupCallableSlotInMRONode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromPythonObjectNode;
import com.oracle.graal.python.nodes.object.GetDictIfExistsNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.sequence.storage.MroSequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.utilities.CyclicAssumption;
import java.lang.invoke.CallSite;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;

public final class SpecialMethodSlot
extends Enum<SpecialMethodSlot> {
    public static final /* enum */ SpecialMethodSlot DelAttr = new SpecialMethodSlot(SpecialMethodNames.T___DELATTR__);
    public static final /* enum */ SpecialMethodSlot Dict = new SpecialMethodSlot(SpecialAttributeNames.T___DICT__);
    public static final /* enum */ SpecialMethodSlot Iter = new SpecialMethodSlot(SpecialMethodNames.T___ITER__);
    public static final /* enum */ SpecialMethodSlot Next = new SpecialMethodSlot(SpecialMethodNames.T___NEXT__);
    public static final /* enum */ SpecialMethodSlot Await = new SpecialMethodSlot(SpecialMethodNames.T___AWAIT__, 0x40000000000000L);
    public static final /* enum */ SpecialMethodSlot AEnter = new SpecialMethodSlot(SpecialMethodNames.T___AENTER__);
    public static final /* enum */ SpecialMethodSlot AExit = new SpecialMethodSlot(SpecialMethodNames.T___AEXIT__);
    public static final /* enum */ SpecialMethodSlot AIter = new SpecialMethodSlot(SpecialMethodNames.T___AITER__, 0x80000000000000L);
    public static final /* enum */ SpecialMethodSlot ANext = new SpecialMethodSlot(SpecialMethodNames.T___ANEXT__, 0x100000000000000L);
    public static final /* enum */ SpecialMethodSlot New = new SpecialMethodSlot(SpecialMethodNames.T___NEW__, false);
    public static final /* enum */ SpecialMethodSlot Init = new SpecialMethodSlot(SpecialMethodNames.T___INIT__, false);
    public static final /* enum */ SpecialMethodSlot SetName = new SpecialMethodSlot(SpecialMethodNames.T___SET_NAME__, false);
    public static final /* enum */ SpecialMethodSlot InstanceCheck = new SpecialMethodSlot(SpecialMethodNames.T___INSTANCECHECK__);
    public static final /* enum */ SpecialMethodSlot Subclasscheck = new SpecialMethodSlot(SpecialMethodNames.T___SUBCLASSCHECK__);
    public static final /* enum */ SpecialMethodSlot Call = new SpecialMethodSlot(SpecialMethodNames.T___CALL__, false);
    public static final /* enum */ SpecialMethodSlot Exit = new SpecialMethodSlot(SpecialMethodNames.T___EXIT__);
    public static final /* enum */ SpecialMethodSlot Enter = new SpecialMethodSlot(SpecialMethodNames.T___ENTER__);
    public static final /* enum */ SpecialMethodSlot LengthHint = new SpecialMethodSlot(SpecialMethodNames.T___LENGTH_HINT__);
    public static final /* enum */ SpecialMethodSlot Contains = new SpecialMethodSlot(SpecialMethodNames.T___CONTAINS__, 0x800000000000L);
    public static final /* enum */ SpecialMethodSlot Hash = new SpecialMethodSlot(SpecialMethodNames.T___HASH__);
    public static final /* enum */ SpecialMethodSlot Index = new SpecialMethodSlot(SpecialMethodNames.T___INDEX__, 0x200000000L);
    public static final /* enum */ SpecialMethodSlot Float = new SpecialMethodSlot(SpecialMethodNames.T___FLOAT__, 262144L);
    public static final /* enum */ SpecialMethodSlot Int = new SpecialMethodSlot(SpecialMethodNames.T___INT__, 65536L);
    public static final /* enum */ SpecialMethodSlot Str = new SpecialMethodSlot(SpecialMethodNames.T___STR__);
    public static final /* enum */ SpecialMethodSlot Repr = new SpecialMethodSlot(SpecialMethodNames.T___REPR__);
    public static final /* enum */ SpecialMethodSlot Format = new SpecialMethodSlot(SpecialMethodNames.T___FORMAT__);
    public static final /* enum */ SpecialMethodSlot Missing = new SpecialMethodSlot(SpecialMethodNames.T___MISSING__);
    public static final /* enum */ SpecialMethodSlot Eq = new SpecialMethodSlot(SpecialMethodNames.T___EQ__);
    public static final /* enum */ SpecialMethodSlot Ne = new SpecialMethodSlot(SpecialMethodNames.T___NE__);
    public static final /* enum */ SpecialMethodSlot Lt = new SpecialMethodSlot(SpecialMethodNames.T___LT__);
    public static final /* enum */ SpecialMethodSlot Le = new SpecialMethodSlot(SpecialMethodNames.T___LE__);
    public static final /* enum */ SpecialMethodSlot Gt = new SpecialMethodSlot(SpecialMethodNames.T___GT__);
    public static final /* enum */ SpecialMethodSlot Ge = new SpecialMethodSlot(SpecialMethodNames.T___GE__);
    public static final /* enum */ SpecialMethodSlot Pow = new SpecialMethodSlot(SpecialMethodNames.T___POW__, 32L);
    public static final /* enum */ SpecialMethodSlot RPow = new SpecialMethodSlot(SpecialMethodNames.T___RPOW__, 32L);
    public static final /* enum */ SpecialMethodSlot Round = new SpecialMethodSlot(SpecialMethodNames.T___ROUND__);
    public static final /* enum */ SpecialMethodSlot IAdd = new SpecialMethodSlot(SpecialMethodNames.T___IADD__, 524288L);
    public static final /* enum */ SpecialMethodSlot IMul = new SpecialMethodSlot(SpecialMethodNames.T___IMUL__, 0x200000L);
    public static final /* enum */ SpecialMethodSlot Reversed = new SpecialMethodSlot(SpecialMethodNames.T___REVERSED__);
    public static final /* enum */ SpecialMethodSlot Bytes = new SpecialMethodSlot(SpecialMethodNames.T___BYTES__);
    public static final SpecialMethodSlot[] VALUES;
    private final TruffleString name;
    @CompilerDirectives.CompilationFinal
    private SpecialMethodSlot reverse;
    private final boolean allowsBuiltinDescriptors;
    private final long methodsFlag;
    private static final Object builtinSlotsInitializationLock;
    private static volatile boolean builtinSlotsInitialized;
    private static final ArrayDeque<Object> initializingTypes;
    private static final /* synthetic */ SpecialMethodSlot[] $VALUES;

    public static SpecialMethodSlot[] values() {
        return (SpecialMethodSlot[])$VALUES.clone();
    }

    public static SpecialMethodSlot valueOf(String name) {
        return Enum.valueOf(SpecialMethodSlot.class, name);
    }

    private SpecialMethodSlot(TruffleString name, long methodsFlag, boolean allowsBuiltinDescriptors) {
        this.name = name;
        this.allowsBuiltinDescriptors = allowsBuiltinDescriptors;
        this.methodsFlag = methodsFlag;
    }

    private SpecialMethodSlot(TruffleString name, boolean allowsBuiltinDescriptors) {
        this(name, 0L, allowsBuiltinDescriptors);
    }

    private SpecialMethodSlot(TruffleString name, long methodsFlag) {
        this(name, methodsFlag, true);
    }

    private SpecialMethodSlot(TruffleString name) {
        this(name, 0L, true);
    }

    public TruffleString getName() {
        return this.name;
    }

    public SpecialMethodSlot getReverse() {
        return this.reverse;
    }

    public long getMethodsFlag() {
        return this.methodsFlag;
    }

    public Object getValue(PythonManagedClass klass) {
        assert (klass.specialMethodSlots != null);
        return klass.specialMethodSlots[this.ordinal()];
    }

    @Idempotent
    public Object getValue(PythonBuiltinClassType klassType) {
        return klassType.getSpecialMethodSlots()[this.ordinal()];
    }

    private void setValue(PythonManagedClass klass, Object value, PythonContext context) {
        assert (!context.isInitialized() || !(klass instanceof PythonBuiltinClass) || ((PythonBuiltinClass)klass).getType().getSpecialMethodSlots() == null) : String.format("%s.%s = %s", klass, this.getName(), value);
        klass.specialMethodSlots[this.ordinal()] = SpecialMethodSlot.asSlotValue(this, value, context.getLanguage());
        if (klass instanceof PythonClass) {
            ((PythonClass)klass).invalidateSlotsFinalAssumption();
        }
    }

    public static void initializeBuiltinsSpecialMethodSlots(Python3Core core) {
        for (PythonBuiltinClassType type : PythonBuiltinClassType.VALUES) {
            SpecialMethodSlot.initializeBuiltinClassSpecialMethodSlots(core, core.lookupType(type));
        }
        SpecialMethodSlot.initializeBuiltinTypeSlots(core);
    }

    private static void initializeBuiltinClassSpecialMethodSlots(Python3Core core, PythonBuiltinClass klass) {
        CompilerAsserts.neverPartOfCompilation();
        if (klass.specialMethodSlots != null) {
            return;
        }
        PythonBuiltinClassType klassType = klass.getType();
        if (klassType.getBase() != null) {
            PythonBuiltinClass base = core.lookupType(klassType.getBase());
            SpecialMethodSlot.initializeBuiltinClassSpecialMethodSlots(core, base);
            Object[] baseSlots = base.specialMethodSlots;
            klass.specialMethodSlots = Arrays.copyOf(baseSlots, baseSlots.length);
        } else {
            Object[] slots = new Object[VALUES.length];
            Arrays.fill(slots, PNone.NO_VALUE);
            klass.specialMethodSlots = slots;
        }
        ReadAttributeFromObjectNode readNode = ReadAttributeFromObjectNode.getUncachedForceType();
        for (SpecialMethodSlot slot : VALUES) {
            Object value = readNode.execute(klass, slot.getName());
            if (value == PNone.NO_VALUE) continue;
            slot.setValue(klass, value, core.getContext());
        }
    }

    public static boolean areBuiltinSlotsInitialized() {
        return builtinSlotsInitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeBuiltinTypeSlots(Python3Core core) {
        Object object = builtinSlotsInitializationLock;
        synchronized (object) {
            if (builtinSlotsInitialized) {
                return;
            }
            SpecialMethodSlot.initializeBuiltinTypeSlotsImpl(core);
            builtinSlotsInitialized = true;
        }
    }

    private static void initializeBuiltinTypeSlotsImpl(Python3Core core) {
        for (PythonBuiltinClassType type : PythonBuiltinClassType.VALUES) {
            Object[] typeSlots = new Object[VALUES.length];
            PythonBuiltinClass klass = core.lookupType(type);
            for (SpecialMethodSlot slot : VALUES) {
                if (type.redefinesSlot(slot)) continue;
                Object value = slot.getValue(klass);
                if (value instanceof PBuiltinFunction && slot.allowsBuiltinDescriptors) {
                    BuiltinMethodDescriptor info = BuiltinMethodDescriptor.get((PBuiltinFunction)value);
                    if (info == null) continue;
                    typeSlots[slot.ordinal()] = info;
                    continue;
                }
                if ((!(value instanceof BuiltinMethodDescriptor) || !slot.allowsBuiltinDescriptors) && !PythonLanguage.canCache(value)) continue;
                typeSlots[slot.ordinal()] = value;
            }
            type.setSpecialMethodSlots(typeSlots);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static void reinitializeSpecialMethodSlots(PythonManagedClass klass, PythonLanguage language) {
        SpecialMethodSlot.reinitializeSpecialMethodSlots((Object)klass, language);
    }

    @CompilerDirectives.TruffleBoundary
    public static void reinitializeSpecialMethodSlots(PythonNativeClass klass, PythonLanguage language) {
        SpecialMethodSlot.reinitializeSpecialMethodSlots((Object)klass, language);
    }

    private static void reinitializeSpecialMethodSlots(Object klass, PythonLanguage language) {
        PythonAbstractClass[] subClasses;
        if (klass instanceof PythonManagedClass) {
            PythonManagedClass managedClass = (PythonManagedClass)klass;
            if (managedClass.specialMethodSlots != null) {
                managedClass.specialMethodSlots = null;
                SpecialMethodSlot.initializeSpecialMethodSlots(managedClass, TypeNodes.GetMroStorageNode.executeUncached(managedClass), language);
            }
            subClasses = TypeNodes.GetSubclassesAsArrayNode.executeUncached(managedClass);
        } else if (klass instanceof PythonNativeClass) {
            PythonNativeClass clazz = (PythonNativeClass)klass;
            subClasses = TypeNodes.GetSubclassesAsArrayNode.executeUncached(clazz);
        } else {
            throw new AssertionError((Object)Objects.toString(klass));
        }
        for (PythonAbstractClass subClass : subClasses) {
            SpecialMethodSlot.reinitializeSpecialMethodSlots(subClass, language);
        }
    }

    public static void initializeSpecialMethodSlots(PythonManagedClass klass, MroSequenceStorage mro, PythonLanguage language) {
        klass.specialMethodSlots = SpecialMethodSlot.initializeSpecialMethodsSlots(klass, mro, language);
    }

    @CompilerDirectives.TruffleBoundary
    private static Object[] initializeSpecialMethodsSlots(PythonManagedClass klass, MroSequenceStorage mro, PythonLanguage language) {
        Object[] slots;
        if (mro.length() >= 2 && klass.getBaseClasses().length <= 1) {
            PythonAbstractClass firstType = mro.getPythonClassItemNormalized(0);
            PythonAbstractClass secondType = mro.getPythonClassItemNormalized(1);
            if (firstType == klass && PythonManagedClass.isInstance(secondType)) {
                PythonManagedClass managedBase = PythonManagedClass.cast(secondType);
                if (managedBase.specialMethodSlots != null && SpecialMethodSlot.isMroSubtype(mro, managedBase)) {
                    Object[] result = PythonUtils.arrayCopyOf(managedBase.specialMethodSlots, managedBase.specialMethodSlots.length);
                    SpecialMethodSlot.setSlotsFromManaged(result, klass, language);
                    SpecialMethodSlot.fixupNewSlot(result, klass);
                    SpecialMethodSlot.setMethodsFlags(result, klass);
                    return result;
                }
            }
        }
        if (mro.length() == 0) {
            slots = new Object[VALUES.length];
            Arrays.fill(slots, PNone.NO_VALUE);
            return slots;
        }
        slots = null;
        PythonAbstractClass lastType = mro.getPythonClassItemNormalized(mro.length() - 1);
        boolean slotsInitializedFromLast = false;
        if (PythonManagedClass.isInstance(lastType)) {
            PythonManagedClass lastClass = PythonManagedClass.cast(lastType);
            if (lastClass.specialMethodSlots != null) {
                slots = PythonUtils.arrayCopyOf(lastClass.specialMethodSlots, lastClass.specialMethodSlots.length);
                slotsInitializedFromLast = true;
            }
        }
        if (!slotsInitializedFromLast) {
            slots = new Object[VALUES.length];
            Arrays.fill(slots, PNone.NO_VALUE);
        }
        int skip = slotsInitializedFromLast ? 1 : 0;
        for (int i = mro.length() - skip - 1; i >= 0; --i) {
            PythonAbstractClass base = mro.getPythonClassItemNormalized(i);
            if (PythonManagedClass.isInstance(base)) {
                SpecialMethodSlot.setSlotsFromManaged(slots, PythonManagedClass.cast(base), language);
                continue;
            }
            SpecialMethodSlot.setSlotsFromGeneric(slots, base, language);
        }
        SpecialMethodSlot.fixupNewSlot(slots, klass);
        SpecialMethodSlot.setMethodsFlags(slots, klass);
        return slots;
    }

    private static boolean isMroSubtype(MroSequenceStorage superTypeMro, PythonManagedClass subType) {
        boolean isMroSubtype;
        if (subType instanceof PythonBuiltinClass && ((PythonBuiltinClass)subType).getType() == PythonBuiltinClassType.PythonObject) {
            return true;
        }
        MroSequenceStorage subTypeMro = TypeNodes.GetMroStorageNode.executeUncached(subType);
        boolean bl = isMroSubtype = subTypeMro.length() == superTypeMro.length() - 1;
        if (isMroSubtype) {
            for (int i = 0; i < subTypeMro.length(); ++i) {
                if (superTypeMro.getPythonClassItemNormalized(i + 1) == subTypeMro.getPythonClassItemNormalized(i)) continue;
                isMroSubtype = false;
                break;
            }
        }
        return isMroSubtype;
    }

    private static void setMethodsFlag(PythonManagedClass klass, long flag, PythonContext context) {
        if (flag == 0L) {
            return;
        }
        long isHeaptype = context.isCoreInitialized() ? 0x8000000000L : 0L;
        klass.setMethodsFlags(flag | isHeaptype);
    }

    private static void setMethodsFlag(PythonNativeClass cls, long flag, PythonContext context) {
        if (flag == 0L) {
            return;
        }
        long flags = GetMethodsFlagsNodeGen.getUncached().execute(null, cls);
        if ((flags & flag) == 0L) {
            CyclicAssumption assumption = context.getNativeClassStableAssumption(cls, false);
            if (assumption != null && assumption.getAssumption().isValid()) {
                assumption.invalidate("methods flags have changed after class creation");
            }
            if (cls instanceof PythonAbstractNativeObject) {
                PythonAbstractNativeObject nclass = (PythonAbstractNativeObject)cls;
                HiddenAttr.WriteNode.executeUncached(nclass, HiddenAttr.METHODS_FLAGS, flags | flag);
            }
        }
    }

    private static void setMethodsFlags(Object[] slots, PythonManagedClass klass) {
        long methodsFlags = 0L;
        for (SpecialMethodSlot slot : VALUES) {
            if (slot.getMethodsFlag() <= 0L || slots[slot.ordinal()] == PNone.NO_VALUE) continue;
            methodsFlags |= slot.getMethodsFlag();
        }
        Object object = klass.getInitialPythonClass();
        if (object instanceof PythonBuiltinClassType) {
            PythonBuiltinClassType builtinClass = (PythonBuiltinClassType)((Object)object);
            methodsFlags |= builtinClass.getMethodsFlags();
        }
        SpecialMethodSlot.setMethodsFlag(klass, methodsFlags, PythonContext.get(null));
    }

    private static void fixupNewSlot(Object[] slots, Object type) {
        PBuiltinFunction builtinFunction;
        Object mroInheritedNew = slots[New.ordinal()];
        if (mroInheritedNew instanceof PBuiltinMethod) {
            PBuiltinMethod builtinMethod = (PBuiltinMethod)mroInheritedNew;
            mroInheritedNew = builtinMethod.getBuiltinFunction();
        }
        if (mroInheritedNew instanceof PBuiltinFunction && (builtinFunction = (PBuiltinFunction)mroInheritedNew).getName().equalsUncached((AbstractTruffleString)SpecialMethodSlot.New.name, PythonUtils.TS_ENCODING)) {
            Object tpBaseInheritedNew = ReadAttributeFromObjectNode.getUncachedForceType().execute(type, SpecialMethodSlot.New.name);
            if (tpBaseInheritedNew == PNone.NO_VALUE) {
                Object base = TypeNodes.GetBaseClassNode.executeUncached(type);
                tpBaseInheritedNew = LookupCallableSlotInMRONode.getUncached(New).execute(base);
            }
            slots[SpecialMethodSlot.New.ordinal()] = tpBaseInheritedNew;
        }
    }

    private static void setSlotsFromManaged(Object[] slots, PythonManagedClass source, PythonLanguage language) {
        PDict dict = GetDictIfExistsNode.getUncached().execute(source);
        if (dict == null) {
            for (SpecialMethodSlot slot : VALUES) {
                Object value = ReadAttributeFromPythonObjectNode.executeUncached(source, slot.getName(), PNone.NO_VALUE);
                if (value == PNone.NO_VALUE) continue;
                slots[slot.ordinal()] = SpecialMethodSlot.asSlotValue(slot, value, language);
            }
        } else {
            HashingStorage storage = dict.getDictStorage();
            for (SpecialMethodSlot slot : VALUES) {
                Object value = HashingStorageNodes.HashingStorageGetItem.executeUncached(storage, slot.getName());
                if (value == null) continue;
                slots[slot.ordinal()] = SpecialMethodSlot.asSlotValue(slot, value, language);
            }
        }
    }

    private static void setSlotsFromGeneric(Object[] slots, PythonAbstractClass base, PythonLanguage language) {
        ReadAttributeFromObjectNode readAttNode = ReadAttributeFromObjectNode.getUncachedForceType();
        for (SpecialMethodSlot slot : VALUES) {
            Object value = readAttNode.execute(base, slot.getName());
            if (value == PNone.NO_VALUE) continue;
            slots[slot.ordinal()] = SpecialMethodSlot.asSlotValue(slot, value, language);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static void fixupSpecialMethodSlot(PythonNativeClass klass, SpecialMethodSlot slot, Object value) {
        Object newValue = value;
        if (value == PNone.NO_VALUE) {
            newValue = LookupAttributeInMRONode.lookupSlowPath(klass, slot.getName());
        }
        SpecialMethodSlot.fixupSpecialMethodInSubClasses(TypeNodes.GetSubclassesAsArrayNode.executeUncached(klass), slot, newValue, PythonContext.get(null));
    }

    @CompilerDirectives.TruffleBoundary
    public static void fixupSpecialMethodSlot(PythonManagedClass klass, SpecialMethodSlot slot, Object value) {
        if (klass.specialMethodSlots == null) {
            assert (initializingTypes == null || initializingTypes.contains(klass));
            return;
        }
        Object oldValue = slot.getValue(klass);
        if (value == oldValue) {
            return;
        }
        Object newValue = value;
        if (value == PNone.NO_VALUE) {
            newValue = LookupAttributeInMRONode.lookupSlowPath(klass, slot.getName());
        }
        PythonContext context = PythonContext.get(null);
        slot.setValue(klass, newValue, context);
        if (oldValue == PNone.NO_VALUE) {
            SpecialMethodSlot.setMethodsFlag(klass, slot.getMethodsFlag(), context);
        }
        SpecialMethodSlot.fixupSpecialMethodInSubClasses(TypeNodes.GetSubclassesAsArrayNode.executeUncached(klass), slot, value, context);
    }

    private static void fixupSpecialMethodSlotInternal(PythonManagedClass klass, SpecialMethodSlot slot, Object newValue, PythonContext context) {
        Object currentOldValue = slot.getValue(klass);
        Object currentNewValue = LookupAttributeInMRONode.lookupSlowPath(klass, slot.getName());
        if (newValue != PNone.NO_VALUE) {
            assert (currentNewValue != PNone.NO_VALUE);
            assert (SpecialMethodSlot.asSlotValue(slot, currentNewValue, context.getLanguage()) == currentOldValue || currentNewValue == newValue);
        }
        if (currentOldValue != currentNewValue) {
            slot.setValue(klass, currentNewValue, context);
            SpecialMethodSlot.fixupSpecialMethodInSubClasses(TypeNodes.GetSubclassesAsArrayNode.executeUncached(klass), slot, newValue, context);
        }
    }

    private static void fixupSpecialMethodSlot(Object klass, SpecialMethodSlot slot, Object newValue, PythonContext context) {
        if (klass instanceof PythonManagedClass) {
            PythonManagedClass clazz = (PythonManagedClass)klass;
            SpecialMethodSlot.setMethodsFlag(clazz, slot.getMethodsFlag(), context);
            SpecialMethodSlot.fixupSpecialMethodSlotInternal((PythonManagedClass)klass, slot, newValue, context);
        } else if (klass instanceof PythonNativeClass) {
            PythonNativeClass clazz = (PythonNativeClass)klass;
            SpecialMethodSlot.setMethodsFlag(clazz, slot.getMethodsFlag(), context);
            SpecialMethodSlot.fixupSpecialMethodInSubClasses(TypeNodes.GetSubclassesAsArrayNode.executeUncached(clazz), slot, newValue, context);
        } else {
            throw new AssertionError((Object)Objects.toString(klass));
        }
    }

    private static void fixupSpecialMethodInSubClasses(PythonAbstractClass[] subClasses, SpecialMethodSlot slot, Object newValue, PythonContext context) {
        for (PythonAbstractClass subClass : subClasses) {
            SpecialMethodSlot.fixupSpecialMethodSlot(subClass, slot, newValue, context);
        }
    }

    private static Object asSlotValue(SpecialMethodSlot slot, Object value, PythonLanguage language) {
        PBuiltinFunction builtinFun;
        BuiltinMethodDescriptor info;
        if (value instanceof PBuiltinFunction && slot.allowsBuiltinDescriptors && (info = BuiltinMethodDescriptor.get(builtinFun = (PBuiltinFunction)value)) != null) {
            if (builtinFun.getDescriptor() == null) {
                language.registerBuiltinDescriptorCallTarget(info, builtinFun.getCallTarget());
                builtinFun.setDescriptor(info);
            }
            return info;
        }
        return value;
    }

    public static boolean canBeSpecial(TruffleString name, TruffleString.CodePointLengthNode codePointLengthNode, TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
        int len = codePointLengthNode.execute((AbstractTruffleString)name, PythonUtils.TS_ENCODING);
        return len > 5 && codePointAtIndexNode.execute((AbstractTruffleString)name, len - 2, PythonUtils.TS_ENCODING) == 95 && codePointAtIndexNode.execute((AbstractTruffleString)name, len - 1, PythonUtils.TS_ENCODING) == 95 && codePointAtIndexNode.execute((AbstractTruffleString)name, 1, PythonUtils.TS_ENCODING) == 95 && codePointAtIndexNode.execute((AbstractTruffleString)name, 0, PythonUtils.TS_ENCODING) == 95;
    }

    @CompilerDirectives.TruffleBoundary
    public static SpecialMethodSlot findSpecialSlotUncached(TruffleString name) {
        return SpecialMethodSlot.findSpecialSlot(name, TruffleString.CodePointLengthNode.getUncached(), TruffleString.CodePointAtIndexNode.getUncached(), TruffleString.EqualNode.getUncached());
    }

    public static SpecialMethodSlot findSpecialSlot(TruffleString name, TruffleString.CodePointLengthNode codePointLengthNode, TruffleString.CodePointAtIndexNode codePointAtIndexNode, TruffleString.EqualNode eqNode) {
        if (!SpecialMethodSlot.canBeSpecial(name, codePointLengthNode, codePointAtIndexNode)) {
            return null;
        }
        int x = codePointAtIndexNode.execute((AbstractTruffleString)name, 2, PythonUtils.TS_ENCODING) * 26 + codePointAtIndexNode.execute((AbstractTruffleString)name, 3, PythonUtils.TS_ENCODING);
        switch (x) {
            case 2779: {
                if (!eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialMethodNames.T___GE__, PythonUtils.TS_ENCODING)) break;
                return Ge;
            }
            case 3091: {
                if (!eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialMethodNames.T___SET_NAME__, PythonUtils.TS_ENCODING)) break;
                return SetName;
            }
            case 2701: {
                if (!eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialMethodNames.T___DELATTR__, PythonUtils.TS_ENCODING)) break;
                return DelAttr;
            }
            case 2705: {
                if (!eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialAttributeNames.T___DICT__, PythonUtils.TS_ENCODING)) break;
                return Dict;
            }
            case 2846: {
                if (!eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialMethodNames.T___ITER__, PythonUtils.TS_ENCODING)) break;
                return Iter;
            }
            case 2961: {
                if (eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialMethodNames.T___NEXT__, PythonUtils.TS_ENCODING)) {
                    return Next;
                }
                if (eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialMethodNames.T___NEW__, PythonUtils.TS_ENCODING)) {
                    return New;
                }
                if (!eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialMethodNames.T___NE__, PythonUtils.TS_ENCODING)) break;
                return Ne;
            }
            case 2840: {
                if (eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialMethodNames.T___INIT__, PythonUtils.TS_ENCODING)) {
                    return Init;
                }
                if (eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialMethodNames.T___INSTANCECHECK__, PythonUtils.TS_ENCODING)) {
                    return InstanceCheck;
                }
                if (eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialMethodNames.T___INDEX__, PythonUtils.TS_ENCODING)) {
                    return Index;
                }
                if (!eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialMethodNames.T___INT__, PythonUtils.TS_ENCODING)) break;
                return Int;
            }
            case 3107: {
                if (!eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialMethodNames.T___SUBCLASSCHECK__, PythonUtils.TS_ENCODING)) break;
                return Subclasscheck;
            }
            case 2671: {
                if (!eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialMethodNames.T___CALL__, PythonUtils.TS_ENCODING)) break;
                return Call;
            }
            case 2746: {
                if (!eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialMethodNames.T___EXIT__, PythonUtils.TS_ENCODING)) break;
                return Exit;
            }
            case 2736: {
                if (!eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialMethodNames.T___ENTER__, PythonUtils.TS_ENCODING)) break;
                return Enter;
            }
            case 2909: {
                if (eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialMethodNames.T___LENGTH_HINT__, PythonUtils.TS_ENCODING)) {
                    return LengthHint;
                }
                if (!eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialMethodNames.T___LE__, PythonUtils.TS_ENCODING)) break;
                return Le;
            }
            case 2685: {
                if (!eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialMethodNames.T___CONTAINS__, PythonUtils.TS_ENCODING)) break;
                return Contains;
            }
            case 2801: {
                if (!eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialMethodNames.T___HASH__, PythonUtils.TS_ENCODING)) break;
                return Hash;
            }
            case 2760: {
                if (!eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialMethodNames.T___FLOAT__, PythonUtils.TS_ENCODING)) break;
                return Float;
            }
            case 3106: {
                if (!eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialMethodNames.T___STR__, PythonUtils.TS_ENCODING)) break;
                return Str;
            }
            case 3065: {
                if (eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialMethodNames.T___REPR__, PythonUtils.TS_ENCODING)) {
                    return Repr;
                }
                if (!eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialMethodNames.T___REVERSED__, PythonUtils.TS_ENCODING)) break;
                return Reversed;
            }
            case 2763: {
                if (!eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialMethodNames.T___FORMAT__, PythonUtils.TS_ENCODING)) break;
                return Format;
            }
            case 2939: {
                if (!eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialMethodNames.T___MISSING__, PythonUtils.TS_ENCODING)) break;
                return Missing;
            }
            case 2739: {
                if (!eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialMethodNames.T___EQ__, PythonUtils.TS_ENCODING)) break;
                return Eq;
            }
            case 2924: {
                if (!eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialMethodNames.T___LT__, PythonUtils.TS_ENCODING)) break;
                return Lt;
            }
            case 2794: {
                if (!eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialMethodNames.T___GT__, PythonUtils.TS_ENCODING)) break;
                return Gt;
            }
            case 2632: {
                if (!eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialMethodNames.T___ANEXT__, PythonUtils.TS_ENCODING)) break;
                return ANext;
            }
            case 3075: {
                if (!eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialMethodNames.T___ROUND__, PythonUtils.TS_ENCODING)) break;
                return Round;
            }
            case 3023: {
                if (!eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialMethodNames.T___POW__, PythonUtils.TS_ENCODING)) break;
                return Pow;
            }
            case 3076: {
                if (!eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialMethodNames.T___RPOW__, PythonUtils.TS_ENCODING)) break;
                return RPow;
            }
            case 2827: {
                if (!eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialMethodNames.T___IADD__, PythonUtils.TS_ENCODING)) break;
                return IAdd;
            }
            case 2839: {
                if (!eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialMethodNames.T___IMUL__, PythonUtils.TS_ENCODING)) break;
                return IMul;
            }
            case 2669: {
                if (!eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialMethodNames.T___BYTES__, PythonUtils.TS_ENCODING)) break;
                return Bytes;
            }
            case 2641: {
                if (!eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialMethodNames.T___AWAIT__, PythonUtils.TS_ENCODING)) break;
                return Await;
            }
            case 2623: {
                if (eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialMethodNames.T___AENTER__, PythonUtils.TS_ENCODING)) {
                    return AEnter;
                }
                if (!eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialMethodNames.T___AEXIT__, PythonUtils.TS_ENCODING)) break;
                return AExit;
            }
            case 2627: {
                if (!eqNode.execute((AbstractTruffleString)name, (AbstractTruffleString)SpecialMethodNames.T___AITER__, PythonUtils.TS_ENCODING)) break;
                return AIter;
            }
        }
        return null;
    }

    private static boolean checkReverseSlots() {
        TruffleString prefix = PythonUtils.tsLiteral("__");
        TruffleString rPrefix = PythonUtils.tsLiteral("__r");
        for (SpecialMethodSlot slot : VALUES) {
            int slotNameLen;
            TruffleString slotNamePart;
            SpecialMethodSlot rslot;
            TruffleString slotName = slot.getName();
            if (!rPrefix.regionEqualsUncached(0, (AbstractTruffleString)slotName, 0, 3, PythonUtils.TS_ENCODING) || (rslot = SpecialMethodSlot.findSpecialSlotUncached(prefix.concatUncached((AbstractTruffleString)(slotNamePart = slotName.substringUncached(3, (slotNameLen = slotName.codePointLengthUncached(PythonUtils.TS_ENCODING)) - 3, PythonUtils.TS_ENCODING, true)), PythonUtils.TS_ENCODING, false))) == null || rslot.reverse == slot) continue;
            assert (false) : slotName;
            return false;
        }
        return true;
    }

    private static boolean checkFind() {
        for (SpecialMethodSlot slot : VALUES) {
            if (SpecialMethodSlot.findSpecialSlotUncached(slot.getName()) == slot) continue;
            assert (false) : slot;
            return false;
        }
        return SpecialMethodSlot.findSpecialSlotUncached(PythonUtils.tsLiteral("__bogus__")) == null;
    }

    public static boolean checkSlotOverrides(Python3Core core) {
        assert (builtinSlotsInitialized);
        HashSet<CallSite> mismatches = new HashSet<CallSite>();
        for (PythonBuiltinClassType type : PythonBuiltinClassType.VALUES) {
            PythonBuiltinClass klass = core.lookupType(type);
            for (SpecialMethodSlot slot : VALUES) {
                Object klassValue;
                Object typeValue = slot.getValue(type);
                if (typeValue == null || (klassValue = slot.getValue(klass)).equals(typeValue) || typeValue instanceof BuiltinMethodDescriptor && klassValue instanceof PBuiltinFunction && ((BuiltinMethodDescriptor)typeValue).isDescriptorOf((PBuiltinFunction)klassValue)) continue;
                mismatches.add((CallSite)((Object)(type.getName().toJavaStringUncached() + "." + slot.getName().toJavaStringUncached())));
            }
        }
        assert (mismatches.size() == 0) : String.join((CharSequence)", ", mismatches);
        return true;
    }

    public static boolean pushInitializedTypePlaceholder() {
        if (initializingTypes != null) {
            initializingTypes.push(42);
        }
        return true;
    }

    public static boolean replaceInitializedTypeTop(Object type) {
        if (initializingTypes != null) {
            assert ((Integer)initializingTypes.pop() == 42);
            initializingTypes.push(type);
        }
        return true;
    }

    public static boolean popInitializedType() {
        if (initializingTypes != null) {
            initializingTypes.pop();
        }
        return true;
    }

    public static boolean validateSlots(Object klassIn) {
        Object expected;
        Object actual;
        if (initializingTypes.contains(klassIn)) {
            return true;
        }
        ReadAttributeFromPythonObjectNode uncachedReadAttrNode = ReadAttributeFromPythonObjectNode.getUncached();
        PythonContext core = PythonContext.get(uncachedReadAttrNode);
        Object klass = klassIn;
        if (klass instanceof PythonBuiltinClassType) {
            PythonBuiltinClassType type = (PythonBuiltinClassType)((Object)klass);
            if (initializingTypes.contains(klass = core.lookupType(type))) {
                return true;
            }
            if (type.getSpecialMethodSlots() == null) {
                return true;
            }
            for (SpecialMethodSlot slot : VALUES) {
                actual = LookupAttributeInMRONode.findAttr(core, type, slot.getName(), uncachedReadAttrNode);
                expected = slot.getValue(type);
                if (expected instanceof BuiltinMethodDescriptor) {
                    assert (actual instanceof PBuiltinFunction);
                    assert (((BuiltinMethodDescriptor)expected).isDescriptorOf((PBuiltinFunction)actual));
                    continue;
                }
                if (expected == null) continue;
                assert (PythonLanguage.canCache(expected));
                assert (actual == expected);
            }
            klass = core.lookupType(type);
        }
        if (klass instanceof PythonManagedClass) {
            PythonManagedClass managed = (PythonManagedClass)klass;
            for (SpecialMethodSlot slot : VALUES) {
                actual = LookupAttributeInMRONode.lookupSlowPath(managed, slot.getName());
                expected = slot.getValue(managed);
                if (expected instanceof NodeFactory) {
                    assert (actual instanceof PBuiltinFunction);
                    assert (((PBuiltinFunction)actual).getBuiltinNodeFactory() == expected);
                    continue;
                }
                assert (actual == expected);
            }
        }
        return true;
    }

    private static /* synthetic */ SpecialMethodSlot[] $values() {
        return new SpecialMethodSlot[]{DelAttr, Dict, Iter, Next, Await, AEnter, AExit, AIter, ANext, New, Init, SetName, InstanceCheck, Subclasscheck, Call, Exit, Enter, LengthHint, Contains, Hash, Index, Float, Int, Str, Repr, Format, Missing, Eq, Ne, Lt, Le, Gt, Ge, Pow, RPow, Round, IAdd, IMul, Reversed, Bytes};
    }

    static {
        $VALUES = SpecialMethodSlot.$values();
        VALUES = SpecialMethodSlot.values();
        SpecialMethodSlot.Pow.reverse = RPow;
        assert (SpecialMethodSlot.checkFind());
        assert (SpecialMethodSlot.checkReverseSlots());
        builtinSlotsInitializationLock = new Object();
        initializingTypes = null;
    }

    static class Flags {
        static final boolean NO_BUILTIN_DESCRIPTORS = false;

        Flags() {
        }
    }
}

