/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.set;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.common.HashingCollectionNodes;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.set.FrozenSetBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.set.PBaseSet;
import com.oracle.graal.python.builtins.objects.set.PFrozenSet;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PFrozenSet})
public final class FrozenSetBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return FrozenSetBuiltinsFactory.getFactories();
    }

    @Builtin(name="__hash__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class HashNode
    extends PythonUnaryBuiltinNode {
        protected static long HASH_UNSET = -1L;

        @Specialization(guards={"self.getHash() != HASH_UNSET"})
        public static long getHash(VirtualFrame frame, PFrozenSet self) {
            return self.getHash();
        }

        @Specialization(guards={"self.getHash() == HASH_UNSET"})
        public static long computeHash(VirtualFrame frame, PFrozenSet self, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageGetIterator getIter, @Cached HashingStorageNodes.HashingStorageIteratorNext iterNext, @Cached HashingStorageNodes.HashingStorageIteratorKey iterKey, @Cached PyObjectHashNode hashNode) {
            HashingStorage storage = self.getDictStorage();
            long m1 = 1927868237L;
            long m2 = 69069L;
            long c1 = 907133923L;
            long c2 = 590923713L;
            long hash = 0L;
            int len = 0;
            HashingStorageNodes.HashingStorageIterator it = getIter.execute(inliningTarget, storage);
            while (iterNext.execute(inliningTarget, storage, it)) {
                ++len;
                Object key = iterKey.execute(inliningTarget, storage, it);
                long tmp = hashNode.execute((Frame)frame, inliningTarget, key);
                hash ^= HashNode.shuffleBits(tmp);
            }
            hash ^= (long)(len + 1) * m1;
            hash ^= hash >> 11 ^ hash >> 25;
            if ((hash = hash * m2 + c1) == -1L) {
                hash = c2;
            }
            self.setHash(hash);
            return hash;
        }

        private static long shuffleBits(long value) {
            return (value ^ 0x55B4DB3L ^ value << 16) * -650169129L;
        }

        @Fallback
        static Object genericHash(Object self) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="union", minNumOfPositionalArgs=1, takesVarArgs=true)
    @GenerateNodeFactory
    static abstract class UnionNode
    extends PythonBuiltinNode {
        UnionNode() {
        }

        @Specialization(guards={"args.length == len", "args.length < 32"}, limit="3")
        static PBaseSet doCached(VirtualFrame frame, PBaseSet self, Object[] args, @Bind(value="this") Node inliningTarget, @Cached(value="args.length") int len, @Cached.Shared @Cached HashingCollectionNodes.GetSetStorageNode getHashingStorage, @Cached.Shared @Cached HashingStorageNodes.HashingStorageCopy copyNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOther, @Cached.Shared @Cached PythonObjectFactory factory) {
            HashingStorage result = copyNode.execute(inliningTarget, self.getDictStorage());
            for (int i = 0; i < len; ++i) {
                result = addAllToOther.execute((Frame)frame, inliningTarget, getHashingStorage.execute(frame, inliningTarget, args[i]), result);
            }
            return factory.createFrozenSet(result);
        }

        @Specialization(replaces={"doCached"})
        static PBaseSet doGeneric(VirtualFrame frame, PBaseSet self, Object[] args, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached HashingCollectionNodes.GetSetStorageNode getHashingStorage, @Cached.Shared @Cached HashingStorageNodes.HashingStorageCopy copyNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOther, @Cached.Shared @Cached PythonObjectFactory factory) {
            HashingStorage result = copyNode.execute(inliningTarget, self.getDictStorage());
            for (int i = 0; i < args.length; ++i) {
                result = addAllToOther.execute((Frame)frame, inliningTarget, getHashingStorage.execute(frame, inliningTarget, args[i]), result);
            }
            return factory.createFrozenSet(result);
        }
    }

    @Builtin(name="difference", minNumOfPositionalArgs=1, takesVarArgs=true)
    @GenerateNodeFactory
    public static abstract class DifferenceNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isNoValue(other)"})
        static PFrozenSet doSet(VirtualFrame frame, PFrozenSet self, PNone other, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createFrozenSet(self.getDictStorage());
        }

        @Specialization(guards={"args.length == len", "args.length < 32"}, limit="3")
        static PBaseSet doCached(VirtualFrame frame, PFrozenSet self, Object[] args, @Bind(value="this") Node inliningTarget, @Cached(value="args.length") int len, @Cached.Shared @Cached HashingCollectionNodes.GetSetStorageNode getSetStorageNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageCopy copyNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageDiff diffNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            HashingStorage result = copyNode.execute(inliningTarget, self.getDictStorage());
            for (int i = 0; i < len; ++i) {
                result = diffNode.execute((Frame)frame, inliningTarget, result, getSetStorageNode.execute(frame, inliningTarget, args[i]));
            }
            return factory.createFrozenSet(result);
        }

        @Specialization(replaces={"doCached"})
        static PBaseSet doGeneric(VirtualFrame frame, PFrozenSet self, Object[] args, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached HashingCollectionNodes.GetSetStorageNode getSetStorageNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageCopy copyNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageDiff diffNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            HashingStorage result = copyNode.execute(inliningTarget, self.getDictStorage());
            for (int i = 0; i < args.length; ++i) {
                result = diffNode.execute((Frame)frame, inliningTarget, result, getSetStorageNode.execute(frame, inliningTarget, args[i]));
            }
            return factory.createFrozenSet(result);
        }

        static boolean isOther(Object arg) {
            return !PGuards.isNoValue(arg) && !(arg instanceof Object[]);
        }

        @Specialization(guards={"isOther(other)"})
        static PFrozenSet doSet(VirtualFrame frame, PFrozenSet self, Object other, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached HashingCollectionNodes.GetSetStorageNode getSetStorageNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageDiff diffNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            HashingStorage result = diffNode.execute((Frame)frame, inliningTarget, self.getDictStorage(), getSetStorageNode.execute(frame, inliningTarget, other));
            return factory.createFrozenSet(result);
        }
    }

    @Builtin(name="symmetric_difference", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class SymmetricDifferenceNode
    extends PythonBuiltinNode {
        @Specialization
        static PFrozenSet doSet(VirtualFrame frame, PFrozenSet self, Object other, @Bind(value="this") Node inliningTarget, @Cached HashingCollectionNodes.GetSetStorageNode getHashingStorage, @Cached HashingStorageNodes.HashingStorageXor xorNode, @Cached PythonObjectFactory factory) {
            HashingStorage result = xorNode.execute((Frame)frame, inliningTarget, self.getDictStorage(), getHashingStorage.execute(frame, inliningTarget, other));
            return factory.createFrozenSet(result);
        }
    }

    @Builtin(name="intersection", minNumOfPositionalArgs=1, takesVarArgs=true)
    @GenerateNodeFactory
    public static abstract class IntersectNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isNoValue(other)"})
        static PFrozenSet doSet(VirtualFrame frame, PFrozenSet self, PNone other, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createFrozenSet(self.getDictStorage());
        }

        @Specialization(guards={"args.length == len", "args.length < 32"}, limit="3")
        static PBaseSet doCached(VirtualFrame frame, PFrozenSet self, Object[] args, @Bind(value="this") Node inliningTarget, @Cached(value="args.length") int len, @Cached.Shared @Cached HashingCollectionNodes.GetSetStorageNode getSetStorageNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageCopy copyNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageIntersect intersectNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            HashingStorage result = copyNode.execute(inliningTarget, self.getDictStorage());
            for (int i = 0; i < len; ++i) {
                result = intersectNode.execute((Frame)frame, inliningTarget, result, getSetStorageNode.execute(frame, inliningTarget, args[i]));
            }
            return factory.createFrozenSet(result);
        }

        @Specialization(replaces={"doCached"})
        static PBaseSet doGeneric(VirtualFrame frame, PFrozenSet self, Object[] args, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached HashingCollectionNodes.GetSetStorageNode getSetStorageNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageCopy copyNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageIntersect intersectNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            HashingStorage result = copyNode.execute(inliningTarget, self.getDictStorage());
            for (int i = 0; i < args.length; ++i) {
                result = intersectNode.execute((Frame)frame, inliningTarget, result, getSetStorageNode.execute(frame, inliningTarget, args[i]));
            }
            return factory.createFrozenSet(result);
        }

        static boolean isOther(Object arg) {
            return !PGuards.isNoValue(arg) && !(arg instanceof Object[]);
        }

        @Specialization(guards={"isOther(other)"})
        static PFrozenSet doSet(VirtualFrame frame, PFrozenSet self, Object other, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached HashingCollectionNodes.GetSetStorageNode getSetStorageNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageIntersect intersectNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            HashingStorage result = intersectNode.execute((Frame)frame, inliningTarget, self.getDictStorage(), getSetStorageNode.execute(frame, inliningTarget, other));
            return factory.createFrozenSet(result);
        }
    }

    @Builtin(name="copy", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class CopyNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static PFrozenSet subFrozensetIdentity(PFrozenSet arg, @Bind(value="this") Node inliningTarget, @Cached BuiltinClassProfiles.IsAnyBuiltinObjectProfile isBuiltinClass, @Cached PythonObjectFactory.Lazy factory) {
            if (isBuiltinClass.profileIsAnyBuiltinObject(inliningTarget, arg)) {
                return arg;
            }
            return factory.get(inliningTarget).createFrozenSet(arg.getDictStorage());
        }
    }
}

