/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.sequence.storage;

import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStoreException;
import com.oracle.graal.python.runtime.sequence.storage.TypedSequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import java.math.BigInteger;
import java.util.Arrays;

public final class LongSequenceStorage
extends TypedSequenceStorage {
    private long[] values;

    public LongSequenceStorage() {
        this.values = new long[0];
    }

    public LongSequenceStorage(long[] elements) {
        this.values = elements;
        this.capacity = this.values.length;
        this.length = elements.length;
    }

    public LongSequenceStorage(long[] elements, int length) {
        this.values = elements;
        this.capacity = this.values.length;
        this.length = length;
    }

    public LongSequenceStorage(int capacity) {
        this.values = new long[capacity];
        this.capacity = capacity;
        this.length = 0;
    }

    @Override
    protected void increaseCapacityExactWithCopy(int newCapacity) {
        this.values = Arrays.copyOf(this.values, newCapacity);
        this.capacity = this.values.length;
    }

    @Override
    protected void increaseCapacityExact(int newCapacity) {
        this.values = new long[newCapacity];
        this.capacity = this.values.length;
    }

    @Override
    public SequenceStorage copy() {
        return new LongSequenceStorage(PythonUtils.arrayCopyOf(this.values, this.length));
    }

    @Override
    public SequenceStorage createEmpty(int newCapacity) {
        return new LongSequenceStorage(newCapacity);
    }

    @Override
    public Object[] getInternalArray() {
        Object[] boxed = new Object[this.length];
        for (int i = 0; i < this.length; ++i) {
            boxed[i] = this.values[i];
        }
        return boxed;
    }

    public long[] getInternalLongArray() {
        return this.values;
    }

    @Override
    public Object getItemNormalized(int idx) {
        return this.getLongItemNormalized(idx);
    }

    public long getLongItemNormalized(int idx) {
        return this.values[idx];
    }

    @Override
    public void setItemNormalized(int idx, Object val) throws SequenceStoreException {
        Object value = val instanceof Integer ? Long.valueOf(BigInteger.valueOf(((Integer)val).intValue()).longValue()) : val;
        Object object = value = val instanceof BigInteger ? Long.valueOf(((BigInteger)val).longValue()) : value;
        if (!(value instanceof Long)) {
            throw new SequenceStoreException(value);
        }
        this.setLongItemNormalized(idx, (Long)value);
    }

    public void setLongItemNormalized(int idx, long value) {
        this.values[idx] = value;
    }

    @Override
    public void insertItem(int idx, Object val) throws SequenceStoreException {
        long value;
        if (val instanceof Integer) {
            value = ((Integer)val).intValue();
        } else if (val instanceof BigInteger) {
            value = PInt.longValue((BigInteger)val);
        } else if (val instanceof Long) {
            value = (Long)val;
        } else {
            throw new SequenceStoreException(val);
        }
        this.insertLongItem(idx, value);
    }

    public void insertLongItem(int idx, long value) {
        this.ensureCapacity(this.length + 1);
        for (int i = this.values.length - 1; i > idx; --i) {
            this.values[i] = this.values[i - 1];
        }
        this.values[idx] = value;
        this.incLength();
    }

    @Override
    public void copyItem(int idxTo, int idxFrom) {
        this.values[idxTo] = this.values[idxFrom];
    }

    @Override
    public LongSequenceStorage getSliceInBound(int start, int stop, int step, int sliceLength) {
        long[] newArray = new long[sliceLength];
        if (step == 1) {
            PythonUtils.arraycopy(this.values, start, newArray, 0, sliceLength);
            return new LongSequenceStorage(newArray);
        }
        int i = start;
        for (int j = 0; j < sliceLength; ++j) {
            newArray[j] = this.values[i];
            i += step;
        }
        return new LongSequenceStorage(newArray);
    }

    public int indexOfLong(long value) {
        for (int i = 0; i < this.length; ++i) {
            if (this.values[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void reverse() {
        if (this.length > 0) {
            int head = 0;
            int tail = this.length - 1;
            int middle = (this.length - 1) / 2;
            while (head <= middle) {
                long temp = this.values[head];
                this.values[head] = this.values[tail];
                this.values[tail] = temp;
                ++head;
                --tail;
            }
        }
    }

    @Override
    public Object getIndicativeValue() {
        return 0;
    }

    @Override
    public boolean equals(SequenceStorage other) {
        if (other.length() != this.length() || !(other instanceof LongSequenceStorage)) {
            return false;
        }
        long[] otherArray = ((LongSequenceStorage)other).getInternalLongArray();
        for (int i = 0; i < this.length(); ++i) {
            if (this.values[i] == otherArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object getInternalArrayObject() {
        return this.values;
    }

    @Override
    public Object getCopyOfInternalArrayObject() {
        return Arrays.copyOf(this.values, this.length);
    }

    @Override
    public Object[] getCopyOfInternalArray() {
        return this.getInternalArray();
    }

    @Override
    public void setInternalArrayObject(Object arrayObject) {
        this.values = (long[])arrayObject;
    }

    @Override
    public SequenceStorage.ListStorageType getElementType() {
        return SequenceStorage.ListStorageType.Long;
    }
}

