/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.formatting;

import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins;
import com.oracle.graal.python.lib.PyFloatAsDoubleNode;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.attributes.LookupAttributeInMRONode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNodeGen;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaLongLossyNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.formatting.FloatFormatter;
import com.oracle.graal.python.runtime.formatting.FormattingBuffer;
import com.oracle.graal.python.runtime.formatting.IntegerFormatter;
import com.oracle.graal.python.runtime.formatting.InternalFormat;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.strings.TruffleString;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;

abstract class FormatProcessor<T> {
    private int argIndex = -1;
    private Object args;
    private final TupleBuiltins.GetItemNode getTupleItemNode;
    protected int index;
    protected final Python3Core core;
    protected final PRaiseNode raiseNode;
    protected final FormattingBuffer buffer;

    public FormatProcessor(Python3Core core, PRaiseNode raiseNode, TupleBuiltins.GetItemNode getTupleItemNode, FormattingBuffer buffer) {
        this.core = core;
        this.raiseNode = raiseNode;
        this.getTupleItemNode = getTupleItemNode;
        this.buffer = buffer;
        this.index = 0;
    }

    protected abstract String getFormatType();

    abstract char pop();

    final void push() {
        --this.index;
    }

    abstract boolean hasNext();

    <F extends InternalFormat.Formatter> F setupFormat(F f) {
        return f;
    }

    abstract int parseNumber(int var1, int var2);

    abstract Object parseMappingKey(int var1, int var2);

    protected abstract boolean isMapping(Object var1);

    static Object lookupAttribute(Object owner, TruffleString name) {
        return LookupAttributeInMRONode.Dynamic.getUncached().execute(GetClassNode.executeUncached(owner), name);
    }

    static Object call(Object callable, Object ... args) {
        return CallNode.getUncached().execute((Frame)null, callable, args, PKeyword.EMPTY_KEYWORDS);
    }

    Object getItem(Object arg, Object arg2) {
        return PyObjectGetItem.executeUncached(arg, arg2);
    }

    Object getArg() {
        Object ret = null;
        switch (this.argIndex) {
            case -3: {
                return this.args;
            }
            case -2: {
                break;
            }
            case -1: {
                this.argIndex = -2;
                return this.args;
            }
            default: {
                try {
                    ret = this.getTupleItemNode.execute(null, this.args, (Object)this.argIndex++);
                    break;
                }
                catch (PException pException) {
                    // empty catch block
                }
            }
        }
        if (ret == null) {
            throw this.raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.NOT_ENOUGH_ARGS_FOR_FORMAT_STRING);
        }
        return ret;
    }

    int getNumber() {
        char c = this.pop();
        if (c == '*') {
            Object o = this.getArg();
            try {
                long value = CastToJavaLongLossyNode.executeUncached(o);
                if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
                    throw this.raiseNode.raise(PythonErrorType.OverflowError, ErrorMessages.PYTHON_INT_TOO_LARGE_TO_CONV_TO, "size");
                }
                return (int)value;
            }
            catch (CannotCastException e) {
                throw this.raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.STAR_WANTS_INT);
            }
        }
        if (Character.isDigit(c)) {
            int numStart = this.index - 1;
            while (Character.isDigit(c = this.pop())) {
            }
            --this.index;
            try {
                return this.parseNumber(numStart, this.index);
            }
            catch (NumberFormatException e) {
                throw this.raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.TOO_MANY_DECIMAL_DIGITS_IN_FORMAT_STRING);
            }
        }
        --this.index;
        return 0;
    }

    private static boolean allowsFloat(char specType) {
        return specType != 'x' && specType != 'X' && specType != 'o' && specType != 'c';
    }

    private static boolean useIndexMagicMethod(char specType) {
        return specType == 'x' || specType == 'X' || specType == 'o' || specType == 'c';
    }

    protected final Object asNumber(Object arg, char specType) {
        if (arg instanceof Integer || arg instanceof Long || arg instanceof PInt) {
            return arg;
        }
        if (arg instanceof Double) {
            if (FormatProcessor.allowsFloat(specType)) {
                BigDecimal decimal = new BigDecimal((Double)arg, MathContext.UNLIMITED);
                return this.core.factory().createInt(decimal.toBigInteger());
            }
            return arg;
        }
        if (arg instanceof Boolean) {
            return (Boolean)arg != false ? 1 : 0;
        }
        if (arg instanceof PythonAbstractObject) {
            try {
                TruffleString magicName = FormatProcessor.useIndexMagicMethod(specType) ? SpecialMethodNames.T___INDEX__ : SpecialMethodNames.T___INT__;
                Object attribute = FormatProcessor.lookupAttribute(arg, magicName);
                return FormatProcessor.call(attribute, arg);
            }
            catch (PException pException) {
                // empty catch block
            }
        }
        return arg;
    }

    protected double asFloat(Object arg) {
        return PyFloatAsDoubleNode.executeUncached(arg);
    }

    protected abstract InternalFormat.Formatter handleRemainingFormats(InternalFormat.Spec var1);

    protected abstract InternalFormat.Formatter handleSingleCharacterFormat(InternalFormat.Spec var1);

    protected InternalFormat.Formatter formatInteger(Object intObj, InternalFormat.Spec spec) {
        IntegerFormatter.Traditional fi;
        if (intObj instanceof Integer) {
            fi = this.setupFormat(new IntegerFormatter.Traditional(this.raiseNode, this.buffer, spec));
            fi.format((Integer)intObj);
        } else if (intObj instanceof Long) {
            fi = this.setupFormat(new IntegerFormatter.Traditional(this.raiseNode, this.buffer, spec));
            fi.format(BigInteger.valueOf((Long)intObj));
        } else if (intObj instanceof PInt) {
            fi = this.setupFormat(new IntegerFormatter.Traditional(this.raiseNode, this.buffer, spec));
            fi.format(((PInt)intObj).getValue());
        } else {
            return null;
        }
        return fi;
    }

    protected static boolean isString(Object args1, Object lazyClass) {
        return PGuards.isString(args1) || FormatProcessor.isSubtype(lazyClass, PythonBuiltinClassType.PString);
    }

    protected static boolean isSubtype(Object lazyClass, PythonBuiltinClassType clazz) {
        return IsSubtypeNodeGen.getUncached().execute(lazyClass, (Object)clazz);
    }

    @CompilerDirectives.TruffleBoundary
    public T format(Object args1) {
        try {
            return this.formatImpl(args1);
        }
        catch (OutOfMemoryError e) {
            throw this.raiseNode.raise(PythonErrorType.MemoryError);
        }
    }

    private T formatImpl(Object args1) {
        boolean tupleArgs;
        Object mapping = null;
        this.args = args1;
        Object args1LazyClass = GetClassNode.executeUncached(args1);
        boolean bl = tupleArgs = PGuards.isPTuple(args1) || FormatProcessor.isSubtype(args1LazyClass, PythonBuiltinClassType.PTuple);
        if (tupleArgs) {
            this.argIndex = 0;
        } else if (this.isMapping(args1)) {
            mapping = args1;
            this.argIndex = -3;
        }
        while (this.hasNext()) {
            InternalFormat.Formatter f;
            char c = this.pop();
            if (c != '%') {
                this.buffer.append(c);
                continue;
            }
            boolean altFlag = false;
            char sign = '\uffff';
            char fill = ' ';
            char align = '>';
            int width = -1;
            int precision = -1;
            c = this.pop();
            if (c == '%') {
                this.buffer.append(c);
                continue;
            }
            if (c == '(') {
                if (mapping == null) {
                    throw this.raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.FORMAT_REQUIRES_MAPPING);
                }
                int parens = 1;
                int keyStart = this.index;
                while (parens > 0) {
                    c = this.pop();
                    if (c == ')') {
                        --parens;
                        continue;
                    }
                    if (c != '(') continue;
                    ++parens;
                }
                Object tmp = this.parseMappingKey(keyStart, this.index - 1);
                this.args = this.getItem(mapping, tmp);
            } else {
                this.push();
            }
            block17: while (true) {
                switch (this.pop()) {
                    case '-': {
                        align = '<';
                        continue block17;
                    }
                    case '+': {
                        sign = '+';
                        continue block17;
                    }
                    case ' ': {
                        if (InternalFormat.Spec.specified(sign)) continue block17;
                        sign = ' ';
                        continue block17;
                    }
                    case '#': {
                        altFlag = true;
                        continue block17;
                    }
                    case '0': {
                        fill = '0';
                        continue block17;
                    }
                }
                break;
            }
            this.push();
            width = this.getNumber();
            if (width < 0) {
                width = -width;
                align = '<';
            }
            if ((c = this.pop()) == '.') {
                precision = this.getNumber();
                if (precision < -1) {
                    precision = 0;
                }
                c = this.pop();
            }
            if (c == 'h' || c == 'l' || c == 'L') {
                c = this.pop();
            }
            switch (c) {
                case '%': 
                case 'c': 
                case 'r': 
                case 's': {
                    fill = ' ';
                    break;
                }
                default: {
                    if (fill == '0' && align == '>') {
                        align = '=';
                        break;
                    }
                    fill = ' ';
                }
            }
            InternalFormat.Spec spec = new InternalFormat.Spec(fill, align, sign, altFlag, width, '\uffff', precision, c);
            switch (spec.type) {
                case 'c': {
                    f = this.handleSingleCharacterFormat(spec);
                    break;
                }
                case 'X': 
                case 'd': 
                case 'i': 
                case 'o': 
                case 'u': 
                case 'x': {
                    Object arg = this.getArg();
                    f = this.formatInteger(this.asNumber(arg, spec.type), spec);
                    if (f != null) break;
                    if (FormatProcessor.allowsFloat(spec.type)) {
                        throw this.raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.S_FORMAT_NUMBER_IS_REQUIRED_NOT_S, Character.valueOf(spec.type), arg);
                    }
                    throw this.raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.S_FORMAT_INTEGER_IS_REQUIRED_NOT_S, Character.valueOf(spec.type), arg);
                }
                case 'E': 
                case 'F': 
                case 'G': 
                case 'e': 
                case 'f': 
                case 'g': {
                    FloatFormatter ff = new FloatFormatter(this.raiseNode, this.buffer, spec);
                    f = ff;
                    Object arg = this.getArg();
                    ff.format(this.asFloat(arg));
                    break;
                }
                default: {
                    f = this.handleRemainingFormats(spec);
                    if (f != null) break;
                    throw this.raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.UNSUPPORTED_FORMAT_CHAR_AT_INDEX, Character.valueOf(spec.type), spec.type, this.index - 1);
                }
            }
            f.pad();
        }
        if (this.argIndex == -1 || this.argIndex >= 0 && PyObjectSizeNode.executeUncached(args1) >= this.argIndex + 1) {
            throw this.raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.NOT_ALL_ARGS_CONVERTED_DURING_FORMATTING, this.getFormatType());
        }
        return this.toResult();
    }

    private T toResult() {
        return (T)this.buffer.toResult();
    }
}

