/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.runtime.NativeLibraryFactory;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedExactClassProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.nfi.api.SignatureLibrary;
import java.util.Objects;
import java.util.logging.Level;

public class NativeLibrary {
    private static final TruffleLogger LOGGER = PythonLanguage.getLogger(NativeLibrary.class);
    private final int functionsCount;
    private final String name;
    private final NFIBackend nfiBackend;
    private final String noNativeAccessHelp;
    private final boolean optional;
    private volatile Object[] cachedFunctions;
    private volatile Object cachedLibrary;
    private volatile InteropLibrary cachedLibraryInterop;
    private volatile Object dummy;

    public NativeLibrary(String name, int functionsCount, NFIBackend nfiBackend, String noNativeAccessHelp, boolean optional) {
        this.functionsCount = functionsCount;
        this.name = name;
        this.nfiBackend = nfiBackend;
        this.noNativeAccessHelp = noNativeAccessHelp;
        this.optional = optional;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getCachedLibrary(PythonContext context) {
        if (this.cachedLibrary == null) {
            CompilerDirectives.transferToInterpreter();
            NativeLibrary nativeLibrary = this;
            synchronized (nativeLibrary) {
                Object lib;
                if (this.cachedLibrary == null && (lib = this.loadLibrary(context)) != null) {
                    this.cachedLibraryInterop = InteropLibrary.getUncached((Object)lib);
                    this.cachedLibrary = lib;
                }
            }
        }
        return this.cachedLibrary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getCachedFunction(PythonContext context, NativeFunction function) {
        int functionIndex;
        Object lib = this.getCachedLibrary(context);
        if (this.cachedFunctions == null) {
            CompilerDirectives.transferToInterpreter();
            NativeLibrary nativeLibrary = this;
            synchronized (nativeLibrary) {
                if (this.cachedFunctions == null) {
                    this.cachedFunctions = new Object[this.functionsCount];
                }
            }
        }
        if (this.cachedFunctions[functionIndex = function.ordinal()] == null) {
            CompilerDirectives.transferToInterpreter();
            NativeLibrary nativeLibrary = this;
            synchronized (nativeLibrary) {
                this.cachedFunctions[functionIndex] = this.dummy = this.getFunction(context, lib, function);
            }
        }
        return this.cachedFunctions[functionIndex];
    }

    private Object getFunction(PythonContext context, NativeFunction function) {
        CompilerAsserts.neverPartOfCompilation();
        Object lib = this.getCachedLibrary(context);
        return this.getFunction(context, lib, function);
    }

    private Object parseSignature(PythonContext context, String signature) {
        Source sigSource = Source.newBuilder((String)"nfi", (CharSequence)(this.nfiBackend.withClause + signature), (String)"python-nfi-signature").build();
        return context.getEnv().parseInternal(sigSource, new String[0]).call(new Object[0]);
    }

    private Object getFunction(PythonContext context, Object lib, NativeFunction function) {
        CompilerAsserts.neverPartOfCompilation();
        try {
            Object signature = this.parseSignature(context, function.signature());
            Object symbol = this.cachedLibraryInterop.readMember(lib, function.name());
            return SignatureLibrary.getUncached().bind(signature, symbol);
        }
        catch (UnknownIdentifierException | UnsupportedMessageException e) {
            throw new IllegalStateException(String.format("Cannot load symbol '%s' from the internal shared library '%s'", function.name(), this.name), e);
        }
    }

    private Object loadLibrary(PythonContext context) {
        CompilerAsserts.neverPartOfCompilation();
        if (context.isNativeAccessAllowed()) {
            String path = NativeLibrary.getLibPath(context, this.name);
            String src = String.format("%sload (RTLD_LOCAL) \"%s\"", this.nfiBackend.withClause, path);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("Loading native library %s from path %s %s", this.name, path, this.nfiBackend.withClause));
            }
            Source loadSrc = Source.newBuilder((String)"nfi", (CharSequence)src, (String)("load:" + this.name)).internal(true).build();
            try {
                return context.getEnv().parseInternal(loadSrc, new String[0]).call(new Object[0]);
            }
            catch (RuntimeException ex) {
                Level level;
                Level level2 = level = this.optional ? Level.FINE : Level.SEVERE;
                if (LOGGER.isLoggable(level)) {
                    LOGGER.log(level, (Throwable)ex, () -> String.format("Error while opening shared library at '%s'.\nFull NFI source: %s.", path, src));
                }
                if (!this.optional) {
                    throw new RuntimeException(String.format("Cannot load supporting native library '%s'. Either the shared library file does not exist, or your system may be missing some dependencies. Turn on logging with --log.%s.level=INFO for more details. %s", this.name, NativeLibrary.class.getName(), this.noNativeAccessHelp));
                }
            }
        } else {
            throw new RuntimeException(String.format("Cannot load supporting native library '%s' because the native access is not allowed. The native access should be allowed when running GraalPython via the graalpython command. If you are embedding GraalPython using the Context API, make sure to allow native access using 'allowNativeAccess(true)'. %s", this.name, this.noNativeAccessHelp));
        }
        throw NativeLibraryCannotBeLoaded.INSTANCE;
    }

    private static String getLibPath(PythonContext context, String name) {
        CompilerAsserts.neverPartOfCompilation();
        TruffleFile homePath = context.getEnv().getInternalTruffleFile(context.getCAPIHome().toJavaStringUncached());
        TruffleFile file = homePath.resolve(name);
        return file.getPath();
    }

    protected Object callUncached(PythonContext context, NativeFunction f, Object ... args) {
        CompilerAsserts.neverPartOfCompilation();
        Object lib = this.getCachedLibrary(context);
        if (lib != null) {
            try {
                Object signature = this.parseSignature(context, f.signature());
                Object symbol = this.cachedLibraryInterop.readMember(lib, f.name());
                return SignatureLibrary.getUncached().call(signature, symbol, args);
            }
            catch (Exception e) {
                throw CompilerDirectives.shouldNotReachHere((String)f.name(), (Throwable)e);
            }
        }
        return null;
    }

    public static <T extends Enum<T>> TypedNativeLibrary<T> create(String name, T[] functions, String noNativeAccessHelp, boolean canIgnore) {
        return NativeLibrary.create((String)name, functions, (NFIBackend)NFIBackend.NATIVE, (String)noNativeAccessHelp, (boolean)canIgnore);
    }

    public static <T extends Enum<T>> TypedNativeLibrary<T> create(String name, T[] functions, NFIBackend nfiBackendName, String noNativeAccessHelp, boolean canIgnore) {
        return new TypedNativeLibrary(name, functions.length, nfiBackendName, noNativeAccessHelp, canIgnore);
    }

    static enum NFIBackend {
        NATIVE(""),
        LLVM("with llvm ");

        private final String withClause;

        private NFIBackend(String withClause) {
            this.withClause = withClause;
        }
    }

    static interface NativeFunction {
        public String signature();

        public String name();

        public int ordinal();
    }

    public static final class NativeLibraryCannotBeLoaded
    extends RuntimeException {
        private static final NativeLibraryCannotBeLoaded INSTANCE = new NativeLibraryCannotBeLoaded();
        private static final long serialVersionUID = 6066722947025284374L;

        private NativeLibraryCannotBeLoaded() {
            super(null, null);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    public static final class TypedNativeLibrary<T extends Enum<T>>
    extends NativeLibrary {
        public TypedNativeLibrary(String name, int functionsCount, NFIBackend nfiBackendName, String noNativeAccessHelp, boolean canIgnore) {
            super(name, functionsCount, nfiBackendName, noNativeAccessHelp, canIgnore);
        }
    }

    public static abstract class InvokeNativeFunction
    extends PNodeWithContext {
        private static final InvokeNativeFunction UNCACHED = NativeLibraryFactory.InvokeNativeFunctionNodeGen.create(InteropLibrary.getUncached());
        @Node.Child
        private InteropLibrary resultInterop;
        @Node.Child
        private TruffleString.SwitchEncodingNode switchEncodingNode;

        public InvokeNativeFunction(InteropLibrary resultInterop) {
            this.resultInterop = resultInterop;
        }

        @NeverDefault
        public static InvokeNativeFunction create() {
            return NativeLibraryFactory.InvokeNativeFunctionNodeGen.create(null);
        }

        public static InvokeNativeFunction getUncached() {
            return UNCACHED;
        }

        public <T extends Enum<T>> Object call(TypedNativeLibrary<T> lib, T function, Object ... args) {
            return this.execute(lib, (NativeFunction)((Object)function), args);
        }

        public <T extends Enum<T>> long callLong(TypedNativeLibrary<T> lib, T function, Object ... args) {
            try {
                return this.ensureResultInterop().asLong(this.call(lib, function, args));
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((String)function.name(), (Throwable)e);
            }
        }

        public <T extends Enum<T>> int callInt(TypedNativeLibrary<T> lib, T function, Object ... args) {
            try {
                return this.ensureResultInterop().asInt(this.call(lib, function, args));
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((String)function.name(), (Throwable)e);
            }
        }

        public <T extends Enum<T>> TruffleString callString(TypedNativeLibrary<T> lib, T function, Object ... args) {
            try {
                return this.ensureSwitchEncoding().execute((AbstractTruffleString)this.ensureResultInterop().asTruffleString(this.call(lib, function, args)), PythonUtils.TS_ENCODING);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((String)function.name(), (Throwable)e);
            }
        }

        protected abstract Object execute(NativeLibrary var1, NativeFunction var2, Object[] var3);

        @Specialization(guards={"isSingleContext()", "function == cachedFunction", "lib == cachedLib"}, limit="3")
        static Object doSingleContext(NativeLibrary lib, NativeFunction function, Object[] args, @Cached(value="lib", weak=true) NativeLibrary cachedLib, @Cached(value="function") NativeFunction cachedFunction, @Cached(value="getFunction(lib, function)", weak=true) Object funObj, @CachedLibrary(value="funObj") InteropLibrary funInterop) {
            return InvokeNativeFunction.invoke(cachedFunction, args, funObj, funInterop);
        }

        @Specialization(replaces={"doSingleContext"})
        static Object doMultiContext(NativeLibrary lib, NativeFunction functionIn, Object[] args, @Bind(value="this") Node inliningTarget, @Cached InlinedExactClassProfile functionClassProfile, @CachedLibrary(limit="1") InteropLibrary funInterop) {
            NativeFunction function = (NativeFunction)functionClassProfile.profile(inliningTarget, (Object)functionIn);
            Object funObj = lib.getCachedFunction(PythonContext.get((Node)funInterop), function);
            return InvokeNativeFunction.invoke(function, args, funObj, funInterop);
        }

        private static Object invoke(NativeFunction function, Object[] args, Object funObj, InteropLibrary funInterop) {
            try {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest(InvokeNativeFunction.buildLogMessage(function, args));
                }
                Object result = funInterop.execute(funObj, args);
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest(InvokeNativeFunction.buildReturnLogMessage(function, result));
                }
                return result;
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw CompilerDirectives.shouldNotReachHere((String)function.name(), (Throwable)e);
            }
        }

        protected Object getFunction(NativeLibrary lib, NativeFunction fun) {
            return lib.getFunction(PythonContext.get(this), fun);
        }

        @CompilerDirectives.TruffleBoundary
        private static String buildLogMessage(NativeFunction function, Object[] args) {
            StringBuilder sb = new StringBuilder("Executing native function ");
            sb.append(function.name()).append(" with arguments: ");
            for (Object arg : args) {
                sb.append(InvokeNativeFunction.safeToString(arg)).append(',');
            }
            return sb.toString();
        }

        @CompilerDirectives.TruffleBoundary
        private static String buildReturnLogMessage(NativeFunction function, Object result) {
            return "Finished executing native function " + function.name() + " with result: " + InvokeNativeFunction.safeToString(result);
        }

        private static String safeToString(Object value) {
            try {
                return Objects.toString(value);
            }
            catch (Exception ex) {
                return String.format("%s (toString threw %s),", value.getClass().getSimpleName(), ex.getClass().getSimpleName());
            }
        }

        public InteropLibrary ensureResultInterop() {
            if (this.resultInterop == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.resultInterop = (InteropLibrary)this.insert((Node)((InteropLibrary)InteropLibrary.getFactory().createDispatched(3)));
            }
            return this.resultInterop;
        }

        public TruffleString.SwitchEncodingNode ensureSwitchEncoding() {
            if (this.switchEncodingNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.switchEncodingNode = (TruffleString.SwitchEncodingNode)this.insert((Node)TruffleString.SwitchEncodingNode.create());
            }
            return this.switchEncodingNode;
        }
    }
}

