/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime;

import com.oracle.graal.python.runtime.PosixSupport;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.HashSet;
import java.util.IdentityHashMap;
import org.graalvm.nativeimage.ImageInfo;

@ExportLibrary(value=PosixSupportLibrary.class)
public class ImageBuildtimePosixSupport
extends PosixSupport {
    protected final PosixSupport nativePosixSupport;
    private PosixSupport emulatedPosixSupport;
    private HashSet<Integer> emulatedFds;
    private IdentityHashMap<Object, Object> emulatedDirStreams;

    public ImageBuildtimePosixSupport(PosixSupport nativePosixSupport, PosixSupport emulatedPosixSupport) {
        this.nativePosixSupport = nativePosixSupport;
        this.emulatedPosixSupport = emulatedPosixSupport;
        if (emulatedPosixSupport != null) {
            this.emulatedFds = new HashSet();
            this.emulatedDirStreams = new IdentityHashMap();
        }
    }

    @Override
    public void setEnv(TruffleLanguage.Env env) {
        assert (!ImageInfo.inImageBuildtimeCode());
        this.nativePosixSupport.setEnv(env);
    }

    public void checkLeakingResources() {
        assert (ImageInfo.inImageBuildtimeCode());
        if (!this.emulatedFds.isEmpty()) {
            throw CompilerDirectives.shouldNotReachHere((String)"Emulated fds leaked into the image");
        }
        if (!this.emulatedDirStreams.isEmpty()) {
            throw CompilerDirectives.shouldNotReachHere((String)"Emulated dirStreams leaked into the image");
        }
        this.emulatedPosixSupport = null;
        this.emulatedFds = null;
        this.emulatedDirStreams = null;
    }

    private static void checkNotInImageBuildtime() {
        if (ImageInfo.inImageBuildtimeCode()) {
            throw CompilerDirectives.shouldNotReachHere((String)"Posix call not expected during image buildtime");
        }
    }

    @CompilerDirectives.TruffleBoundary
    private int addFd(int fd) {
        if (this.emulatedFds.contains(fd)) {
            throw CompilerDirectives.shouldNotReachHere((String)"duplicate fd");
        }
        this.emulatedFds.add(fd);
        return fd;
    }

    @CompilerDirectives.TruffleBoundary
    private int removeFd(int fd) {
        if (!this.emulatedFds.contains(fd)) {
            throw CompilerDirectives.shouldNotReachHere((String)"Closing fd that has not been open");
        }
        this.emulatedFds.remove(fd);
        return fd;
    }

    @CompilerDirectives.TruffleBoundary
    private Object addDirStream(Object dirStream) {
        if (this.emulatedDirStreams.containsKey(dirStream)) {
            throw CompilerDirectives.shouldNotReachHere((String)"Duplicate dirStream");
        }
        this.emulatedDirStreams.put(dirStream, dirStream);
        return dirStream;
    }

    @CompilerDirectives.TruffleBoundary
    private Object removeDirStream(Object dirStream) {
        if (!this.emulatedDirStreams.containsKey(dirStream)) {
            throw CompilerDirectives.shouldNotReachHere((String)"Closing dirStream that has not been open");
        }
        this.emulatedDirStreams.remove(dirStream);
        return dirStream;
    }

    @ExportMessage
    final TruffleString getBackend(@CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.getBackend(this.nativePosixSupport);
    }

    @ExportMessage
    final TruffleString strerror(int errorCode, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.strerror(this.nativePosixSupport, errorCode);
    }

    @ExportMessage
    final long getpid(@CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.getpid(this.nativePosixSupport);
    }

    @ExportMessage
    final int umask(int mask, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.umask(this.nativePosixSupport, mask);
    }

    @ExportMessage
    final int openat(int dirFd, Object pathname, int flags, int mode, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        if (ImageInfo.inImageBuildtimeCode()) {
            return this.addFd(PosixSupportLibrary.getUncached().openat(this.emulatedPosixSupport, dirFd, pathname, flags, mode));
        }
        return nativeLib.openat(this.nativePosixSupport, dirFd, pathname, flags, mode);
    }

    @ExportMessage
    final int close(int fd, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        if (ImageInfo.inImageBuildtimeCode()) {
            return PosixSupportLibrary.getUncached().close(this.emulatedPosixSupport, this.removeFd(fd));
        }
        return nativeLib.close(this.nativePosixSupport, fd);
    }

    @ExportMessage
    final PosixSupportLibrary.Buffer read(int fd, long length, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        if (ImageInfo.inImageBuildtimeCode()) {
            return PosixSupportLibrary.getUncached().read(this.emulatedPosixSupport, fd, length);
        }
        return nativeLib.read(this.nativePosixSupport, fd, length);
    }

    @ExportMessage
    final long write(int fd, PosixSupportLibrary.Buffer data, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.write(this.nativePosixSupport, fd, data);
    }

    @ExportMessage
    final int dup(int fd, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.dup(this.nativePosixSupport, fd);
    }

    @ExportMessage
    final int dup2(int fd, int fd2, boolean inheritable, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.dup2(this.nativePosixSupport, fd, fd2, inheritable);
    }

    @ExportMessage
    final boolean getInheritable(int fd, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.getInheritable(this.nativePosixSupport, fd);
    }

    @ExportMessage
    final void setInheritable(int fd, boolean inheritable, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        if (ImageInfo.inImageBuildtimeCode()) {
            PosixSupportLibrary.getUncached().setInheritable(this.emulatedPosixSupport, fd, inheritable);
            return;
        }
        nativeLib.setInheritable(this.nativePosixSupport, fd, inheritable);
    }

    @ExportMessage
    final int[] pipe(@CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.pipe(this.nativePosixSupport);
    }

    @ExportMessage
    final PosixSupportLibrary.SelectResult select(int[] readfds, int[] writefds, int[] errorfds, PosixSupportLibrary.Timeval timeout, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.select(this.nativePosixSupport, readfds, writefds, errorfds, timeout);
    }

    @ExportMessage
    final long lseek(int fd, long offset, int how, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        if (ImageInfo.inImageBuildtimeCode()) {
            return PosixSupportLibrary.getUncached().lseek(this.emulatedPosixSupport, fd, offset, how);
        }
        return nativeLib.lseek(this.nativePosixSupport, fd, offset, how);
    }

    @ExportMessage
    final void ftruncate(int fd, long length, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        nativeLib.ftruncate(this.nativePosixSupport, fd, length);
    }

    @ExportMessage
    final void fsync(int fd, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        nativeLib.fsync(this.nativePosixSupport, fd);
    }

    @ExportMessage
    final void flock(int fd, int operation, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        nativeLib.flock(this.nativePosixSupport, fd, operation);
    }

    @ExportMessage
    final boolean getBlocking(int fd, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.getBlocking(this.nativePosixSupport, fd);
    }

    @ExportMessage
    final void setBlocking(int fd, boolean blocking, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        nativeLib.setBlocking(this.nativePosixSupport, fd, blocking);
    }

    @ExportMessage
    final int[] getTerminalSize(int fd, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.getTerminalSize(this.nativePosixSupport, fd);
    }

    @ExportMessage
    final long[] fstatat(int dirFd, Object pathname, boolean followSymlinks, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        if (ImageInfo.inImageBuildtimeCode()) {
            return PosixSupportLibrary.getUncached().fstatat(this.emulatedPosixSupport, dirFd, pathname, followSymlinks);
        }
        return nativeLib.fstatat(this.nativePosixSupport, dirFd, pathname, followSymlinks);
    }

    @ExportMessage
    final long[] fstat(int fd, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        if (ImageInfo.inImageBuildtimeCode()) {
            return PosixSupportLibrary.getUncached().fstat(this.emulatedPosixSupport, fd);
        }
        return nativeLib.fstat(this.nativePosixSupport, fd);
    }

    @ExportMessage
    final long[] statvfs(Object path, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        if (ImageInfo.inImageBuildtimeCode()) {
            return PosixSupportLibrary.getUncached().statvfs(this.emulatedPosixSupport, path);
        }
        return nativeLib.statvfs(this.nativePosixSupport, path);
    }

    @ExportMessage
    final long[] fstatvfs(int fd, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        if (ImageInfo.inImageBuildtimeCode()) {
            return PosixSupportLibrary.getUncached().fstatvfs(this.emulatedPosixSupport, fd);
        }
        return nativeLib.fstatvfs(this.nativePosixSupport, fd);
    }

    @ExportMessage
    final Object[] uname(@CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.uname(this.nativePosixSupport);
    }

    @ExportMessage
    final void unlinkat(int dirFd, Object pathname, boolean rmdir, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        nativeLib.unlinkat(this.nativePosixSupport, dirFd, pathname, rmdir);
    }

    @ExportMessage
    final void linkat(int oldFdDir, Object oldPath, int newFdDir, Object newPath, int flags, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        nativeLib.linkat(this.nativePosixSupport, oldFdDir, oldPath, newFdDir, newPath, flags);
    }

    @ExportMessage
    final void symlinkat(Object target, int linkpathDirFd, Object linkpath, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        nativeLib.symlinkat(this.nativePosixSupport, target, linkpathDirFd, linkpath);
    }

    @ExportMessage
    final void mkdirat(int dirFd, Object pathname, int mode, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        nativeLib.mkdirat(this.nativePosixSupport, dirFd, pathname, mode);
    }

    @ExportMessage
    final Object getcwd(@CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.getcwd(this.nativePosixSupport);
    }

    @ExportMessage
    final void chdir(Object path, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        nativeLib.chdir(this.nativePosixSupport, path);
    }

    @ExportMessage
    final void fchdir(int fd, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        nativeLib.fchdir(this.nativePosixSupport, fd);
    }

    @ExportMessage
    final boolean isatty(int fd, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.isatty(this.nativePosixSupport, fd);
    }

    @ExportMessage
    final Object opendir(Object path, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        if (ImageInfo.inImageBuildtimeCode()) {
            return this.addDirStream(PosixSupportLibrary.getUncached().opendir(this.emulatedPosixSupport, path));
        }
        return nativeLib.opendir(this.nativePosixSupport, path);
    }

    @ExportMessage
    final Object fdopendir(int fd, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.fdopendir(this.nativePosixSupport, fd);
    }

    @ExportMessage
    final void closedir(Object dirStream, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        if (ImageInfo.inImageBuildtimeCode()) {
            PosixSupportLibrary.getUncached().closedir(this.emulatedPosixSupport, this.removeDirStream(dirStream));
            return;
        }
        nativeLib.closedir(this.nativePosixSupport, dirStream);
    }

    @ExportMessage
    final Object readdir(Object dirStream, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        if (ImageInfo.inImageBuildtimeCode()) {
            return PosixSupportLibrary.getUncached().readdir(this.emulatedPosixSupport, dirStream);
        }
        return nativeLib.readdir(this.nativePosixSupport, dirStream);
    }

    @ExportMessage
    final void rewinddir(Object dirStream, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) {
        if (ImageInfo.inImageBuildtimeCode()) {
            PosixSupportLibrary.getUncached().rewinddir(this.emulatedPosixSupport, dirStream);
        }
        nativeLib.rewinddir(this.nativePosixSupport, dirStream);
    }

    @ExportMessage
    final Object dirEntryGetName(Object dirEntry, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        if (ImageInfo.inImageBuildtimeCode()) {
            return PosixSupportLibrary.getUncached().dirEntryGetName(this.emulatedPosixSupport, dirEntry);
        }
        return nativeLib.dirEntryGetName(this.nativePosixSupport, dirEntry);
    }

    @ExportMessage
    final Object dirEntryGetPath(Object dirEntry, Object scandirPath, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.dirEntryGetPath(this.nativePosixSupport, dirEntry, scandirPath);
    }

    @ExportMessage
    final long dirEntryGetInode(Object dirEntry, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.dirEntryGetInode(this.nativePosixSupport, dirEntry);
    }

    @ExportMessage
    final int dirEntryGetType(Object dirEntry, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.dirEntryGetType(this.nativePosixSupport, dirEntry);
    }

    @ExportMessage
    final void utimensat(int dirFd, Object pathname, long[] timespec, boolean followSymlinks, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        nativeLib.utimensat(this.nativePosixSupport, dirFd, pathname, timespec, followSymlinks);
    }

    @ExportMessage
    final void futimens(int fd, long[] timespec, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        nativeLib.futimens(this.nativePosixSupport, fd, timespec);
    }

    @ExportMessage
    final void futimes(int fd, PosixSupportLibrary.Timeval[] timeval, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        nativeLib.futimes(this.nativePosixSupport, fd, timeval);
    }

    @ExportMessage
    final void lutimes(Object filename, PosixSupportLibrary.Timeval[] timeval, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        nativeLib.lutimes(this.nativePosixSupport, filename, timeval);
    }

    @ExportMessage
    final void utimes(Object filename, PosixSupportLibrary.Timeval[] timeval, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        nativeLib.utimes(this.nativePosixSupport, filename, timeval);
    }

    @ExportMessage
    final void renameat(int oldDirFd, Object oldPath, int newDirFd, Object newPath, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        nativeLib.renameat(this.nativePosixSupport, oldDirFd, oldPath, newDirFd, newPath);
    }

    @ExportMessage
    final boolean faccessat(int dirFd, Object path, int mode, boolean effectiveIds, boolean followSymlinks, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.faccessat(this.nativePosixSupport, dirFd, path, mode, effectiveIds, followSymlinks);
    }

    @ExportMessage
    final void fchmodat(int dirFd, Object path, int mode, boolean followSymlinks, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        nativeLib.fchmodat(this.nativePosixSupport, dirFd, path, mode, followSymlinks);
    }

    @ExportMessage
    final void fchmod(int fd, int mode, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        nativeLib.fchmod(this.nativePosixSupport, fd, mode);
    }

    @ExportMessage
    final Object readlinkat(int dirFd, Object path, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.readlinkat(this.nativePosixSupport, dirFd, path);
    }

    @ExportMessage
    final void kill(long pid, int signal, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        nativeLib.kill(this.nativePosixSupport, pid, signal);
    }

    @ExportMessage
    final void killpg(long pgid, int signal, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        nativeLib.killpg(this.nativePosixSupport, pgid, signal);
    }

    @ExportMessage
    final long[] waitpid(long pid, int options, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.waitpid(this.nativePosixSupport, pid, options);
    }

    @ExportMessage
    final void abort(@CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        nativeLib.abort(this.nativePosixSupport);
    }

    @ExportMessage
    final boolean wcoredump(int status, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.wcoredump(this.nativePosixSupport, status);
    }

    @ExportMessage
    final boolean wifcontinued(int status, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.wifcontinued(this.nativePosixSupport, status);
    }

    @ExportMessage
    final boolean wifstopped(int status, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.wifstopped(this.nativePosixSupport, status);
    }

    @ExportMessage
    final boolean wifsignaled(int status, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.wifsignaled(this.nativePosixSupport, status);
    }

    @ExportMessage
    final boolean wifexited(int status, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.wifexited(this.nativePosixSupport, status);
    }

    @ExportMessage
    final int wexitstatus(int status, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.wexitstatus(this.nativePosixSupport, status);
    }

    @ExportMessage
    final int wtermsig(int status, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.wtermsig(this.nativePosixSupport, status);
    }

    @ExportMessage
    final int wstopsig(int status, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.wstopsig(this.nativePosixSupport, status);
    }

    @ExportMessage
    final long getuid(@CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.getuid(this.nativePosixSupport);
    }

    @ExportMessage
    final long geteuid(@CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.geteuid(this.nativePosixSupport);
    }

    @ExportMessage
    final long getgid(@CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.getgid(this.nativePosixSupport);
    }

    @ExportMessage
    final long getppid(@CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.getppid(this.nativePosixSupport);
    }

    @ExportMessage
    final long getpgid(long pid, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.getpgid(this.nativePosixSupport, pid);
    }

    @ExportMessage
    final void setpgid(long pid, long pgid, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        nativeLib.setpgid(this.nativePosixSupport, pid, pgid);
    }

    @ExportMessage
    final long getpgrp(@CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.getpgrp(this.nativePosixSupport);
    }

    @ExportMessage
    final long getsid(long pid, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.getsid(this.nativePosixSupport, pid);
    }

    @ExportMessage
    final long setsid(@CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.setsid(this.nativePosixSupport);
    }

    @ExportMessage
    final PosixSupportLibrary.OpenPtyResult openpty(@CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.openpty(this.nativePosixSupport);
    }

    @ExportMessage
    final TruffleString ctermid(@CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.ctermid(this.nativePosixSupport);
    }

    @ExportMessage
    final void setenv(Object name, Object value, boolean overwrite, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        nativeLib.setenv(this.nativePosixSupport, name, value, overwrite);
    }

    @ExportMessage
    final void unsetenv(Object name, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        nativeLib.unsetenv(this.nativePosixSupport, name);
    }

    @ExportMessage
    final int forkExec(Object[] executables, Object[] args, Object cwd, Object[] env, int stdinReadFd, int stdinWriteFd, int stdoutReadFd, int stdoutWriteFd, int stderrReadFd, int stderrWriteFd, int errPipeReadFd, int errPipeWriteFd, boolean closeFds, boolean restoreSignals, boolean callSetsid, int[] fdsToKeep, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.forkExec(this.nativePosixSupport, executables, args, cwd, env, stdinReadFd, stdinWriteFd, stdoutReadFd, stdoutWriteFd, stderrReadFd, stderrWriteFd, errPipeReadFd, errPipeWriteFd, closeFds, restoreSignals, callSetsid, fdsToKeep);
    }

    @ExportMessage
    final void execv(Object pathname, Object[] args, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        nativeLib.execv(this.nativePosixSupport, pathname, args);
    }

    @ExportMessage
    final int system(Object command, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.system(this.nativePosixSupport, command);
    }

    @ExportMessage
    final Object mmap(long length, int prot, int flags, int fd, long offset, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.mmap(this.nativePosixSupport, length, prot, flags, fd, offset);
    }

    @ExportMessage
    final byte mmapReadByte(Object mmap, long index, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.mmapReadByte(this.nativePosixSupport, mmap, index);
    }

    @ExportMessage
    final void mmapWriteByte(Object mmap, long index, byte value, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        nativeLib.mmapWriteByte(this.nativePosixSupport, mmap, index, value);
    }

    @ExportMessage
    final int mmapReadBytes(Object mmap, long index, byte[] bytes, int length, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.mmapReadBytes(this.nativePosixSupport, mmap, index, bytes, length);
    }

    @ExportMessage
    final void mmapWriteBytes(Object mmap, long index, byte[] bytes, int length, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        nativeLib.mmapWriteBytes(this.nativePosixSupport, mmap, index, bytes, length);
    }

    @ExportMessage
    final void mmapFlush(Object mmap, long offset, long length, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        nativeLib.mmapFlush(this.nativePosixSupport, mmap, offset, length);
    }

    @ExportMessage
    final void mmapUnmap(Object mmap, long length, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        nativeLib.mmapUnmap(this.nativePosixSupport, mmap, length);
    }

    @ExportMessage
    final long mmapGetPointer(Object mmap, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.mmapGetPointer(this.nativePosixSupport, mmap);
    }

    @ExportMessage
    public PosixSupportLibrary.PwdResult getpwuid(long uid, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.getpwuid(this.nativePosixSupport, uid);
    }

    @ExportMessage
    public PosixSupportLibrary.PwdResult getpwnam(Object name, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.getpwnam(this.nativePosixSupport, name);
    }

    @ExportMessage
    public boolean hasGetpwentries(@CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) {
        return nativeLib.hasGetpwentries(this.nativePosixSupport);
    }

    @ExportMessage
    public PosixSupportLibrary.PwdResult[] getpwentries(@CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.getpwentries(this.nativePosixSupport);
    }

    @ExportMessage
    final int socket(int domain, int type, int protocol, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.socket(this.nativePosixSupport, domain, type, protocol);
    }

    @ExportMessage
    final PosixSupportLibrary.AcceptResult accept(int sockfd, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.accept(this.nativePosixSupport, sockfd);
    }

    @ExportMessage
    final void bind(int sockfd, PosixSupportLibrary.UniversalSockAddr addr, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        nativeLib.bind(this.nativePosixSupport, sockfd, addr);
    }

    @ExportMessage
    final void connect(int sockfd, PosixSupportLibrary.UniversalSockAddr addr, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        nativeLib.connect(this.nativePosixSupport, sockfd, addr);
    }

    @ExportMessage
    final void listen(int sockfd, int backlog, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        nativeLib.listen(this.nativePosixSupport, sockfd, backlog);
    }

    @ExportMessage
    final PosixSupportLibrary.UniversalSockAddr getpeername(int sockfd, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.getpeername(this.nativePosixSupport, sockfd);
    }

    @ExportMessage
    final PosixSupportLibrary.UniversalSockAddr getsockname(int sockfd, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.getsockname(this.nativePosixSupport, sockfd);
    }

    @ExportMessage
    final int send(int sockfd, byte[] buf, int offset, int len, int flags, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.send(this.nativePosixSupport, sockfd, buf, offset, len, flags);
    }

    @ExportMessage
    final int sendto(int sockfd, byte[] buf, int offset, int len, int flags, PosixSupportLibrary.UniversalSockAddr destAddr, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.sendto(this.nativePosixSupport, sockfd, buf, offset, len, flags, destAddr);
    }

    @ExportMessage
    final int recv(int sockfd, byte[] buf, int offset, int len, int flags, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.recv(this.nativePosixSupport, sockfd, buf, offset, len, flags);
    }

    @ExportMessage
    final PosixSupportLibrary.RecvfromResult recvfrom(int sockfd, byte[] buf, int offset, int len, int flags, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.recvfrom(this.nativePosixSupport, sockfd, buf, offset, len, flags);
    }

    @ExportMessage
    final void shutdown(int sockfd, int how, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        nativeLib.shutdown(this.nativePosixSupport, sockfd, how);
    }

    @ExportMessage
    final int getsockopt(int sockfd, int level, int optname, byte[] optval, int optlen, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.getsockopt(this.nativePosixSupport, sockfd, level, optname, optval, optlen);
    }

    @ExportMessage
    final void setsockopt(int sockfd, int level, int optname, byte[] optval, int optlen, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        nativeLib.setsockopt(this.nativePosixSupport, sockfd, level, optname, optval, optlen);
    }

    @ExportMessage
    final int inet_addr(Object src, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.inet_addr(this.nativePosixSupport, src);
    }

    @ExportMessage
    final int inet_aton(Object src, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.InvalidAddressException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.inet_aton(this.nativePosixSupport, src);
    }

    @ExportMessage
    final Object inet_ntoa(int address, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.inet_ntoa(this.nativePosixSupport, address);
    }

    @ExportMessage
    final byte[] inet_pton(int family, Object src, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException, PosixSupportLibrary.InvalidAddressException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.inet_pton(this.nativePosixSupport, family, src);
    }

    @ExportMessage
    final Object inet_ntop(int family, byte[] src, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.inet_ntop(this.nativePosixSupport, family, src);
    }

    @ExportMessage
    final Object gethostname(@CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.gethostname(this.nativePosixSupport);
    }

    @ExportMessage
    final Object[] getnameinfo(PosixSupportLibrary.UniversalSockAddr addr, int flags, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.GetAddrInfoException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.getnameinfo(this.nativePosixSupport, addr, flags);
    }

    @ExportMessage
    final PosixSupportLibrary.AddrInfoCursor getaddrinfo(Object node, Object service, int family, int sockType, int protocol, int flags, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.GetAddrInfoException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.getaddrinfo(this.nativePosixSupport, node, service, family, sockType, protocol, flags);
    }

    @ExportMessage
    final TruffleString crypt(TruffleString word, TruffleString salt, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) throws PosixSupportLibrary.PosixException {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.crypt(this.nativePosixSupport, word, salt);
    }

    @ExportMessage
    final PosixSupportLibrary.UniversalSockAddr createUniversalSockAddr(PosixSupportLibrary.FamilySpecificSockAddr src, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) {
        ImageBuildtimePosixSupport.checkNotInImageBuildtime();
        return nativeLib.createUniversalSockAddr(this.nativePosixSupport, src);
    }

    @ExportMessage
    final Object createPathFromString(TruffleString path, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) {
        if (ImageInfo.inImageBuildtimeCode()) {
            return PosixSupportLibrary.getUncached().createPathFromString(this.emulatedPosixSupport, path);
        }
        return nativeLib.createPathFromString(this.nativePosixSupport, path);
    }

    @ExportMessage
    final Object createPathFromBytes(byte[] path, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) {
        if (ImageInfo.inImageBuildtimeCode()) {
            return PosixSupportLibrary.getUncached().createPathFromBytes(this.emulatedPosixSupport, path);
        }
        return nativeLib.createPathFromBytes(this.nativePosixSupport, path);
    }

    @ExportMessage
    final TruffleString getPathAsString(Object path, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) {
        if (ImageInfo.inImageBuildtimeCode()) {
            return PosixSupportLibrary.getUncached().getPathAsString(this.emulatedPosixSupport, path);
        }
        return nativeLib.getPathAsString(this.nativePosixSupport, path);
    }

    @ExportMessage
    final PosixSupportLibrary.Buffer getPathAsBytes(Object path, @CachedLibrary(value="this.nativePosixSupport") PosixSupportLibrary nativeLib) {
        if (ImageInfo.inImageBuildtimeCode()) {
            return PosixSupportLibrary.getUncached().getPathAsBytes(this.emulatedPosixSupport, path);
        }
        return nativeLib.getPathAsBytes(this.nativePosixSupport, path);
    }
}

