/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.util;

import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypesGen;
import com.oracle.graal.python.nodes.util.CastToJavaIntLossyNode;
import com.oracle.graal.python.nodes.util.CastToJavaIntNode;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;

@GeneratedBy(value=CastToJavaIntLossyNode.class)
public final class CastToJavaIntLossyNodeGen {
    private static final Uncached UNCACHED = new Uncached();

    @NeverDefault
    public static CastToJavaIntLossyNode getUncached() {
        return UNCACHED;
    }

    @NeverDefault
    public static CastToJavaIntLossyNode inline(@InlineSupport.RequiredField(bits=11, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
        return new Inlined(target);
    }

    @GeneratedBy(value=CastToJavaIntLossyNode.class)
    @DenyReplace
    private static final class Uncached
    extends CastToJavaIntLossyNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int execute(Node arg0Value, Object arg1Value) {
            if (PythonArithmeticTypesGen.isImplicitInteger(arg1Value)) {
                int arg1Value_ = PythonArithmeticTypesGen.asImplicitInteger(arg1Value);
                return CastToJavaIntNode.toInt(arg1Value_);
            }
            if (PythonArithmeticTypesGen.isImplicitLong(arg1Value)) {
                long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong(arg1Value);
                return CastToJavaIntLossyNode.toInt(arg1Value_);
            }
            if (arg1Value instanceof PInt) {
                PInt arg1Value_ = (PInt)arg1Value;
                return CastToJavaIntLossyNode.toIntOverflow(arg1Value_);
            }
            return CastToJavaIntNode.doUnsupported(arg1Value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int execute(Node arg0Value, long arg1Value) {
            if (PythonArithmeticTypesGen.isImplicitLong(arg1Value)) {
                long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong(arg1Value);
                return CastToJavaIntLossyNode.toInt(arg1Value_);
            }
            return CastToJavaIntNode.doUnsupported(arg1Value);
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=CastToJavaIntLossyNode.class)
    @DenyReplace
    private static final class Inlined
    extends CastToJavaIntLossyNode {
        private final InlineSupport.StateField state_0_;

        private Inlined(InlineSupport.InlineTarget target) {
            assert (target.getTargetClass().isAssignableFrom(CastToJavaIntLossyNode.class));
            this.state_0_ = target.getState(0, 11);
        }

        private boolean fallbackGuard_(int state_0, Node arg0Value, Object arg1Value) {
            if (PythonArithmeticTypesGen.isImplicitLong(arg1Value)) {
                return false;
            }
            return (state_0 & 0x10) != 0 || !(arg1Value instanceof PInt);
        }

        @Override
        public int execute(Node arg0Value, Object arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if ((state_0 & 0x37) != 0) {
                if ((state_0 & 1) != 0 && PythonArithmeticTypesGen.isImplicitInteger((state_0 & 0xC0) >>> 6, arg1Value)) {
                    int arg1Value_ = PythonArithmeticTypesGen.asImplicitInteger((state_0 & 0xC0) >>> 6, arg1Value);
                    return CastToJavaIntNode.toInt(arg1Value_);
                }
                if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x700) >>> 8, arg1Value)) {
                    long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x700) >>> 8, arg1Value);
                    return CastToJavaIntLossyNode.toInt(arg1Value_);
                }
                if ((state_0 & 0x14) != 0 && arg1Value instanceof PInt) {
                    PInt arg1Value_ = (PInt)arg1Value;
                    if ((state_0 & 4) != 0) {
                        try {
                            return CastToJavaIntLossyNode.toIntPInt(arg1Value_);
                        }
                        catch (OverflowException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_.get(arg0Value);
                            state_0 &= 0xFFFFFFFB;
                            this.state_0_.set(arg0Value, state_0 |= 8);
                            return this.executeAndSpecialize(arg0Value, arg1Value_);
                        }
                    }
                    if ((state_0 & 0x10) != 0) {
                        return CastToJavaIntLossyNode.toIntOverflow(arg1Value_);
                    }
                }
                if ((state_0 & 0x20) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                    return CastToJavaIntNode.doUnsupported(arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        @Override
        public int execute(Node arg0Value, long arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if ((state_0 & 0x22) != 0) {
                if ((state_0 & 2) != 0 && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x700) >>> 8, arg1Value)) {
                    long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x700) >>> 8, arg1Value);
                    return CastToJavaIntLossyNode.toInt(arg1Value_);
                }
                if ((state_0 & 0x20) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                    return CastToJavaIntNode.doUnsupported(arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        private int executeAndSpecialize(Node arg0Value, Object arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            int intCast1 = PythonArithmeticTypesGen.specializeImplicitInteger(arg1Value);
            if (intCast1 != 0) {
                int arg1Value_ = PythonArithmeticTypesGen.asImplicitInteger(intCast1, arg1Value);
                state_0 |= intCast1 << 6;
                this.state_0_.set(arg0Value, state_0 |= 1);
                return CastToJavaIntNode.toInt(arg1Value_);
            }
            int longCast1 = PythonArithmeticTypesGen.specializeImplicitLong(arg1Value);
            if (longCast1 != 0) {
                long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast1, arg1Value);
                state_0 |= longCast1 << 8;
                this.state_0_.set(arg0Value, state_0 |= 2);
                return CastToJavaIntLossyNode.toInt(arg1Value_);
            }
            if (arg1Value instanceof PInt) {
                PInt arg1Value_ = (PInt)arg1Value;
                if ((state_0 & 0x10) == 0 && (state_0 & 8) == 0) {
                    this.state_0_.set(arg0Value, state_0 |= 4);
                    try {
                        return CastToJavaIntLossyNode.toIntPInt(arg1Value_);
                    }
                    catch (OverflowException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_.get(arg0Value);
                        state_0 &= 0xFFFFFFFB;
                        this.state_0_.set(arg0Value, state_0 |= 8);
                        return this.executeAndSpecialize(arg0Value, arg1Value_);
                    }
                }
                state_0 &= 0xFFFFFFFB;
                this.state_0_.set(arg0Value, state_0 |= 0x10);
                return CastToJavaIntLossyNode.toIntOverflow(arg1Value_);
            }
            this.state_0_.set(arg0Value, state_0 |= 0x20);
            return CastToJavaIntNode.doUnsupported(arg1Value);
        }

        public boolean isAdoptable() {
            return false;
        }
    }
}

