/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.object;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfilesFactory;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

public abstract class BuiltinClassProfiles {
    private BuiltinClassProfiles() {
    }

    @GenerateCached(value=false)
    @GenerateUncached
    @GenerateInline
    public static abstract class IsBuiltinSubtypeObjectProfile
    extends Node {
        public static boolean profileObjectUncached(Object obj, PythonBuiltinClassType type) {
            return IsBuiltinSubtypeObjectProfile.getUncached().profileObject(null, null, obj, type);
        }

        public static IsBuiltinSubtypeObjectProfile getUncached() {
            return BuiltinClassProfilesFactory.IsBuiltinSubtypeObjectProfileNodeGen.getUncached();
        }

        public final boolean profileException(VirtualFrame frame, Node inliningTarget, PException obj, PythonBuiltinClassType type) {
            return this.profileObject(frame, inliningTarget, obj.getUnreifiedException(), type);
        }

        public final boolean profileObject(VirtualFrame frame, Node inliningTarget, Object obj, PythonBuiltinClassType type) {
            return this.execute(frame, inliningTarget, obj, type);
        }

        abstract boolean execute(VirtualFrame var1, Node var2, Object var3, PythonBuiltinClassType var4);

        @Specialization
        static boolean doIt(VirtualFrame frame, Node inliningTarget, Object obj, PythonBuiltinClassType type, @Cached GetClassNode getClassNode, @Cached(inline=false) IsSubtypeNode isSubtypeNode) {
            Object clazz = getClassNode.execute(inliningTarget, obj);
            return isSubtypeNode.execute(frame, clazz, (Object)type);
        }
    }

    @GenerateCached(value=false)
    @GenerateUncached
    @GenerateInline
    public static abstract class IsOtherBuiltinObjectProfile
    extends Node {
        public final boolean profileIsOtherBuiltinObject(Node inliningTarget, Object obj, PythonBuiltinClassType forbiddenType) {
            return this.execute(inliningTarget, obj, forbiddenType);
        }

        abstract boolean execute(Node var1, Object var2, PythonBuiltinClassType var3);

        @Specialization
        static boolean doIt(Node inliningTarget, Object obj, PythonBuiltinClassType forbiddenType, @Cached GetClassNode getClassNode, @Cached IsOtherBuiltinClassProfile isOtherBuiltinClass) {
            Object clazz = getClassNode.execute(inliningTarget, obj);
            return isOtherBuiltinClass.execute(inliningTarget, clazz, forbiddenType);
        }
    }

    @GenerateUncached
    @GenerateInline(inlineByDefault=true)
    public static abstract class IsBuiltinObjectProfile
    extends Node {
        public static boolean profileObjectUncached(Object obj, PythonBuiltinClassType type) {
            return BuiltinClassProfilesFactory.IsBuiltinObjectProfileNodeGen.getUncached().profileObject(null, obj, type);
        }

        public static IsBuiltinObjectProfile getUncached() {
            return BuiltinClassProfilesFactory.IsBuiltinObjectProfileNodeGen.getUncached();
        }

        public static IsBuiltinObjectProfile create() {
            return BuiltinClassProfilesFactory.IsBuiltinObjectProfileNodeGen.create();
        }

        public final boolean profileException(Node inliningTarget, PException obj, PythonBuiltinClassType type) {
            return this.profileObject(inliningTarget, obj.getUnreifiedException(), type);
        }

        public final boolean profileObject(Node inliningTarget, Object obj, PythonBuiltinClassType type) {
            return this.execute(inliningTarget, obj, type);
        }

        abstract boolean execute(Node var1, Object var2, PythonBuiltinClassType var3);

        @Specialization
        static boolean doIt(Node inliningTarget, Object obj, PythonBuiltinClassType type, @Cached GetClassNode getClassNode, @Cached InlineIsBuiltinClassProfile isBuiltinClass) {
            Object clazz = getClassNode.execute(inliningTarget, obj);
            return isBuiltinClass.profileIsBuiltinClass(inliningTarget, clazz, type);
        }
    }

    @GenerateCached(value=false)
    @GenerateUncached
    @GenerateInline
    public static abstract class IsAnyBuiltinObjectProfile
    extends Node {
        public final boolean profileIsAnyBuiltinObject(Node inliningTarget, Object obj) {
            return this.execute(inliningTarget, obj);
        }

        abstract boolean execute(Node var1, Object var2);

        @Specialization
        static boolean doIt(Node inliningTarget, Object obj, @Cached GetClassNode getClassNode, @Cached IsAnyBuiltinClassProfile isAnyBuiltinClass) {
            Object clazz = getClassNode.execute(inliningTarget, obj);
            return isAnyBuiltinClass.execute(inliningTarget, clazz);
        }
    }

    @GenerateUncached
    @GenerateInline(inlineByDefault=true)
    public static abstract class InlineIsBuiltinClassProfile
    extends Node {
        public static InlineIsBuiltinClassProfile getUncached() {
            return BuiltinClassProfilesFactory.InlineIsBuiltinClassProfileNodeGen.getUncached();
        }

        public static boolean profileClassSlowPath(Object clazz, PythonBuiltinClassType type) {
            if (clazz instanceof PythonBuiltinClassType) {
                return clazz == type;
            }
            if (clazz instanceof PythonBuiltinClass) {
                return ((PythonBuiltinClass)clazz).getType() == type;
            }
            return false;
        }

        public static InlineIsBuiltinClassProfile create() {
            return BuiltinClassProfilesFactory.InlineIsBuiltinClassProfileNodeGen.create();
        }

        public final boolean profileIsBuiltinClass(Node inliningTarget, Object clazz, PythonBuiltinClassType type) {
            return this.execute(inliningTarget, clazz, type);
        }

        public boolean profileClass(Node inliningTarget, Object type, PythonBuiltinClassType pythonClass) {
            return this.execute(inliningTarget, type, pythonClass);
        }

        abstract boolean execute(Node var1, Object var2, PythonBuiltinClassType var3);

        public final boolean profileClassCached(Object clazz, PythonBuiltinClassType pythonClass) {
            return this.execute(this, clazz, pythonClass);
        }

        @Specialization
        static boolean doType(Node inliningTarget, PythonBuiltinClassType clazz, PythonBuiltinClassType pythonClass) {
            return clazz == pythonClass;
        }

        @Specialization
        static boolean doClass(Node inliningTarget, PythonBuiltinClass clazz, PythonBuiltinClassType pythonClass) {
            return clazz.getType() == pythonClass;
        }

        @Fallback
        static boolean doOthers(Node inliningTarget, Object clazz, PythonBuiltinClassType pythonClass) {
            return false;
        }
    }

    @GenerateCached(value=false)
    @GenerateUncached
    @GenerateInline
    public static abstract class IsOtherBuiltinClassProfile
    extends Node {
        public final boolean profileIsOtherBuiltinClass(Node inliningTarget, Object clazz, PythonBuiltinClassType forbiddenType) {
            return this.execute(inliningTarget, clazz, forbiddenType);
        }

        abstract boolean execute(Node var1, Object var2, PythonBuiltinClassType var3);

        @Specialization
        static boolean doType(Node inliningTarget, PythonBuiltinClassType clazz, PythonBuiltinClassType forbiddenType) {
            return clazz != forbiddenType;
        }

        @Specialization
        static boolean doClass(Node inliningTarget, PythonBuiltinClass clazz, PythonBuiltinClassType forbiddenType) {
            return clazz.getType() != forbiddenType;
        }

        @Fallback
        static boolean doOthers(Node inliningTarget, Object clazz, PythonBuiltinClassType forbiddenType) {
            return false;
        }
    }

    @GenerateCached(value=false)
    @GenerateUncached
    @GenerateInline
    public static abstract class IsAnyBuiltinClassProfile
    extends Node {
        public final boolean profileIsAnyBuiltinClass(Node inliningTarget, Object clazz) {
            return this.execute(inliningTarget, clazz);
        }

        abstract boolean execute(Node var1, Object var2);

        @Specialization
        static boolean doType(Node inliningTarget, PythonBuiltinClassType clazz) {
            return true;
        }

        @Specialization
        static boolean doClass(Node inliningTarget, PythonBuiltinClass clazz) {
            return true;
        }

        @Fallback
        static boolean doOthers(Node inliningTarget, Object clazz) {
            return false;
        }
    }
}

