/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.expression;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.expression.BinaryArithmetic;
import com.oracle.graal.python.nodes.expression.CallArithmeticRootNode;
import com.oracle.graal.python.nodes.expression.LookupAndCallInplaceNode;
import com.oracle.graal.python.nodes.expression.TernaryArithmetic;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.Supplier;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.strings.TruffleString;

public final class InplaceArithmetic
extends Enum<InplaceArithmetic> {
    public static final /* enum */ InplaceArithmetic IAdd = new InplaceArithmetic(SpecialMethodSlot.IAdd, SpecialMethodNames.T___ADD__, "+=", BinaryArithmetic.Add);
    public static final /* enum */ InplaceArithmetic ISub = new InplaceArithmetic(SpecialMethodNames.T___ISUB__, SpecialMethodNames.T___SUB__, "-=", BinaryArithmetic.Sub);
    public static final /* enum */ InplaceArithmetic IMul = new InplaceArithmetic(SpecialMethodSlot.IMul, SpecialMethodNames.T___MUL__, "*=", BinaryArithmetic.Mul);
    public static final /* enum */ InplaceArithmetic ITrueDiv = new InplaceArithmetic(SpecialMethodNames.T___ITRUEDIV__, SpecialMethodNames.T___TRUEDIV__, "/=", BinaryArithmetic.TrueDiv);
    public static final /* enum */ InplaceArithmetic IFloorDiv = new InplaceArithmetic(SpecialMethodNames.T___IFLOORDIV__, SpecialMethodNames.T___FLOORDIV__, "//=", BinaryArithmetic.FloorDiv);
    public static final /* enum */ InplaceArithmetic IMod = new InplaceArithmetic(SpecialMethodNames.T___IMOD__, SpecialMethodNames.T___MOD__, "%=", BinaryArithmetic.Mod);
    public static final /* enum */ InplaceArithmetic IPow = new InplaceArithmetic(SpecialMethodNames.T___IPOW__, SpecialMethodNames.T___POW__, "**=", BinaryArithmetic.Pow, true);
    public static final /* enum */ InplaceArithmetic ILShift = new InplaceArithmetic(SpecialMethodNames.T___ILSHIFT__, SpecialMethodNames.T___LSHIFT__, "<<=", BinaryArithmetic.LShift);
    public static final /* enum */ InplaceArithmetic IRShift = new InplaceArithmetic(SpecialMethodNames.T___IRSHIFT__, SpecialMethodNames.T___RSHIFT__, ">>=", BinaryArithmetic.RShift);
    public static final /* enum */ InplaceArithmetic IAnd = new InplaceArithmetic(SpecialMethodNames.T___IAND__, SpecialMethodNames.T___AND__, "&=", BinaryArithmetic.And);
    public static final /* enum */ InplaceArithmetic IOr = new InplaceArithmetic(SpecialMethodNames.T___IOR__, SpecialMethodNames.T___OR__, "|=", BinaryArithmetic.Or);
    public static final /* enum */ InplaceArithmetic IXor = new InplaceArithmetic(SpecialMethodNames.T___IXOR__, SpecialMethodNames.T___XOR__, "^=", BinaryArithmetic.Xor);
    public static final /* enum */ InplaceArithmetic IMatMul = new InplaceArithmetic(SpecialMethodNames.T___IMATMUL__, SpecialMethodNames.T___MATMUL__, "@", BinaryArithmetic.MatMul);
    final TruffleString methodName;
    final SpecialMethodSlot slot;
    final boolean isTernary;
    final Supplier<LookupAndCallInplaceNode.NotImplementedHandler> notImplementedHandler;
    final BinaryArithmetic binary;
    final TruffleString binaryOpName;
    private static final /* synthetic */ InplaceArithmetic[] $VALUES;

    public static InplaceArithmetic[] values() {
        return (InplaceArithmetic[])$VALUES.clone();
    }

    public static InplaceArithmetic valueOf(String name) {
        return Enum.valueOf(InplaceArithmetic.class, name);
    }

    private InplaceArithmetic(TruffleString methodName, TruffleString binaryOpName, String operator, BinaryArithmetic binary) {
        this(methodName, binaryOpName, operator, binary, false);
    }

    private InplaceArithmetic(SpecialMethodSlot slot, TruffleString binaryOpName, String operator, BinaryArithmetic binary) {
        this(slot.getName(), binaryOpName, operator, binary, false, slot);
    }

    private InplaceArithmetic(TruffleString methodName, TruffleString binaryOpName, String operator, BinaryArithmetic binary, boolean isTernary) {
        this(methodName, binaryOpName, operator, binary, isTernary, null);
    }

    private InplaceArithmetic(TruffleString methodName, TruffleString binaryOpName, final String operator, BinaryArithmetic binary, boolean isTernary, SpecialMethodSlot slot) {
        assert (methodName.toJavaStringUncached().startsWith("__i") && methodName.toJavaStringUncached().substring(3).equals(binaryOpName.toJavaStringUncached().substring(2)));
        this.methodName = methodName;
        this.binary = binary;
        this.isTernary = isTernary;
        this.binaryOpName = binaryOpName;
        this.slot = slot;
        this.notImplementedHandler = () -> new LookupAndCallInplaceNode.NotImplementedHandler(){
            @Node.Child
            private PRaiseNode raiseNode = PRaiseNode.create();

            @Override
            public Object execute(Object arg, Object arg2) {
                throw this.raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.UNSUPPORTED_OPERAND_TYPES_FOR_S_P_AND_P, operator, arg, arg2);
            }
        };
    }

    public TruffleString getMethodName() {
        return this.methodName;
    }

    public boolean isTernary() {
        return this.isTernary;
    }

    public LookupAndCallInplaceNode create() {
        return LookupAndCallInplaceNode.create(this);
    }

    public RootNode createRootNode(PythonLanguage language) {
        return new CallInplaceArithmeticRootNode(language, this);
    }

    private static /* synthetic */ InplaceArithmetic[] $values() {
        return new InplaceArithmetic[]{IAdd, ISub, IMul, ITrueDiv, IFloorDiv, IMod, IPow, ILShift, IRShift, IAnd, IOr, IXor, IMatMul};
    }

    static {
        $VALUES = InplaceArithmetic.$values();
    }

    static final class CallInplaceArithmeticRootNode
    extends CallArithmeticRootNode {
        @Node.Child
        private LookupAndCallInplaceNode callInplaceNode;
        private final InplaceArithmetic inplaceOperator;

        CallInplaceArithmeticRootNode(PythonLanguage language, InplaceArithmetic inplaceOperator) {
            super(language);
            this.inplaceOperator = inplaceOperator;
        }

        @Override
        public Signature getSignature() {
            if (this.inplaceOperator.isTernary()) {
                return TernaryArithmetic.CallTernaryArithmeticRootNode.SIGNATURE_TERNARY;
            }
            return BinaryArithmetic.CallBinaryArithmeticRootNode.SIGNATURE_BINARY;
        }

        @Override
        protected Object doCall(VirtualFrame frame) {
            if (this.callInplaceNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callInplaceNode = (LookupAndCallInplaceNode)this.insert(this.inplaceOperator.create());
            }
            if (this.inplaceOperator.isTernary()) {
                return this.callInplaceNode.executeTernary(frame, PArguments.getArgument((Frame)frame, 0), PArguments.getArgument((Frame)frame, 1), PArguments.getArgument((Frame)frame, 2));
            }
            return this.callInplaceNode.execute(frame, PArguments.getArgument((Frame)frame, 0), PArguments.getArgument((Frame)frame, 1));
        }
    }
}

