/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.expression;

import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.lib.GetNextNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.nodes.call.special.LookupAndCallBinaryNode;
import com.oracle.graal.python.nodes.expression.BinaryOpNode;
import com.oracle.graal.python.nodes.expression.CoerceToBooleanNode;
import com.oracle.graal.python.nodes.expression.ContainsNodeGen;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;

public abstract class ContainsNode
extends BinaryOpNode {
    @Node.Child
    private LookupAndCallBinaryNode callNode = LookupAndCallBinaryNode.create(SpecialMethodSlot.Contains);
    @Node.Child
    private GetNextNode next;

    @NeverDefault
    public static ContainsNode create() {
        return ContainsNodeGen.create();
    }

    @Specialization(rewriteOn={UnexpectedResultException.class})
    boolean doBoolean(VirtualFrame frame, boolean item, Object iter, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CoerceToBooleanNode.YesNode castBool, @Cached.Shared(value="errorProfile") @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached.Shared(value="getIter") @Cached PyObjectGetIter getIter, @Cached.Shared(value="eqNode") @Cached PyObjectRichCompareBool.EqNode eqNode) throws UnexpectedResultException {
        Object result = this.callNode.executeObject(frame, iter, item);
        if (result == PNotImplemented.NOT_IMPLEMENTED) {
            Object iterator = getIter.execute((Frame)frame, inliningTarget, iter);
            return this.sequenceContains(frame, iterator, item, eqNode, (Node)this, errorProfile);
        }
        return castBool.executeBoolean(frame, inliningTarget, result);
    }

    @Specialization(rewriteOn={UnexpectedResultException.class})
    boolean doInt(VirtualFrame frame, int item, Object iter, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CoerceToBooleanNode.YesNode castBool, @Cached.Shared(value="errorProfile") @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached.Shared(value="getIter") @Cached PyObjectGetIter getIter, @Cached.Shared(value="eqNode") @Cached PyObjectRichCompareBool.EqNode eqNode) throws UnexpectedResultException {
        Object result = this.callNode.executeObject(frame, iter, item);
        if (result == PNotImplemented.NOT_IMPLEMENTED) {
            return this.sequenceContains(frame, getIter.execute((Frame)frame, inliningTarget, iter), item, eqNode, (Node)this, errorProfile);
        }
        return castBool.executeBoolean(frame, inliningTarget, result);
    }

    @Specialization(rewriteOn={UnexpectedResultException.class})
    boolean doLong(VirtualFrame frame, long item, Object iter, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CoerceToBooleanNode.YesNode castBool, @Cached.Shared(value="errorProfile") @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached.Shared(value="getIter") @Cached PyObjectGetIter getIter, @Cached.Shared(value="eqNode") @Cached PyObjectRichCompareBool.EqNode eqNode) throws UnexpectedResultException {
        Object result = this.callNode.executeObject(frame, iter, item);
        if (result == PNotImplemented.NOT_IMPLEMENTED) {
            return this.sequenceContains(frame, getIter.execute((Frame)frame, inliningTarget, iter), item, eqNode, (Node)this, errorProfile);
        }
        return castBool.executeBoolean(frame, inliningTarget, result);
    }

    @Specialization(rewriteOn={UnexpectedResultException.class})
    boolean doDouble(VirtualFrame frame, double item, Object iter, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CoerceToBooleanNode.YesNode castBool, @Cached.Shared(value="errorProfile") @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached.Shared(value="getIter") @Cached PyObjectGetIter getIter, @Cached.Shared(value="eqNode") @Cached PyObjectRichCompareBool.EqNode eqNode) throws UnexpectedResultException {
        Object result = this.callNode.executeObject(frame, iter, item);
        if (result == PNotImplemented.NOT_IMPLEMENTED) {
            return this.sequenceContains(frame, getIter.execute((Frame)frame, inliningTarget, iter), item, eqNode, (Node)this, errorProfile);
        }
        return castBool.executeBoolean(frame, inliningTarget, result);
    }

    @Specialization
    boolean doGeneric(VirtualFrame frame, Object item, Object iter, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CoerceToBooleanNode.YesNode castBool, @Cached.Shared(value="errorProfile") @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached.Shared(value="getIter") @Cached PyObjectGetIter getIter, @Cached.Shared(value="eqNode") @Cached PyObjectRichCompareBool.EqNode eqNode) {
        Object result = this.callNode.executeObject(frame, iter, item);
        if (result == PNotImplemented.NOT_IMPLEMENTED) {
            return this.sequenceContainsObject(frame, getIter.execute((Frame)frame, inliningTarget, iter), item, eqNode, this, errorProfile);
        }
        return castBool.executeBoolean(frame, inliningTarget, result);
    }

    private void handleUnexpectedResult(VirtualFrame frame, Object iterator, Object item, UnexpectedResultException e, PyObjectRichCompareBool.EqNode eqNode, Node inliningTarget, BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile) throws UnexpectedResultException {
        Object result = e.getResult();
        result = eqNode.compare((Frame)frame, inliningTarget, result, item) ? Boolean.valueOf(true) : Boolean.valueOf(this.sequenceContainsObject(frame, iterator, item, eqNode, inliningTarget, errorProfile));
        throw new UnexpectedResultException(result);
    }

    private boolean sequenceContains(VirtualFrame frame, Object iterator, boolean item, PyObjectRichCompareBool.EqNode eqNode, Node inliningTarget, BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile) throws UnexpectedResultException {
        while (true) {
            try {
                while (this.getNext().executeBoolean(frame, iterator) != item) {
                }
                return true;
            }
            catch (PException e) {
                e.expectStopIteration(inliningTarget, errorProfile);
                return false;
            }
            catch (UnexpectedResultException e) {
                this.handleUnexpectedResult(frame, iterator, item, e, eqNode, inliningTarget, errorProfile);
                continue;
            }
            break;
        }
    }

    private boolean sequenceContains(VirtualFrame frame, Object iterator, int item, PyObjectRichCompareBool.EqNode eqNode, Node inliningTarget, BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile) throws UnexpectedResultException {
        while (true) {
            try {
                while (this.getNext().executeInt(frame, iterator) != item) {
                }
                return true;
            }
            catch (PException e) {
                e.expectStopIteration(inliningTarget, errorProfile);
                return false;
            }
            catch (UnexpectedResultException e) {
                this.handleUnexpectedResult(frame, iterator, item, e, eqNode, inliningTarget, errorProfile);
                continue;
            }
            break;
        }
    }

    private boolean sequenceContains(VirtualFrame frame, Object iterator, long item, PyObjectRichCompareBool.EqNode eqNode, Node inliningTarget, BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile) throws UnexpectedResultException {
        while (true) {
            try {
                while (this.getNext().executeLong(frame, iterator) != item) {
                }
                return true;
            }
            catch (PException e) {
                e.expectStopIteration(inliningTarget, errorProfile);
                return false;
            }
            catch (UnexpectedResultException e) {
                this.handleUnexpectedResult(frame, iterator, item, e, eqNode, inliningTarget, errorProfile);
                continue;
            }
            break;
        }
    }

    private boolean sequenceContains(VirtualFrame frame, Object iterator, double item, PyObjectRichCompareBool.EqNode eqNode, Node inliningTarget, BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile) throws UnexpectedResultException {
        while (true) {
            try {
                while (this.getNext().executeDouble(frame, iterator) != item) {
                }
                return true;
            }
            catch (PException e) {
                e.expectStopIteration(inliningTarget, errorProfile);
                return false;
            }
            catch (UnexpectedResultException e) {
                this.handleUnexpectedResult(frame, iterator, item, e, eqNode, inliningTarget, errorProfile);
                continue;
            }
            break;
        }
    }

    private boolean sequenceContainsObject(VirtualFrame frame, Object iterator, Object item, PyObjectRichCompareBool.EqNode eqNode, Node inliningTarget, BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile) {
        try {
            while (!eqNode.compare((Frame)frame, inliningTarget, this.getNext().execute((Frame)frame, iterator), item)) {
            }
            return true;
        }
        catch (PException e) {
            e.expectStopIteration(inliningTarget, errorProfile);
            return false;
        }
    }

    private GetNextNode getNext() {
        if (this.next == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.next = (GetNextNode)this.insert(GetNextNode.create());
        }
        return this.next;
    }
}

