/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.exception;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.modules.io.IONodes;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.exception.ExceptionNodes;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectStrAsObjectNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.bytecode.PBytecodeRootNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.GetOrCreateDictNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaLongLossyNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.ExceptionUtils;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.exception.PythonExitException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;

public final class TopLevelExceptionHandler
extends RootNode {
    private final RootCallTarget innerCallTarget;
    private final PException exception;
    private final SourceSection sourceSection;
    private final Source source;
    @Node.Child
    private GilNode gilNode = GilNode.create();
    @Node.Child
    private Node instrumentationForwarder;

    public TopLevelExceptionHandler(PythonLanguage language, RootNode child, Source source) {
        super((TruffleLanguage)language);
        this.sourceSection = child.getSourceSection();
        this.innerCallTarget = PythonUtils.getOrCreateCallTarget(child);
        this.exception = null;
        this.source = source;
        if (child instanceof PBytecodeRootNode) {
            this.instrumentationForwarder = ((PBytecodeRootNode)child).createInstrumentationMaterializationForwarder();
        }
    }

    public TopLevelExceptionHandler(PythonLanguage language, PException exception) {
        super((TruffleLanguage)language);
        this.sourceSection = exception.getLocation().getEncapsulatingSourceSection();
        this.innerCallTarget = null;
        this.exception = exception;
        this.source = null;
    }

    private PythonLanguage getPythonLanguage() {
        return (PythonLanguage)this.getLanguage(PythonLanguage.class);
    }

    private PythonContext getContext() {
        return PythonContext.get((Node)this);
    }

    /*
     * Exception decompiling
     */
    public Object execute(VirtualFrame frame) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @CompilerDirectives.TruffleBoundary
    private void checkInitialized() {
        PythonContext core = this.getContext();
        if (core.isCoreInitialized() && "text/x-python".equals(this.source.getMimeType())) {
            this.getContext().initializeMainModule(PythonUtils.toTruffleStringUncached(this.source.getPath()));
        }
    }

    @CompilerDirectives.TruffleBoundary
    private PException handlePythonException(PException pException) {
        PBaseException managedException;
        Object pythonException = pException.getEscapedException();
        if (pythonException instanceof PBaseException && TopLevelExceptionHandler.isSystemExit(managedException = (PBaseException)pythonException)) {
            this.handleSystemExit(managedException);
        }
        if (this.getContext().getOption(PythonOptions.AlwaysRunExcepthook).booleanValue()) {
            Object type = GetClassNode.executeUncached(pythonException);
            Object tb = ExceptionNodes.GetTracebackNode.executeUncached(pythonException);
            PythonModule sys = this.getContext().lookupBuiltinModule(BuiltinNames.T_SYS);
            sys.setAttribute(BuiltinNames.T_LAST_TYPE, type);
            sys.setAttribute(BuiltinNames.T_LAST_VALUE, pythonException);
            sys.setAttribute(BuiltinNames.T_LAST_TRACEBACK, tb);
            ExceptionUtils.printExceptionTraceback(this.getContext(), pythonException);
            if (PythonOptions.isPExceptionWithJavaStacktrace(this.getPythonLanguage())) {
                ExceptionUtils.printJavaStackTrace(pException);
            }
            if (!this.getSourceSection().getSource().isInteractive()) {
                if (this.getContext().isChildContext()) {
                    this.getContext().getChildContextData().setExitCode(1);
                }
                throw new PythonExitException((Node)this, 1);
            }
        }
        if (pythonException instanceof PBaseException) {
            managedException = (PBaseException)pythonException;
            pException.setMessage(managedException.getFormattedMessage());
        }
        throw pException;
    }

    private static boolean isSystemExit(PBaseException pythonException) {
        return BuiltinClassProfiles.InlineIsBuiltinClassProfile.profileClassSlowPath(GetClassNode.GetPythonObjectClassNode.executeUncached(pythonException), PythonErrorType.SystemExit);
    }

    @CompilerDirectives.TruffleBoundary
    private void handleJavaException(Throwable e) {
        try {
            boolean exitException;
            boolean bl = exitException = InteropLibrary.getUncached().isException((Object)e) && InteropLibrary.getUncached().getExceptionType((Object)e) == ExceptionType.EXIT;
            if (!exitException) {
                ExceptionUtils.printPythonLikeStackTrace(this.getContext(), e);
                if (PythonOptions.isWithJavaStacktrace(this.getPythonLanguage())) {
                    e.printStackTrace();
                }
            }
        }
        catch (UnsupportedMessageException unsupportedMessageException) {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    public SourceSection getSourceSection() {
        return this.sourceSection;
    }

    @CompilerDirectives.TruffleBoundary
    private void handleSystemExit(PBaseException pythonException) {
        PythonContext theContext = this.getContext();
        if (theContext.getOption(PythonOptions.InspectFlag).booleanValue() && !this.getSourceSection().getSource().isInteractive()) {
            return;
        }
        try {
            int exitcode = TopLevelExceptionHandler.getExitCode(pythonException);
            throw new PythonExitException((Node)this, exitcode);
        }
        catch (CannotCastException cannotCastException) {
            if (TopLevelExceptionHandler.handleAlwaysRunExceptHook(theContext, pythonException)) {
                throw new PythonExitException((Node)this, 1);
            }
            throw pythonException.getExceptionForReraise(pythonException.getTraceback());
        }
    }

    @CompilerDirectives.TruffleBoundary
    private Object handleChildContextExit(PBaseException pythonException) throws PException {
        try {
            return TopLevelExceptionHandler.getExitCode(pythonException);
        }
        catch (CannotCastException cannotCastException) {
            if (TopLevelExceptionHandler.handleAlwaysRunExceptHook(this.getContext(), pythonException)) {
                return 1;
            }
            throw pythonException.getExceptionForReraise(pythonException.getTraceback());
        }
    }

    private static int getExitCode(PBaseException pythonException) throws CannotCastException {
        Object code;
        Object[] exceptionAttributes = pythonException.getExceptionAttributes();
        int exitcode = 0;
        if (exceptionAttributes != null && (code = exceptionAttributes[0]) != PNone.NONE) {
            exitcode = (int)CastToJavaLongLossyNode.executeUncached(code);
        }
        return exitcode;
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean handleAlwaysRunExceptHook(PythonContext theContext, PBaseException pythonException) {
        if (theContext.getOption(PythonOptions.AlwaysRunExcepthook).booleanValue()) {
            Object stderr = theContext.getStderr();
            Object message = PyObjectStrAsObjectNode.getUncached().execute(null, pythonException);
            PyObjectCallMethodObjArgs.executeUncached(stderr, IONodes.T_WRITE, message);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object run(VirtualFrame frame) {
        Object[] arguments = PArguments.create(frame.getArguments().length);
        for (int i = 0; i < frame.getArguments().length; ++i) {
            PArguments.setArgument(arguments, i, frame.getArguments()[i]);
        }
        PythonContext pythonContext = this.getContext();
        PythonModule mainModule = null;
        if (this.source.isInternal()) {
            PArguments.setGlobals(arguments, pythonContext.factory().createDict());
        } else {
            mainModule = pythonContext.getMainModule();
            PDict mainDict = GetOrCreateDictNode.executeUncached(mainModule);
            PArguments.setGlobals(arguments, mainModule);
            PArguments.setSpecialArgument(arguments, mainDict);
            PArguments.setException(arguments, PException.NO_EXCEPTION);
        }
        Object state = ExecutionContext.IndirectCalleeContext.enterIndirect(this.getPythonLanguage(), pythonContext, arguments);
        try {
            Object result = this.innerCallTarget.call(arguments);
            if (mainModule != null && result == PNone.NONE && !this.source.isInteractive()) {
                PythonModule pythonModule = mainModule;
                return pythonModule;
            }
            Object object = result;
            return object;
        }
        finally {
            ExecutionContext.IndirectCalleeContext.exit(this.getPythonLanguage(), pythonContext, state);
        }
    }

    public boolean isInternal() {
        return true;
    }
}

