/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.exception;

import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.exception.ExceptMatchNodeGen;
import com.oracle.graal.python.nodes.exception.ValidExceptionNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;

@ImportStatic(value={PGuards.class})
@GenerateUncached
public abstract class ExceptMatchNode
extends Node {
    public abstract boolean executeMatch(Frame var1, Object var2, Object var3);

    private static void raiseIfNoException(VirtualFrame frame, Object clause, ValidExceptionNode isValidException, PRaiseNode raiseNode) {
        if (!isValidException.execute((Frame)frame, clause)) {
            ExceptMatchNode.raiseNoException(raiseNode);
        }
    }

    private static void raiseNoException(PRaiseNode raiseNode) {
        throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.CATCHING_CLS_NOT_ALLOWED);
    }

    @Specialization(guards={"isClass(inliningTarget, clause, isTypeNode)"}, limit="1")
    static boolean matchPythonSingle(VirtualFrame frame, PException e, Object clause, @Bind(value="this") Node inliningTarget, @Cached TypeNodes.IsTypeNode isTypeNode, @Cached.Shared @Cached ValidExceptionNode isValidException, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtype, @Cached.Shared @Cached PRaiseNode raiseNode) {
        ExceptMatchNode.raiseIfNoException(frame, clause, isValidException, raiseNode);
        return isSubtype.execute(frame, getClassNode.execute(inliningTarget, e.getUnreifiedException()), clause);
    }

    @Specialization(guards={"eLib.isException(e)", "clauseLib.isMetaObject(clause)"}, limit="3", replaces={"matchPythonSingle"})
    static boolean matchJava(VirtualFrame frame, AbstractTruffleException e, Object clause, @Cached.Shared @Cached ValidExceptionNode isValidException, @CachedLibrary(value="e") InteropLibrary eLib, @CachedLibrary(value="clause") InteropLibrary clauseLib, @Cached.Shared @Cached PRaiseNode raiseNode) {
        ExceptMatchNode.raiseIfNoException(frame, clause, isValidException, raiseNode);
        try {
            return clauseLib.isMetaInstance(clause, (Object)e);
        }
        catch (UnsupportedMessageException e1) {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @Specialization
    static boolean matchTuple(VirtualFrame frame, Object e, PTuple clause, @Bind(value="this") Node inliningTarget, @Cached ExceptMatchNode recursiveNode, @Cached SequenceStorageNodes.GetItemScalarNode getItemNode) {
        SequenceStorage storage = clause.getSequenceStorage();
        int length = storage.length();
        for (int i = 0; i < length; ++i) {
            Object clauseType = getItemNode.execute(inliningTarget, storage, i);
            if (!recursiveNode.executeMatch((Frame)frame, e, clauseType)) continue;
            return true;
        }
        return false;
    }

    @Fallback
    static boolean fallback(VirtualFrame frame, Object e, Object clause, @Cached.Shared @Cached PRaiseNode raiseNode) {
        ExceptMatchNode.raiseNoException(raiseNode);
        return false;
    }

    @NeverDefault
    public static ExceptMatchNode create() {
        return ExceptMatchNodeGen.create();
    }

    public static ExceptMatchNode getUncached() {
        return ExceptMatchNodeGen.getUncached();
    }
}

