/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.call;

import com.oracle.graal.python.nodes.call.InvokeNode;
import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.nodes.Node;

abstract class DirectInvokeNode
extends InvokeNode {
    @CompilerDirectives.CompilationFinal
    private Assumption dontNeedExceptionState = DirectInvokeNode.createExceptionStateAssumption();
    @CompilerDirectives.CompilationFinal
    private Assumption dontNeedCallerFrame = DirectInvokeNode.createCallerFrameAssumption();
    @CompilerDirectives.CompilationFinal
    private int state = 0;

    DirectInvokeNode() {
    }

    private static Assumption createCallerFrameAssumption() {
        return Truffle.getRuntime().createAssumption("does not need caller frame");
    }

    private static Assumption createExceptionStateAssumption() {
        return Truffle.getRuntime().createAssumption("does not need exception state");
    }

    @Override
    public Assumption needNotPassFrameAssumption() {
        return this.dontNeedCallerFrame;
    }

    @Override
    public Assumption needNotPassExceptionAssumption() {
        return this.dontNeedExceptionState;
    }

    protected boolean profileIsNullFrame(boolean isNullFrame) {
        if (this.state == 0) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.state = isNullFrame ? 1 : 2;
        }
        if (this.state == 1) {
            if (!isNullFrame) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException("Invoke node was initialized for a null frame. Cannot use it with non-null frame now.");
            }
            return true;
        }
        assert (this.state == 2);
        if (isNullFrame) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException("Invoke node was initialized for a non-null frame. Cannot use it with null frame now.");
        }
        return false;
    }

    public Node copy() {
        DirectInvokeNode copy = (DirectInvokeNode)super.copy();
        copy.dontNeedCallerFrame = DirectInvokeNode.createCallerFrameAssumption();
        copy.dontNeedExceptionState = DirectInvokeNode.createExceptionStateAssumption();
        return copy;
    }
}

