/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.nodes.PRootNode;
import com.oracle.graal.python.nodes.bytecode.OSRInterpreterState;
import com.oracle.graal.python.nodes.bytecode.PBytecodeRootNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.BytecodeOSRNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;

public class PBytecodeGeneratorRootNode
extends PRootNode
implements BytecodeOSRNode {
    private final PBytecodeRootNode rootNode;
    private final int resumeBci;
    private final int resumeStackTop;
    @Node.Child
    private ExecutionContext.CalleeContext calleeContext = ExecutionContext.CalleeContext.create();
    @CompilerDirectives.CompilationFinal
    private Object osrMetadata;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private byte[] frameSlotTypes;

    @CompilerDirectives.TruffleBoundary
    public PBytecodeGeneratorRootNode(PythonLanguage language, PBytecodeRootNode rootNode, int resumeBci, int resumeStackTop) {
        super(language, rootNode.getFrameDescriptor());
        this.rootNode = rootNode;
        rootNode.adoptChildren();
        this.resumeBci = resumeBci;
        this.resumeStackTop = resumeStackTop;
        this.frameSlotTypes = new byte[resumeStackTop - rootNode.stackoffset + 1];
    }

    /*
     * Enabled aggressive block sorting
     */
    @ExplodeLoop
    private void copyStackSlotsIntoVirtualFrame(MaterializedFrame generatorFrame, VirtualFrame virtualFrame) {
        int offset = this.rootNode.stackoffset;
        int i = 0;
        while (true) {
            block18: {
                if (i >= this.frameSlotTypes.length) {
                    return;
                }
                int frameIndex = i + offset;
                switch (this.frameSlotTypes[i]) {
                    case 1: {
                        if (!generatorFrame.isObject(frameIndex)) break;
                        virtualFrame.setObject(frameIndex, generatorFrame.getObject(frameIndex));
                        break block18;
                    }
                    case 2: {
                        if (!generatorFrame.isInt(frameIndex)) break;
                        virtualFrame.setInt(frameIndex, generatorFrame.getInt(frameIndex));
                        break block18;
                    }
                    case 4: {
                        if (!generatorFrame.isLong(frameIndex)) break;
                        virtualFrame.setLong(frameIndex, generatorFrame.getLong(frameIndex));
                        break block18;
                    }
                    case 8: {
                        if (!generatorFrame.isDouble(frameIndex)) break;
                        virtualFrame.setDouble(frameIndex, generatorFrame.getDouble(frameIndex));
                        break block18;
                    }
                    case 16: {
                        if (!generatorFrame.isBoolean(frameIndex)) break;
                        virtualFrame.setBoolean(frameIndex, generatorFrame.getBoolean(frameIndex));
                        break block18;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                if (generatorFrame.isObject(frameIndex)) {
                    virtualFrame.setObject(frameIndex, generatorFrame.getObject(frameIndex));
                    this.frameSlotTypes[i] = 1;
                } else if (generatorFrame.isInt(frameIndex)) {
                    virtualFrame.setInt(frameIndex, generatorFrame.getInt(frameIndex));
                    this.frameSlotTypes[i] = 2;
                } else if (generatorFrame.isLong(frameIndex)) {
                    virtualFrame.setLong(frameIndex, generatorFrame.getLong(frameIndex));
                    this.frameSlotTypes[i] = 4;
                } else if (generatorFrame.isDouble(frameIndex)) {
                    virtualFrame.setDouble(frameIndex, generatorFrame.getDouble(frameIndex));
                    this.frameSlotTypes[i] = 8;
                } else {
                    if (!generatorFrame.isBoolean(frameIndex)) {
                        throw new IllegalStateException("unexpected frame slot type");
                    }
                    virtualFrame.setBoolean(frameIndex, generatorFrame.getBoolean(frameIndex));
                    this.frameSlotTypes[i] = 16;
                }
            }
            ++i;
        }
    }

    public Object executeOSR(VirtualFrame osrFrame, int target, Object interpreterStateObject) {
        OSRInterpreterState interpreterState = (OSRInterpreterState)interpreterStateObject;
        MaterializedFrame generatorFrame = PArguments.getGeneratorFrame((Frame)osrFrame);
        return this.rootNode.executeFromBci(osrFrame, (Frame)generatorFrame, this, target, interpreterState.stackTop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(VirtualFrame frame) {
        this.calleeContext.enter(frame);
        MaterializedFrame generatorFrame = PArguments.getGeneratorFrame((Frame)frame);
        this.copyStackSlotsIntoVirtualFrame(generatorFrame, frame);
        try {
            Object object = this.rootNode.executeFromBci(frame, (Frame)generatorFrame, this, this.resumeBci, this.resumeStackTop);
            return object;
        }
        finally {
            this.calleeContext.exit(frame, this);
        }
    }

    public Object getOSRMetadata() {
        return this.osrMetadata;
    }

    public void setOSRMetadata(Object osrMetadata) {
        this.osrMetadata = osrMetadata;
    }

    public Object[] storeParentFrameInArguments(VirtualFrame parentFrame) {
        return this.rootNode.storeParentFrameInArguments(parentFrame);
    }

    public Frame restoreParentFrameFromArguments(Object[] arguments) {
        return this.rootNode.restoreParentFrameFromArguments(arguments);
    }

    public String getName() {
        return this.rootNode.getName();
    }

    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        return "<bytecode " + this.rootNode.getName() + " (generator resume bci=" + this.resumeBci + ")>";
    }

    @Override
    public boolean setsUpCalleeContext() {
        return true;
    }

    @Override
    public Signature getSignature() {
        return this.rootNode.getSignature();
    }

    @Override
    public boolean isPythonInternal() {
        return this.rootNode.isPythonInternal();
    }

    public SourceSection getSourceSection() {
        return this.rootNode.getSourceSection();
    }

    public int getResumeBci() {
        return this.resumeBci;
    }

    public int getResumeStackTop() {
        return this.resumeStackTop;
    }

    public PBytecodeRootNode getBytecodeRootNode() {
        return this.rootNode;
    }
}

