/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.attributes;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.nodes.attributes.ObjectAttributeNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToObjectNode;
import com.oracle.graal.python.nodes.object.GetDictIfExistsNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateInline(value=false)
public abstract class WriteAttributeToBuiltinTypeNode
extends ObjectAttributeNode {
    public abstract void execute(Object var1, TruffleString var2, Object var3);

    protected static boolean isAttrWritable(PythonBuiltinClass self) {
        return (self.getShape().getFlags() & 2) == 0;
    }

    @Specialization(guards={"isAttrWritable(klass)", "getDict.execute(klass) == null"})
    static void writeToDynamicStorage(PythonBuiltinClass klass, TruffleString key, Object value, @Cached.Shared(value="getDict") @Cached GetDictIfExistsNode getDict, @CachedLibrary(limit="getAttributeAccessInlineCacheMaxDepth()") DynamicObjectLibrary dylib) {
        dylib.put((DynamicObject)klass, (Object)key, value);
    }

    @Specialization(guards={"dict != null"})
    static void writeToDictNoType(PythonBuiltinClass klass, TruffleString key, Object value, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getDict") @Cached GetDictIfExistsNode getDict, @Bind(value="getDict.execute(klass)") PDict dict, @Cached InlinedBranchProfile updateStorage, @Cached HashingStorageNodes.HashingStorageSetItem setHashingStorageItem) {
        WriteAttributeToObjectNode.writeToDict(dict, key, value, inliningTarget, updateStorage, setHashingStorageItem);
    }

    @Specialization
    static void doPBCT(PythonBuiltinClassType object, TruffleString key, Object value, @Cached WriteAttributeToBuiltinTypeNode recursive) {
        recursive.execute(PythonContext.get(recursive).lookupType(object), key, value);
    }
}

