/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNodeGen;
import com.oracle.graal.python.nodes.truffle.TruffleStringMigrationHelpers;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

@ImportStatic(value={PGuards.class})
@GenerateUncached
public abstract class PRaiseNode
extends Node {
    public final PException execute(Node raisingNode, PythonBuiltinClassType type, Object cause, Object format, Object[] arguments) {
        return this.execute(raisingNode, type, null, cause, format, arguments);
    }

    public abstract PException execute(Node var1, PythonBuiltinClassType var2, Object[] var3, Object var4, Object var5, Object[] var6);

    public final PException raise(PythonBuiltinClassType type) {
        throw this.execute(this, type, null, PNone.NO_VALUE, PNone.NO_VALUE, PythonUtils.EMPTY_OBJECT_ARRAY);
    }

    public final PException raise(PythonBuiltinClassType type, TruffleString message) {
        throw this.execute(this, type, null, PNone.NO_VALUE, message, PythonUtils.EMPTY_OBJECT_ARRAY);
    }

    public final PException raise(PythonBuiltinClassType type, TruffleString format, Object ... arguments) {
        throw this.execute(this, type, null, PNone.NO_VALUE, format, arguments);
    }

    public final PException raise(PythonBuiltinClassType type, Object[] arguments) {
        throw this.execute(this, type, null, PNone.NO_VALUE, PNone.NO_VALUE, arguments);
    }

    public final PException raiseWithData(PythonBuiltinClassType type, Object[] data, Object ... arguments) {
        throw this.execute(this, type, data, PNone.NO_VALUE, PNone.NO_VALUE, arguments);
    }

    public final PException raise(PythonBuiltinClassType type, Exception e) {
        throw this.execute(this, type, null, PNone.NO_VALUE, PRaiseNode.getMessage(e), PythonUtils.EMPTY_OBJECT_ARRAY);
    }

    public final PException raiseWithCause(PythonBuiltinClassType type, Object cause, TruffleString format, Object ... arguments) {
        throw this.execute(this, type, null, cause, format, arguments);
    }

    public final PException raiseWithCause(PythonBuiltinClassType errorType, PException e, TruffleString message, Object ... arguments) {
        return this.raiseWithCause(errorType, e.getEscapedException(), message, arguments);
    }

    public static PException raiseUncached(Node raisingNode, PythonBuiltinClassType exceptionType) {
        throw PRaiseNodeGen.getUncached().execute(raisingNode, exceptionType, null, PNone.NO_VALUE, PNone.NO_VALUE, PythonUtils.EMPTY_OBJECT_ARRAY);
    }

    public static PException raiseUncached(Node raisingNode, PythonBuiltinClassType exceptionType, TruffleString message) {
        throw PRaiseNodeGen.getUncached().execute(raisingNode, exceptionType, null, PNone.NO_VALUE, TruffleStringMigrationHelpers.assertNoJavaString(message), PythonUtils.EMPTY_OBJECT_ARRAY);
    }

    public static PException raiseUncached(Node raisingNode, PythonBuiltinClassType type, TruffleString format, Object ... arguments) {
        throw PRaiseNodeGen.getUncached().execute(raisingNode, type, null, PNone.NO_VALUE, format, arguments);
    }

    public static PException raiseUncached(Node raisingNode, PythonBuiltinClassType type, Exception e) {
        throw PRaiseNodeGen.getUncached().execute(raisingNode, type, null, PNone.NO_VALUE, PRaiseNode.getMessage(e), PythonUtils.EMPTY_OBJECT_ARRAY);
    }

    public final PException raiseNumberTooLarge(PythonBuiltinClassType type, Object result) {
        return this.execute(this, type, null, PNone.NO_VALUE, ErrorMessages.CANNOT_FIT_P_INTO_INDEXSIZED_INT, new Object[]{result});
    }

    public final PException raiseSystemExit(Object code) {
        return this.raiseWithData(PythonBuiltinClassType.SystemExit, new Object[]{code}, code);
    }

    public final PException raiseStopIteration() {
        return this.raise(PythonBuiltinClassType.StopIteration);
    }

    public final PException raiseStopIteration(Object value) {
        Object retVal = value != null ? value : PNone.NONE;
        Object[] args = new Object[]{retVal};
        return this.raiseWithData(PythonBuiltinClassType.StopIteration, args, retVal);
    }

    public final PException raiseHasNoLength(Object result) {
        return this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_HAS_NO_LEN, result);
    }

    public final PException raiseIntegerInterpretationError(Object result) {
        return this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_CANNOT_BE_INTERPRETED_AS_INTEGER, result);
    }

    public final PException raiseBadInternalCall() {
        return this.raise(PythonBuiltinClassType.SystemError, ErrorMessages.BAD_ARG_TO_INTERNAL_FUNC);
    }

    public final PException raiseMemoryError() {
        return this.raise(PythonBuiltinClassType.MemoryError);
    }

    public final PException raiseExceptionObject(Object exc) {
        throw PRaiseNode.raiseExceptionObject(this, exc, PythonOptions.isPExceptionWithJavaStacktrace(PythonLanguage.get(this)));
    }

    public static PException raiseExceptionObject(Node raisingNode, Object exc) {
        throw PRaiseNode.raiseExceptionObject(raisingNode, exc, PythonOptions.isPExceptionWithJavaStacktrace(PythonLanguage.get(raisingNode)));
    }

    public static PException raiseExceptionObject(Node raisingNode, Object exc, boolean withJavaStacktrace) {
        if (raisingNode != null && raisingNode.isAdoptable()) {
            throw PException.fromObject(exc, raisingNode, withJavaStacktrace);
        }
        throw PException.fromObject(exc, EncapsulatingNodeReference.getCurrent().get(), withJavaStacktrace);
    }

    @Specialization(guards={"isNoValue(cause)", "isNoValue(format)", "arguments.length == 0", "exceptionType == cachedType"}, limit="8")
    static PException doPythonBuiltinTypeCached(Node raisingNode, PythonBuiltinClassType exceptionType, Object[] data, PNone cause, PNone format, Object[] arguments, @Cached(value="exceptionType") PythonBuiltinClassType cachedType, @Cached.Shared(value="factory") @Cached PythonObjectFactory factory) {
        throw PRaiseNode.raiseExceptionObject(raisingNode, factory.createBaseException((Object)cachedType, data));
    }

    @Specialization(guards={"isNoValue(cause)", "isNoValue(format)", "arguments.length == 0"}, replaces={"doPythonBuiltinTypeCached"})
    static PException doPythonBuiltinType(Node raisingNode, PythonBuiltinClassType exceptionType, Object[] data, PNone cause, PNone format, Object[] arguments, @Cached.Shared(value="factory") @Cached PythonObjectFactory factory) {
        throw PRaiseNode.raiseExceptionObject(raisingNode, factory.createBaseException((Object)exceptionType, data));
    }

    @Specialization(guards={"isNoValue(cause)", "isNoValue(format)", "arguments.length > 0"})
    static PException doBuiltinType(Node raisingNode, PythonBuiltinClassType type, Object[] data, PNone cause, PNone format, Object[] arguments, @Cached.Shared(value="factory") @Cached PythonObjectFactory factory, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
        PRaiseNode.ensureNoJavaStrings(arguments, fromJavaStringNode);
        throw PRaiseNode.raiseExceptionObject(raisingNode, factory.createBaseException((Object)type, data, factory.createTuple(arguments)));
    }

    @Specialization(guards={"isNoValue(cause)"})
    static PException doBuiltinType(Node raisingNode, PythonBuiltinClassType type, Object[] data, PNone cause, TruffleString format, Object[] arguments, @Cached.Shared(value="factory") @Cached PythonObjectFactory factory, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
        assert (format != null);
        PRaiseNode.ensureNoJavaStrings(arguments, fromJavaStringNode);
        throw PRaiseNode.raiseExceptionObject(raisingNode, factory.createBaseException((Object)type, data, format, arguments));
    }

    @Specialization(guards={"!isNoValue(cause)"})
    static PException doBuiltinTypeWithCause(Node raisingNode, PythonBuiltinClassType type, Object[] data, PBaseException cause, TruffleString format, Object[] arguments, @Cached.Shared(value="factory") @Cached PythonObjectFactory factory, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
        assert (format != null);
        PRaiseNode.ensureNoJavaStrings(arguments, fromJavaStringNode);
        PBaseException baseException = factory.createBaseException((Object)type, data, format, arguments);
        baseException.setContext(cause);
        baseException.setCause(cause);
        throw PRaiseNode.raiseExceptionObject(raisingNode, baseException);
    }

    @CompilerDirectives.TruffleBoundary
    private static TruffleString getMessage(Exception e) {
        String msg = e.getMessage();
        return PythonUtils.toTruffleStringUncached(msg != null ? msg : e.getClass().getSimpleName());
    }

    @NeverDefault
    public static PRaiseNode create() {
        return PRaiseNodeGen.create();
    }

    public static PRaiseNode getUncached() {
        return PRaiseNodeGen.getUncached();
    }

    private static void ensureNoJavaStrings(Object[] arguments, TruffleString.FromJavaStringNode fromJavaStringNode) {
        for (int i = 0; i < arguments.length; ++i) {
            if (!(arguments[i] instanceof String)) continue;
            arguments[i] = fromJavaStringNode.execute((String)arguments[i], PythonUtils.TS_ENCODING);
        }
    }

    @GenerateInline
    @GenerateUncached
    @GenerateCached(value=false)
    public static abstract class Lazy
    extends Node {
        public static Lazy getUncached() {
            return PRaiseNodeGen.LazyNodeGen.getUncached();
        }

        public final PRaiseNode get(Node inliningTarget) {
            return this.execute(inliningTarget);
        }

        abstract PRaiseNode execute(Node var1);

        @Specialization
        static PRaiseNode doIt(@Cached(inline=false) PRaiseNode node) {
            return node;
        }
    }
}

