/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.list.ListBuiltins;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.lib.PyObjectSetItemNodeGen;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.special.CallTernaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodSlotNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateInline(inlineByDefault=true)
@GenerateCached
@ImportStatic(value={SpecialMethodSlot.class, PGuards.class})
public abstract class PyObjectSetItem
extends Node {
    public static void executeUncached(Frame frame, Object container, Object index, Object value) {
        PyObjectSetItemNodeGen.getUncached().execute(frame, null, container, index, value);
    }

    public static void executeUncached(Object container, Object index, Object value) {
        PyObjectSetItemNodeGen.getUncached().execute(null, null, container, index, value);
    }

    public final void executeCached(Frame frame, Object container, Object index, Object item) {
        this.execute(frame, this, container, index, item);
    }

    public abstract void execute(Frame var1, Node var2, Object var3, Object var4, Object var5);

    @Specialization(guards={"cannotBeOverriddenForImmutableType(object)"})
    static void doList(VirtualFrame frame, PList object, Object key, Object value, @Cached(inline=false) ListBuiltins.SetItemNode setItemNode) {
        setItemNode.execute(frame, object, key, value);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(replaces={"doList"})
    static void doWithFrame(Frame frame, Node inliningTarget, Object primary, Object index, Object value, @Cached GetClassNode getClassNode, @Cached(parameters={"SetItem"}, inline=false) LookupSpecialMethodSlotNode lookupSetitem, @Cached PRaiseNode.Lazy raise, @Cached(inline=false) CallTernaryMethodNode callSetitem) {
        Object setitem = lookupSetitem.execute(frame, getClassNode.execute(inliningTarget, primary), primary);
        if (setitem == PNone.NO_VALUE) {
            throw raise.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.P_OBJ_DOES_NOT_SUPPORT_ITEM_ASSIGMENT, primary);
        }
        callSetitem.execute(frame, setitem, primary, index, value);
    }

    @NeverDefault
    public static PyObjectSetItem create() {
        return PyObjectSetItemNodeGen.create();
    }

    public static PyObjectSetItem getUncached() {
        return PyObjectSetItemNodeGen.getUncached();
    }
}

