/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.object.ObjectNodes;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.lib.PyObjectReprAsObjectNodeGen;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodSlotNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.truffle.TruffleStringMigrationHelpers;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateCached
@GenerateInline(inlineByDefault=true)
@ImportStatic(value={SpecialMethodSlot.class})
public abstract class PyObjectReprAsObjectNode
extends PNodeWithContext {
    public static Object executeUncached(Object object) {
        return PyObjectReprAsObjectNodeGen.getUncached().execute(null, null, object);
    }

    public static PyObjectReprAsObjectNode getUncached() {
        return PyObjectReprAsObjectNodeGen.getUncached();
    }

    public final Object executeCached(Frame frame, Object object) {
        return this.execute(frame, this, object);
    }

    public abstract Object execute(Frame var1, Node var2, Object var3);

    @Specialization
    static Object repr(VirtualFrame frame, Node inliningTarget, Object obj, @Cached GetClassNode getClassNode, @Cached(parameters={"Repr"}, inline=false) LookupSpecialMethodSlotNode lookupRepr, @Cached(inline=false) CallUnaryMethodNode callRepr, @Cached(inline=false) ObjectNodes.DefaultObjectReprNode defaultRepr, @Cached InlinedConditionProfile isString, @Cached InlinedConditionProfile isPString, @Cached PRaiseNode.Lazy raiseNode) {
        Object reprMethod;
        Object type = getClassNode.execute(inliningTarget, obj);
        try {
            reprMethod = lookupRepr.execute((Frame)frame, type, obj);
        }
        catch (PException e) {
            return defaultRepr.execute((Frame)frame, inliningTarget, obj);
        }
        if (reprMethod != PNone.NO_VALUE) {
            Object result = callRepr.executeObject((Frame)frame, reprMethod, obj);
            if (isString.profile(inliningTarget, (result = TruffleStringMigrationHelpers.assertNoJavaString(result)) instanceof TruffleString) || isPString.profile(inliningTarget, result instanceof PString)) {
                return result;
            }
            if (result != PNone.NO_VALUE) {
                throw PyObjectReprAsObjectNode.raiseTypeError(inliningTarget, obj, raiseNode);
            }
        }
        return defaultRepr.execute((Frame)frame, inliningTarget, obj);
    }

    @HostCompilerDirectives.InliningCutoff
    private static PException raiseTypeError(Node inliningTarget, Object obj, PRaiseNode.Lazy raiseNode) {
        throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.RETURNED_NON_STRING, SpecialMethodNames.T___REPR__, obj);
    }

    @NeverDefault
    public static PyObjectReprAsObjectNode create() {
        return PyObjectReprAsObjectNodeGen.create();
    }
}

