/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.MathModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.lib.PyObjectHashNodeGen;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.attributes.LookupCallableSlotInMRONode;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.call.special.MaybeBindDescriptorNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.nodes.util.CastUnsignedToJavaLongHashNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

@ImportStatic(value={SpecialMethodSlot.class})
@GenerateUncached
@GenerateCached(value=false)
@GenerateInline
public abstract class PyObjectHashNode
extends PNodeWithContext {
    public static long executeUncached(Object value) {
        return PyObjectHashNodeGen.getUncached().execute(null, null, value);
    }

    public abstract long execute(Frame var1, Node var2, Object var3);

    public abstract long execute(Frame var1, Node var2, TruffleString var3);

    private static long avoidNegative1(long hash) {
        return hash == -1L ? -2L : hash;
    }

    @Specialization
    @HostCompilerDirectives.InliningCutoff
    public static long hash(TruffleString object, @Cached.Shared @Cached(inline=false) TruffleString.HashCodeNode hashCodeNode) {
        return PyObjectHashNode.avoidNegative1(hashCodeNode.execute((AbstractTruffleString)object, PythonUtils.TS_ENCODING));
    }

    @Specialization(guards={"cannotBeOverridden(object, inliningTarget, getClassNode)"}, limit="1")
    @HostCompilerDirectives.InliningCutoff
    static long hash(Node inliningTarget, PString object, @Cached GetClassNode.GetPythonObjectClassNode getClassNode, @Cached CastToTruffleStringNode cast, @Cached.Shared @Cached(inline=false) TruffleString.HashCodeNode hashCodeNode) {
        return PyObjectHashNode.hash(cast.execute(inliningTarget, object), hashCodeNode);
    }

    @Specialization
    public static long hash(boolean object) {
        return object ? 1L : 0L;
    }

    @Specialization
    public static long hash(int object) {
        return PyObjectHashNode.avoidNegative1(object);
    }

    @Specialization
    public static long hash(long object) {
        long h = object % 0x1FFFFFFFFFFFFFFFL;
        return PyObjectHashNode.avoidNegative1(h);
    }

    @Specialization
    public static long hash(double object) {
        if (!Double.isFinite(object)) {
            if (Double.isInfinite(object)) {
                return object > 0.0 ? 314159L : -314159L;
            }
            return 0L;
        }
        double[] frexpRes = MathModuleBuiltins.FrexpNode.frexp(object);
        double m = frexpRes[0];
        int e = (int)frexpRes[1];
        int sign = 1;
        if (m < 0.0) {
            sign = -1;
            m = -m;
        }
        long x = 0L;
        while (m != 0.0) {
            x = x << 28 & 0x1FFFFFFFFFFFFFFFL | x >> 33;
            e -= 28;
            long y = (long)(m *= 2.68435456E8);
            m -= (double)y;
            if ((x += y) < 0x1FFFFFFFFFFFFFFFL) continue;
            x -= 0x1FFFFFFFFFFFFFFFL;
        }
        e = e >= 0 ? e % 61 : 60 - (-1 - e) % 61;
        x = x << e & 0x1FFFFFFFFFFFFFFFL | x >> 61 - e;
        return PyObjectHashNode.avoidNegative1(x *= (long)sign);
    }

    @HostCompilerDirectives.InliningCutoff
    @Fallback
    static long hash(VirtualFrame frame, Node inliningTarget, Object object, @Cached GetClassNode getClassNode, @Cached(parameters={"Hash"}, inline=false) LookupCallableSlotInMRONode lookupHash, @Cached MaybeBindDescriptorNode bindDescriptorNode, @Cached(inline=false) CallUnaryMethodNode callHash, @Cached CastUnsignedToJavaLongHashNode cast, @Cached PRaiseNode.Lazy raiseNode) {
        Object type = getClassNode.execute(inliningTarget, object);
        Object hashDescr = lookupHash.execute(type);
        if (hashDescr != PNone.NO_VALUE && hashDescr != PNone.NONE) {
            try {
                hashDescr = bindDescriptorNode.execute((Frame)frame, inliningTarget, hashDescr, object, type);
            }
            catch (PException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.UNHASHABLE_TYPE_P, object);
            }
            Object result = callHash.executeObject((Frame)frame, hashDescr, object);
            try {
                return PyObjectHashNode.avoidNegative1(cast.execute(inliningTarget, result));
            }
            catch (CannotCastException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.HASH_SHOULD_RETURN_INTEGER);
            }
        }
        throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.UNHASHABLE_TYPE_P, object);
    }

    public static PyObjectHashNode getUncached() {
        return PyObjectHashNodeGen.getUncached();
    }
}

