/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.attributes.LookupCallableSlotInMRONode;
import com.oracle.graal.python.nodes.call.special.CallBinaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallBinaryNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateInline
@GenerateUncached
public abstract class PyObjectFormat
extends PNodeWithContext {
    public final Object executeNonInlined(VirtualFrame frame, Object obj, Object formatSpec) {
        return this.execute(frame, null, obj, formatSpec);
    }

    public abstract Object execute(VirtualFrame var1, Node var2, Object var3, Object var4);

    @Specialization
    static Object doNone(VirtualFrame frame, Node inliningTarget, Object obj, PNone formatSpec, @Cached.Shared(value="impl") @Cached PyObjectFormatStr formatStr) {
        return formatStr.execute((Frame)frame, inliningTarget, obj, StringLiterals.T_EMPTY_STRING);
    }

    @Fallback
    static Object doOthers(VirtualFrame frame, Node inliningTarget, Object obj, Object formatSpec, @Cached.Shared(value="impl") @Cached PyObjectFormatStr formatStr) {
        return formatStr.execute((Frame)frame, inliningTarget, obj, formatSpec);
    }

    @GenerateInline
    @GenerateUncached
    @GenerateCached(value=false)
    public static abstract class PyObjectFormatStr
    extends PNodeWithContext {
        public abstract Object execute(Frame var1, Node var2, Object var3, Object var4);

        static boolean isEmptyString(Object formatSpec) {
            return formatSpec instanceof TruffleString && ((TruffleString)formatSpec).isEmpty();
        }

        @Specialization(guards={"isString(obj)", "isEmptyString(formatSpec)"})
        static Object doString(Object obj, Object formatSpec) {
            return obj;
        }

        @Specialization(guards={"isEmptyString(formatSpec)"})
        static Object doLong(long obj, Object formatSpec) {
            return obj;
        }

        @Specialization(guards={"isString(formatSpec)"})
        static Object doGeneric(VirtualFrame frame, Object obj, Object formatSpec, @Cached(parameters={"Format"}, inline=false) LookupAndCallBinaryNode callFormat, @Cached.Exclusive @Cached(inline=false) PRaiseNode raiseNode) {
            Object res = callFormat.executeObject(frame, obj, formatSpec);
            if (res == PNone.NO_VALUE) {
                throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.TYPE_DOESNT_DEFINE_FORMAT, obj);
            }
            if (!PGuards.isString(res)) {
                throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.S_MUST_RETURN_S_NOT_P, SpecialMethodNames.T___FORMAT__, "str", res);
            }
            return res;
        }

        @Specialization(guards={"isString(formatSpec)"}, replaces={"doGeneric"})
        static Object doGenericUncached(VirtualFrame frame, Object obj, Object formatSpec) {
            PythonUtils.assertUncached();
            Object klass = GetClassNode.executeUncached(obj);
            Object slot = LookupCallableSlotInMRONode.getUncached(SpecialMethodSlot.Format).execute(klass);
            return CallBinaryMethodNode.getUncached().executeObject((Frame)frame, slot, obj, formatSpec);
        }

        @Fallback
        static Object doNonStringFormat(Object obj, Object formatSpec, @Cached.Exclusive @Cached(inline=false) PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.S_MUST_BE_S_NOT_P, "Format specifier", "string", formatSpec);
        }
    }
}

