/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.WarningsModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.lib.PyFloatFromString;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodSlotNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CastToJavaDoubleNode;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
@ImportStatic(value={SpecialMethodSlot.class})
public abstract class PyNumberFloatNode
extends PNodeWithContext {
    public abstract double execute(Frame var1, Node var2, Object var3);

    public final double execute(Node inliningTarget, Object object) {
        return this.execute(null, inliningTarget, object);
    }

    @Specialization
    static double doDouble(double object) {
        return object;
    }

    @Specialization
    static double doInt(int object) {
        return object;
    }

    @Specialization
    static double doLong(long object) {
        return object;
    }

    @Specialization
    static double doBoolean(boolean object) {
        return object ? 1.0 : 0.0;
    }

    @Specialization(guards={"!isDouble(object)", "!isInteger(object)", "!isBoolean(object)"})
    @HostCompilerDirectives.InliningCutoff
    static double doObject(VirtualFrame frame, Node inliningTarget, Object object, @Cached GetClassNode getClassNode, @Cached(parameters={"Float"}, inline=false) LookupSpecialMethodSlotNode lookup, @Cached(inline=false) CallUnaryMethodNode call, @Cached GetClassNode resultClassNode, @Cached BuiltinClassProfiles.InlineIsBuiltinClassProfile resultProfile, @Cached(inline=false) IsSubtypeNode resultSubtypeNode, @Cached PyIndexCheckNode indexCheckNode, @Cached PyNumberIndexNode indexNode, @Cached CastToJavaDoubleNode cast, @Cached(inline=false) WarningsModuleBuiltins.WarnNode warnNode, @Cached PRaiseNode.Lazy raiseNode, @Cached PyFloatFromString fromString) {
        Object floatDescr = lookup.execute((Frame)frame, getClassNode.execute(inliningTarget, object), object);
        if (floatDescr != PNone.NO_VALUE) {
            Object result = call.executeObject((Frame)frame, floatDescr, object);
            Object resultType = resultClassNode.execute(inliningTarget, result);
            if (!resultProfile.profileClass(inliningTarget, resultType, PythonBuiltinClassType.PFloat)) {
                if (!resultSubtypeNode.execute(resultType, (Object)PythonBuiltinClassType.PFloat)) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.RETURNED_NON_FLOAT, object, result);
                }
                warnNode.warnFormat((Frame)frame, null, (Object)PythonBuiltinClassType.DeprecationWarning, 1, ErrorMessages.WARN_P_RETURNED_NON_P, object, SpecialMethodNames.T___FLOAT__, "float", result, "float");
            }
            return cast.execute(inliningTarget, result);
        }
        if (indexCheckNode.execute(inliningTarget, object)) {
            Object index = indexNode.execute((Frame)frame, inliningTarget, object);
            return cast.execute(inliningTarget, index);
        }
        return fromString.execute((Frame)frame, inliningTarget, object);
    }
}

