/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.HiddenKey;

@GenerateUncached
@GenerateInline(inlineByDefault=true)
public abstract class GetMethodsFlagsNode
extends Node {
    public static final HiddenKey METHODS_FLAGS = new HiddenKey("__methods_flags__");

    public abstract long execute(Node var1, Object var2);

    @Specialization
    protected static long pythonbuiltinclasstype(PythonManagedClass cls) {
        return cls.getMethodsFlags();
    }

    @Specialization
    protected static long pythonclasstype(PythonBuiltinClassType cls) {
        return cls.getMethodsFlags();
    }

    @CompilerDirectives.TruffleBoundary
    private static long populateMethodsFlags(PythonAbstractNativeObject cls, DynamicObjectLibrary dynlib) {
        Long flags = (Long)CExtNodes.PCallCapiFunction.getUncached().call(NativeCAPISymbol.FUN_GET_METHODS_FLAGS, cls.getPtr());
        dynlib.putLong((DynamicObject)cls, (Object)METHODS_FLAGS, flags.longValue());
        return flags;
    }

    protected static long getMethodsFlags(PythonAbstractNativeObject cls) {
        return GetMethodsFlagsNode.doNative(cls, DynamicObjectLibrary.getUncached());
    }

    protected static Assumption nativeAssumption(PythonAbstractNativeObject cls) {
        return PythonContext.get(null).getNativeClassStableAssumption(cls, true).getAssumption();
    }

    @Specialization(guards={"cachedCls == cls"}, limit="5", assumptions={"nativeAssumption(cachedCls)"})
    static long doNativeCached(PythonAbstractNativeObject cls, @Cached(value="cls") PythonAbstractNativeObject cachedCls, @Cached(value="getMethodsFlags(cls)") long flags) {
        return flags;
    }

    @Specialization(replaces={"doNativeCached"})
    static long doNative(PythonAbstractNativeObject cls, @CachedLibrary(limit="1") DynamicObjectLibrary dynlib) {
        if (!dynlib.containsKey((DynamicObject)cls, (Object)METHODS_FLAGS)) {
            return GetMethodsFlagsNode.populateMethodsFlags(cls, dynlib);
        }
        try {
            return dynlib.getLongOrDefault((DynamicObject)cls, (Object)METHODS_FLAGS, (Object)0L);
        }
        catch (UnexpectedResultException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    @Fallback
    protected static long zero(Object cls) {
        return 0L;
    }
}

