/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.type;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.hpy.HPyTypeExtra;
import com.oracle.graal.python.builtins.objects.type.MroShape;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromDynamicObjectNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.interop.PForeignToPTypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.sequence.storage.MroSequenceStorage;
import com.oracle.graal.python.util.SuppressFBWarnings;
import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.utilities.TruffleWeakReference;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;

@ExportLibrary(value=InteropLibrary.class)
public final class PythonClass
extends PythonManagedClass {
    private static final int MRO_SUBTYPES_MAX = 64;
    private static final int MRO_SHAPE_INVALIDATIONS_MAX = 5;
    public HPyTypeExtra hPyTypeExtra;
    private final AtomicReference<Assumption> slotsFinalAssumption = new AtomicReference();
    private MroShape mroShape;
    private TruffleWeakReference<PythonClass>[] mroShapeSubTypes;
    private byte mroShapeInvalidationsCount;

    public PythonClass(PythonLanguage lang, Object typeClass, Shape classShape, TruffleString name, Object base, PythonAbstractClass[] baseClasses) {
        super(lang, typeClass, classShape, null, name, base, baseClasses);
    }

    public PythonClass(PythonLanguage lang, Object typeClass, Shape classShape, TruffleString name, boolean invokeMro, Object base, PythonAbstractClass[] baseClasses) {
        super(lang, typeClass, classShape, null, name, invokeMro, false, base, baseClasses);
    }

    public Assumption getSlotsFinalAssumption() {
        Assumption result = this.slotsFinalAssumption.get();
        if (result == null && !this.slotsFinalAssumption.compareAndSet(null, result = Truffle.getRuntime().createAssumption("slots"))) {
            result = this.slotsFinalAssumption.get();
        }
        return result;
    }

    public void invalidateSlotsFinalAssumption() {
        Assumption assumption = this.slotsFinalAssumption.get();
        if (assumption != null) {
            assumption.invalidate();
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    @SuppressFBWarnings(value={"UR_UNINIT_READ_CALLED_FROM_SUPER_CONSTRUCTOR"})
    public void setAttribute(Object key, Object value) {
        if (this.slotsFinalAssumption != null) {
            this.invalidateSlotsFinalAssumption();
        }
        super.setAttribute(key, value);
        this.invalidateMroShapeSubTypes();
    }

    @ExportMessage(library=InteropLibrary.class)
    boolean isMetaObject() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    boolean isMetaInstance(Object instance, @Bind(value="$node") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached PForeignToPTypeNode convert, @Cached IsSubtypeNode isSubtype, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            boolean bl = isSubtype.execute(getClassNode.execute(inliningTarget, convert.executeConvert(instance)), this);
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    String getMetaSimpleName(@Cached.Exclusive @Cached GilNode gil, @Cached.Shared(value="ts2js") @Cached TruffleString.ToJavaStringNode toJavaStringNode) {
        boolean mustRelease = gil.acquire();
        try {
            String string = toJavaStringNode.execute((AbstractTruffleString)this.getName());
            return string;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    String getMetaQualifiedName(@Cached.Exclusive @Cached GilNode gil, @Cached.Shared(value="ts2js") @Cached TruffleString.ToJavaStringNode toJavaStringNode) {
        boolean mustRelease = gil.acquire();
        try {
            String string = toJavaStringNode.execute((AbstractTruffleString)this.getQualName());
            return string;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    protected static SourceSection findSourceSection(PythonManagedClass self) {
        for (Object key : self.getShape().getKeys()) {
            if (!(key instanceof TruffleString)) continue;
            Object value = ReadAttributeFromDynamicObjectNode.getUncached().execute((Object)self, key);
            InteropLibrary uncached = (InteropLibrary)InteropLibrary.getFactory().getUncached();
            if (!uncached.hasSourceLocation(value)) continue;
            try {
                return uncached.getSourceLocation(value);
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
            }
        }
        return null;
    }

    @ExportMessage
    protected SourceSection getSourceLocation(@Cached.Exclusive @Cached GilNode gil, @Bind(value="gil.acquire()") boolean mustRelease, @Cached.Shared(value="src") @Cached(value="findSourceSection(this)", allowUncached=true, neverDefault=false) SourceSection section) throws UnsupportedMessageException {
        try {
            if (section != null) {
                SourceSection sourceSection = section;
                return sourceSection;
            }
            throw UnsupportedMessageException.create();
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    protected boolean hasSourceLocation(@Cached.Exclusive @Cached GilNode gil, @Bind(value="gil.acquire()") boolean mustRelease, @Cached.Shared(value="src") @Cached(value="findSourceSection(this)", allowUncached=true, neverDefault=false) SourceSection section) {
        try {
            boolean bl = section != null;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @Override
    public void setMRO(PythonAbstractClass[] mro) {
        super.setMRO(mro);
        this.mroShape = null;
        this.invalidateMroShapeSubTypes();
    }

    public void setMRO(PythonAbstractClass[] mro, PythonLanguage language) {
        super.setMRO(mro);
        if (!language.isSingleContext()) {
            this.mroShape = null;
            this.invalidateMroShapeSubTypes();
        }
    }

    public void setDictHiddenProp(Node inliningTarget, DynamicObjectLibrary dylib, InlinedBranchProfile hasMroShapeProfile, Object value) {
        dylib.setShapeFlags((DynamicObject)this, dylib.getShapeFlags((DynamicObject)this) | 8);
        dylib.put((DynamicObject)this, (Object)DICT, value);
        if (this.mroShapeSubTypes != null) {
            hasMroShapeProfile.enter(inliningTarget);
            this.invalidateMroShapeSubTypes();
        }
    }

    public void makeStaticBase(DynamicObjectLibrary dylib) {
        dylib.setShapeFlags((DynamicObject)this, dylib.getShapeFlags((DynamicObject)this) | 0x10);
    }

    public boolean isStaticBase(DynamicObjectLibrary dylib) {
        return (dylib.getShapeFlags((DynamicObject)this) & 0x10) != 0;
    }

    public MroShape getMroShape() {
        return this.mroShape;
    }

    public void initializeMroShape(PythonLanguage language) {
        assert (this.mroShapeSubTypes == null);
        assert (this.mroShape == null);
        if (!language.isSingleContext()) {
            this.reinitializeMroShape(language);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private void reinitializeMroShape(PythonLanguage language) {
        MroSequenceStorage mro = this.getMethodResolutionOrder();
        this.mroShape = MroShape.create(mro, language);
        if (this.mroShape != null) {
            block0: for (int mroIdx = 0; mroIdx < mro.length(); ++mroIdx) {
                PythonManagedClass managedClass = (PythonManagedClass)mro.getItemNormalized(mroIdx);
                if (managedClass instanceof PythonBuiltinClass) continue;
                PythonClass klass = (PythonClass)managedClass;
                TruffleWeakReference<PythonClass>[] subTypes = klass.mroShapeSubTypes;
                if (subTypes == null) {
                    klass.mroShapeSubTypes = new TruffleWeakReference[8];
                    klass.mroShapeSubTypes[0] = new TruffleWeakReference((Object)this);
                    continue;
                }
                for (int subTypesIdx = 0; subTypesIdx < subTypes.length; ++subTypesIdx) {
                    if (subTypes[subTypesIdx] == null) {
                        subTypes[subTypesIdx] = new TruffleWeakReference((Object)this);
                        continue block0;
                    }
                    if (subTypes[subTypesIdx].get() == this) continue block0;
                }
                if (subTypes.length >= 64) {
                    this.mroShape = null;
                    this.mroShapeSubTypes = null;
                    break;
                }
                klass.mroShapeSubTypes = Arrays.copyOf(subTypes, subTypes.length * 2);
                klass.mroShapeSubTypes[subTypes.length] = new TruffleWeakReference((Object)this);
            }
        }
    }

    public boolean hasMroShapeSubTypes() {
        return this.mroShapeSubTypes != null;
    }

    @Override
    public boolean canSkipOnAttributeUpdate(TruffleString key, Object newValue, TruffleString.CodePointLengthNode codePointLengthNode, TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
        return super.canSkipOnAttributeUpdate(key, newValue, codePointLengthNode, codePointAtIndexNode) && this.mroShapeSubTypes == null;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void onAttributeUpdate(TruffleString key, Object newValue) {
        super.onAttributeUpdate(key, newValue);
        if (this.hasMroShapeSubTypes()) {
            if (newValue == PNone.NO_VALUE || this.mroShapeInvalidationsCount >= 5) {
                this.invalidateMroShapeSubTypes();
            } else {
                this.mroShapeInvalidationsCount = (byte)(this.mroShapeInvalidationsCount + 1);
                this.updateMroShapeSubTypes(PythonLanguage.get(null));
            }
        }
    }

    private void invalidateMroShapeSubTypes() {
        if (this.hasMroShapeSubTypes()) {
            for (TruffleWeakReference<PythonClass> subTypeRef : this.mroShapeSubTypes) {
                if (subTypeRef == null) break;
                PythonClass subType = (PythonClass)subTypeRef.get();
                if (subType == null) continue;
                subType.mroShape = null;
            }
            this.mroShapeSubTypes = null;
        }
    }

    @CompilerDirectives.TruffleBoundary
    private void updateMroShapeSubTypes(PythonLanguage lang) {
        if (this.hasMroShapeSubTypes()) {
            for (TruffleWeakReference<PythonClass> subTypeRef : this.mroShapeSubTypes) {
                if (subTypeRef == null) break;
                PythonClass subType = (PythonClass)subTypeRef.get();
                if (subType == null) continue;
                subType.mroShape = MroShape.create(subType.getMethodResolutionOrder(), lang);
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    static void updateMroShapeSubTypes(PythonBuiltinClass klass) {
        ArrayDeque<PythonAbstractClass> toProcess = new ArrayDeque<PythonAbstractClass>();
        toProcess.add(klass);
        PythonLanguage lang = PythonLanguage.get(null);
        while (toProcess.size() > 0) {
            Object next = toProcess.pop();
            if (next instanceof PythonClass) {
                ((PythonClass)next).updateMroShapeSubTypes(lang);
                continue;
            }
            toProcess.addAll(Arrays.asList(TypeNodes.GetSubclassesAsArrayNode.executeUncached(next)));
        }
    }

    public long getBasicSize() {
        return this.hPyTypeExtra != null ? this.hPyTypeExtra.basicSize : -1L;
    }

    public long getItemSize() {
        return this.hPyTypeExtra != null ? this.hPyTypeExtra.itemSize : -1L;
    }

    public Object getHPyDestroyFunc() {
        if (this.hPyTypeExtra != null) {
            return this.hPyTypeExtra.hpyDestroyFunc;
        }
        return null;
    }

    public Object getTpName() {
        return this.hPyTypeExtra != null ? this.hPyTypeExtra.tpName : null;
    }

    public long getFlags() {
        return this.hPyTypeExtra != null ? this.hPyTypeExtra.flags : 0L;
    }

    public int getBuiltinShape() {
        return this.hPyTypeExtra != null ? this.hPyTypeExtra.builtinShape : -1;
    }

    public Object getHPyDefaultCallFunc() {
        return this.hPyTypeExtra != null ? this.hPyTypeExtra.defaultCallFunc : null;
    }

    public long getHPyVectorcallOffset() {
        return this.hPyTypeExtra != null ? this.hPyTypeExtra.vectorcallOffset : Long.MIN_VALUE;
    }

    public void setHPyDestroyFunc(Object destroyFunc) {
        this.hPyTypeExtra.hpyDestroyFunc = destroyFunc;
    }

    public void setHPyDefaultCallFunc(Object defaultCallFunc) {
        this.hPyTypeExtra.defaultCallFunc = defaultCallFunc;
    }

    public void setHPyVectorcallOffset(int vectorcallOffset) {
        this.hPyTypeExtra.vectorcallOffset = vectorcallOffset;
    }

    public void setHPyTypeExtra(HPyTypeExtra hpyTypeExtra) {
        this.hPyTypeExtra = hpyTypeExtra;
    }

    public boolean isHPyType() {
        return this.hPyTypeExtra != null;
    }
}

