/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.method;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.method.ClassmethodBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.method.PDecoratedMethod;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PClassmethod, PythonBuiltinClassType.PBuiltinClassMethod})
public final class ClassmethodBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ClassmethodBuiltinsFactory.getFactories();
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        private static final TruffleString PREFIX = PythonUtils.tsLiteral("<classmethod(");
        private static final int PREFIX_LEN = PREFIX.byteLength(PythonUtils.TS_ENCODING);
        private static final TruffleString SUFFIX = PythonUtils.tsLiteral(")>");
        private static final int SUFFIX_LEN = SUFFIX.byteLength(PythonUtils.TS_ENCODING);

        ReprNode() {
        }

        @Specialization
        Object repr(VirtualFrame frame, PDecoratedMethod self, @Bind(value="this") Node inliningTarget, @Cached PyObjectReprAsTruffleStringNode repr, @Cached TruffleStringBuilder.AppendStringNode append, @Cached TruffleStringBuilder.ToStringNode toString) {
            TruffleString callableRepr = repr.execute((Frame)frame, inliningTarget, self.getCallable());
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING, (int)(PREFIX_LEN + callableRepr.byteLength(PythonUtils.TS_ENCODING) + SUFFIX_LEN));
            append.execute(sb, (AbstractTruffleString)PREFIX);
            append.execute(sb, (AbstractTruffleString)callableRepr);
            append.execute(sb, (AbstractTruffleString)SUFFIX);
            return toString.execute(sb);
        }
    }

    @Builtin(name="__call__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    static abstract class CallNode
    extends PythonVarargsBuiltinNode {
        @Node.Child
        private com.oracle.graal.python.nodes.call.CallNode callNode = com.oracle.graal.python.nodes.call.CallNode.create();

        CallNode() {
        }

        @Specialization
        protected Object doIt(VirtualFrame frame, PDecoratedMethod self, Object[] arguments, PKeyword[] keywords) {
            return this.callNode.execute((Frame)frame, self.getCallable(), arguments, keywords);
        }

        @Override
        public Object varArgExecute(VirtualFrame frame, Object self, Object[] arguments, PKeyword[] keywords) throws PythonVarargsBuiltinNode.VarargsBuiltinDirectInvocationNotSupported {
            Object[] argsWithoutSelf = new Object[arguments.length - 1];
            PythonUtils.arraycopy(arguments, 1, argsWithoutSelf, 0, argsWithoutSelf.length);
            return this.execute(frame, arguments[0], argsWithoutSelf, keywords);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class})
    @ReportPolymorphism
    static abstract class MakeMethodNode
    extends PNodeWithContext {
        MakeMethodNode() {
        }

        abstract Object execute(Node var1, Object var2, Object var3);

        @Specialization
        Object method(Object self, PFunction func, @Cached.Shared(value="factory") @Cached(inline=false) PythonObjectFactory factory) {
            return factory.createMethod(self, func);
        }

        @Specialization(guards={"!func.needsDeclaringType()"})
        Object methodBuiltin(Object self, PBuiltinFunction func, @Cached.Shared(value="factory") @Cached(inline=false) PythonObjectFactory factory) {
            return factory.createBuiltinMethod(self, func);
        }

        @Specialization(guards={"func.needsDeclaringType()"})
        Object methodBuiltinWithDeclaringType(Object self, PBuiltinFunction func, @Cached.Shared(value="factory") @Cached(inline=false) PythonObjectFactory factory) {
            return factory.createBuiltinMethod(self, func, func.getEnclosingType());
        }

        @Specialization(guards={"!isFunction(func)"})
        Object generic(Object self, Object func, @Cached.Shared(value="factory") @Cached(inline=false) PythonObjectFactory factory) {
            return factory.createMethod(self, func);
        }
    }

    @Builtin(name="__get__", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=3)
    @GenerateNodeFactory
    @ReportPolymorphism
    static abstract class GetNode
    extends PythonTernaryBuiltinNode {
        GetNode() {
        }

        @Specialization(guards={"isSingleContext()", "isNoValue(type)", "cachedSelf == self"}, limit="3")
        static Object getCached(PDecoratedMethod self, Object obj, Object type, @Bind(value="this") Node inliningTarget, @Cached(value="self", weak=true) PDecoratedMethod cachedSelf, @Cached(value="self.getCallable()", weak=true) Object cachedCallable, @Cached.Shared @Cached GetClassNode getClass, @Cached.Shared @Cached MakeMethodNode makeMethod) {
            return makeMethod.execute(inliningTarget, getClass.execute(inliningTarget, obj), cachedCallable);
        }

        @Specialization(guards={"isNoValue(type)"}, replaces={"getCached"})
        Object get(PDecoratedMethod self, Object obj, Object type, @Bind(value="this") Node inliningTarget, @Cached @Cached.Shared GetClassNode getClass, @Cached @Cached.Shared InlinedBranchProfile uninitialized, @Cached.Shared @Cached MakeMethodNode makeMethod) {
            return this.doGet(inliningTarget, self, getClass.execute(inliningTarget, obj), uninitialized, makeMethod);
        }

        @Specialization(guards={"isSingleContext()", "!isNoValue(type)", "cachedSelf == self"}, limit="3")
        static Object getTypeCached(PDecoratedMethod self, Object obj, Object type, @Bind(value="this") Node inliningTarget, @Cached(value="self", weak=true) PDecoratedMethod cachedSelf, @Cached(value="self.getCallable()", weak=true) Object cachedCallable, @Cached.Shared @Cached MakeMethodNode makeMethod) {
            return makeMethod.execute(inliningTarget, type, cachedCallable);
        }

        @Specialization(guards={"!isNoValue(type)"}, replaces={"getTypeCached"})
        Object getType(PDecoratedMethod self, Object obj, Object type, @Bind(value="this") Node inliningTarget, @Cached @Cached.Shared InlinedBranchProfile uninitialized, @Cached.Shared @Cached MakeMethodNode makeMethod) {
            return this.doGet(inliningTarget, self, type, uninitialized, makeMethod);
        }

        private Object doGet(Node inliningTarget, PDecoratedMethod self, Object type, InlinedBranchProfile uninitialized, MakeMethodNode makeMethod) {
            Object callable = self.getCallable();
            if (callable == null) {
                uninitialized.enter(inliningTarget);
                throw this.raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.UNINITIALIZED_S_OBJECT);
            }
            return makeMethod.execute(inliningTarget, type, callable);
        }
    }
}

