/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.mappingproxy;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.Builtins;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.mappingproxy.MappingproxyBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.mappingproxy.PMappingproxy;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.lib.PyObjectStrAsObjectNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.expression.BinaryArithmetic;
import com.oracle.graal.python.nodes.expression.BinaryOpNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PMappingproxy})
public final class MappingproxyBuiltins
extends PythonBuiltins {
    protected List<NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return MappingproxyBuiltinsFactory.getFactories();
    }

    @Builtin(name="__reversed__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReversedNode
    extends PythonUnaryBuiltinNode {
        ReversedNode() {
        }

        @Specialization
        Object reversed(VirtualFrame frame, PMappingproxy self, @Bind(value="this") Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, self.getMapping(), SpecialMethodNames.T___REVERSED__, new Object[0]);
        }
    }

    @Builtin(name="__ior__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class IOrNode
    extends PythonBinaryBuiltinNode {
        IOrNode() {
        }

        @Specialization
        Object or(Object self, Object other) {
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.IOR_IS_NOT_SUPPORTED_BY_P_USE_INSTEAD, self);
        }
    }

    @Builtins(value={@Builtin(name="__or__", minNumOfPositionalArgs=2), @Builtin(name="__ror__", minNumOfPositionalArgs=2, reverseOperation=true)})
    @GenerateNodeFactory
    static abstract class OrNode
    extends PythonBinaryBuiltinNode {
        @Node.Child
        BinaryOpNode orNode = BinaryArithmetic.Or.create();

        OrNode() {
        }

        @Specialization
        Object or(VirtualFrame frame, Object self, Object other) {
            if (self instanceof PMappingproxy) {
                self = ((PMappingproxy)self).getMapping();
            }
            if (other instanceof PMappingproxy) {
                other = ((PMappingproxy)other).getMapping();
            }
            return this.orNode.executeObject(frame, self, other);
        }
    }

    @Builtin(name="__class_getitem__", minNumOfPositionalArgs=2, isClassmethod=true)
    @GenerateNodeFactory
    public static abstract class ClassGetItemNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        Object classGetItem(Object cls, Object key) {
            return this.factory().createGenericAlias(cls, key);
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        static TruffleString repr(VirtualFrame frame, PMappingproxy self, @Bind(value="this") Node inliningTarget, @Cached PyObjectReprAsTruffleStringNode reprNode, @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            TruffleString mappingRepr = reprNode.execute((Frame)frame, inliningTarget, self.getMapping());
            return simpleTruffleStringFormatNode.format("mappingproxy(%s)", mappingRepr);
        }
    }

    @Builtin(name="__str__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class StrNode
    extends PythonUnaryBuiltinNode {
        StrNode() {
        }

        @Specialization
        static Object str(VirtualFrame frame, PMappingproxy self, @Bind(value="this") Node inliningTarget, @Cached PyObjectStrAsObjectNode strNode) {
            return strNode.execute((Frame)frame, inliningTarget, self.getMapping());
        }
    }

    @Builtin(name="__eq__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class EqNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        Object eq(VirtualFrame frame, PMappingproxy self, Object other, @Bind(value="this") Node inliningTarget, @Cached PyObjectRichCompareBool.EqNode eqNode) {
            return eqNode.compare((Frame)frame, inliningTarget, self.getMapping(), other);
        }
    }

    @Builtin(name="copy", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class CopyNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        public Object copy(VirtualFrame frame, PMappingproxy self, @Bind(value="this") Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, self.getMapping(), SpecialMethodNames.T_COPY, new Object[0]);
        }
    }

    @Builtin(name="__len__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class LenNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        public int len(VirtualFrame frame, PMappingproxy self, @Bind(value="this") Node inliningTarget, @Cached PyObjectSizeNode sizeNode) {
            return sizeNode.execute((Frame)frame, inliningTarget, self.getMapping());
        }
    }

    @Builtin(name="__contains__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class ContainsNode
    extends PythonBuiltinNode {
        @Specialization
        Object run(VirtualFrame frame, PMappingproxy self, Object key, @Cached com.oracle.graal.python.nodes.expression.ContainsNode containsNode) {
            return containsNode.executeObject(frame, key, self.getMapping());
        }
    }

    @Builtin(name="__getitem__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class GetItemNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        Object getItem(VirtualFrame frame, PMappingproxy self, Object key, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetItem getItemNode) {
            return getItemNode.execute((Frame)frame, inliningTarget, self.getMapping(), key);
        }
    }

    @Builtin(name="get", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=3)
    @GenerateNodeFactory
    public static abstract class GetNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isNoValue(defaultValue)"})
        public Object get(VirtualFrame frame, PMappingproxy self, Object key, PNone defaultValue, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="callMethod") @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, self.getMapping(), SpecialMethodNames.T_GET, key);
        }

        @Specialization(guards={"!isNoValue(defaultValue)"})
        public Object get(VirtualFrame frame, PMappingproxy self, Object key, Object defaultValue, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="callMethod") @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, self.getMapping(), SpecialMethodNames.T_GET, key, defaultValue);
        }
    }

    @Builtin(name="values", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ValuesNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        public Object values(VirtualFrame frame, PMappingproxy self, @Bind(value="this") Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, self.getMapping(), SpecialMethodNames.T_VALUES, new Object[0]);
        }
    }

    @Builtin(name="items", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ItemsNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        public Object items(VirtualFrame frame, PMappingproxy self, @Bind(value="this") Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, self.getMapping(), SpecialMethodNames.T_ITEMS, new Object[0]);
        }
    }

    @Builtin(name="keys", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class KeysNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        public Object items(VirtualFrame frame, PMappingproxy self, @Bind(value="this") Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, self.getMapping(), SpecialMethodNames.T_KEYS, new Object[0]);
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object iter(VirtualFrame frame, PMappingproxy self, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetIter getIter) {
            return getIter.execute((Frame)frame, inliningTarget, self.getMapping());
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class InitNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        Object doPMappingproxy(PMappingproxy self, Object mapping) {
            return PNone.NONE;
        }
    }
}

