/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.list;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.Builtins;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.MathGuards;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.common.IndexNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SortNodes;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.iterator.IteratorNodes;
import com.oracle.graal.python.builtins.objects.iterator.PDoubleSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PIntegerSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PLongSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PSequenceIterator;
import com.oracle.graal.python.builtins.objects.list.ListBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.list.ListBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.range.PIntRange;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypes;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.DoubleSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.EmptySequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.IntSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.LongSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import com.oracle.truffle.api.strings.TruffleStringIterator;
import java.math.BigInteger;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PList})
public final class ListBuiltins
extends PythonBuiltins {
    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
        this.addBuiltinConstant(SpecialAttributeNames.T___DOC__, (Object)"Built-in mutable sequence.\n\nIf no argument is given, the constructor creates a new empty list.\nThe argument must be an iterable if specified.");
        this.addBuiltinConstant(SpecialMethodNames.T___HASH__, (Object)PNone.NONE);
    }

    protected List<NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ListBuiltinsFactory.getFactories();
    }

    @Builtin(name="__class_getitem__", minNumOfPositionalArgs=2, isClassmethod=true)
    @GenerateNodeFactory
    public static abstract class ClassGetItemNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        Object classGetItem(Object cls, Object key) {
            return this.factory().createGenericAlias(cls, key);
        }
    }

    @Builtin(name="__reversed__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReverseNode
    extends PythonUnaryBuiltinNode {
        ReverseNode() {
        }

        @Specialization
        Object reverse(PList self, @Bind(value="this") Node inliningTarget, @Cached SequenceNodes.GetSequenceStorageNode getSequenceStorageNode) {
            int len = getSequenceStorageNode.execute(inliningTarget, self).length();
            return this.factory().createSequenceReverseIterator((Object)PythonBuiltinClassType.PReverseIterator, self, len);
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"isIntStorage(primary)"})
        PIntegerSequenceIterator doPListInt(PList primary) {
            return this.factory().createIntegerSequenceIterator((IntSequenceStorage)primary.getSequenceStorage(), primary);
        }

        @Specialization(guards={"isLongStorage(primary)"})
        PLongSequenceIterator doPListLong(PList primary) {
            return this.factory().createLongSequenceIterator((LongSequenceStorage)primary.getSequenceStorage(), primary);
        }

        @Specialization(guards={"isDoubleStorage(primary)"})
        PDoubleSequenceIterator doPListDouble(PList primary) {
            return this.factory().createDoubleSequenceIterator((DoubleSequenceStorage)primary.getSequenceStorage(), primary);
        }

        @Specialization(guards={"!isIntStorage(primary)", "!isLongStorage(primary)", "!isDoubleStorage(primary)"})
        PSequenceIterator doPList(PList primary) {
            return this.factory().createSequenceIterator(primary);
        }

        @Fallback
        static Object doGeneric(Object self) {
            return PNone.NONE;
        }
    }

    @Builtin(name="__contains__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class ContainsNode
    extends PythonBinaryBuiltinNode {
        ContainsNode() {
        }

        @Specialization
        boolean contains(VirtualFrame frame, PSequence self, Object other, @Bind(value="this") Node inliningTarget, @Cached SequenceNodes.GetSequenceStorageNode getStorage, @Cached SequenceStorageNodes.ContainsNode containsNode) {
            return containsNode.execute(frame, inliningTarget, getStorage.execute(inliningTarget, self), other);
        }
    }

    @Builtin(name="__lt__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class LtNode
    extends PythonBinaryBuiltinNode {
        LtNode() {
        }

        @Specialization
        boolean doPList(VirtualFrame frame, PList left, PList right, @Cached(value="createLt()") SequenceStorageNodes.CmpNode neNode) {
            return neNode.execute(frame, left.getSequenceStorage(), right.getSequenceStorage());
        }

        @Fallback
        PNotImplemented contains(Object self, Object other) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__gt__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class GtNode
    extends PythonBinaryBuiltinNode {
        GtNode() {
        }

        @Specialization
        boolean doPList(VirtualFrame frame, PList left, PList right, @Cached(value="createGt()") SequenceStorageNodes.CmpNode neNode) {
            return neNode.execute(frame, left.getSequenceStorage(), right.getSequenceStorage());
        }

        @Fallback
        PNotImplemented doOther(Object left, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__le__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class LeNode
    extends PythonBinaryBuiltinNode {
        LeNode() {
        }

        @Specialization
        boolean doPList(VirtualFrame frame, PList left, PList right, @Cached(value="createLe()") SequenceStorageNodes.CmpNode neNode) {
            return neNode.execute(frame, left.getSequenceStorage(), right.getSequenceStorage());
        }

        @Fallback
        PNotImplemented doOther(Object left, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__ge__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class GeNode
    extends PythonBinaryBuiltinNode {
        GeNode() {
        }

        @Specialization
        boolean doPList(VirtualFrame frame, PList left, PList right, @Cached(value="createGe()") SequenceStorageNodes.CmpNode neNode) {
            return neNode.execute(frame, left.getSequenceStorage(), right.getSequenceStorage());
        }

        @Fallback
        PNotImplemented doOther(Object left, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__ne__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class NeNode
    extends PythonBinaryBuiltinNode {
        NeNode() {
        }

        @Specialization
        boolean doPList(VirtualFrame frame, PList left, PList right, @Cached(value="createEq()") SequenceStorageNodes.CmpNode eqNode) {
            return !eqNode.execute(frame, left.getSequenceStorage(), right.getSequenceStorage());
        }

        @Fallback
        PNotImplemented doOther(Object left, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__eq__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class EqNode
    extends PythonBinaryBuiltinNode {
        EqNode() {
        }

        protected static boolean isObjectStorage(PList left, PList right) {
            return PGuards.isObjectStorage(left) || PGuards.isObjectStorage(right);
        }

        @Specialization(guards={"!isObjectStorage(left, right)"})
        boolean doPList(VirtualFrame frame, PList left, PList right, @Cached.Shared @Cached(value="createEq()") SequenceStorageNodes.CmpNode neNode) {
            return neNode.execute(frame, left.getSequenceStorage(), right.getSequenceStorage());
        }

        @Specialization(guards={"isObjectStorage(left, right)"})
        boolean doPListObjectStorage(VirtualFrame frame, PList left, PList right, @Cached.Shared @Cached(value="createEq()") SequenceStorageNodes.CmpNode neNode) {
            SequenceStorage leftStorage = left.getSequenceStorage();
            SequenceStorage rightStorage = right.getSequenceStorage();
            boolean result = neNode.execute(frame, leftStorage, rightStorage);
            if (leftStorage == left.getSequenceStorage() && rightStorage == right.getSequenceStorage()) {
                return result;
            }
            return this.doPList(frame, left, right, neNode);
        }

        @Fallback
        Object doOther(Object left, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__imul__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class IMulNode
    extends PythonBinaryBuiltinNode {
        IMulNode() {
        }

        @Specialization
        Object doGeneric(VirtualFrame frame, PList list, Object right, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile updatedProfile, @Cached SequenceStorageNodes.RepeatNode repeatNode) {
            SequenceStorage updated;
            SequenceStorage store = list.getSequenceStorage();
            if (updatedProfile.profile(inliningTarget, store != (updated = repeatNode.execute(frame, store, right)))) {
                list.setSequenceStorage(updated);
            }
            return list;
        }

        protected IMulNode createIMulNode() {
            return ListBuiltinsFactory.IMulNodeFactory.create();
        }
    }

    @Builtins(value={@Builtin(name="__rmul__", minNumOfPositionalArgs=2), @Builtin(name="__mul__", minNumOfPositionalArgs=2)})
    @GenerateNodeFactory
    static abstract class MulNode
    extends PythonBinaryBuiltinNode {
        MulNode() {
        }

        @Specialization
        PList doPListInt(VirtualFrame frame, PList left, Object right, @Cached SequenceStorageNodes.RepeatNode repeatNode) {
            try {
                SequenceStorage repeated = repeatNode.execute(frame, left.getSequenceStorage(), right);
                return this.factory().createList(repeated);
            }
            catch (ArithmeticException | OutOfMemoryError e) {
                throw this.raise(PythonErrorType.MemoryError);
            }
        }

        @Fallback
        PNotImplemented doGeneric(Object left, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__iadd__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class IAddNode
    extends PythonBinaryBuiltinNode {
        IAddNode() {
        }

        @Specialization
        PList extendSequence(VirtualFrame frame, PList list, Object iterable, @Bind(value="this") Node inliningTarget, @Cached IteratorNodes.GetLength lenNode, @Cached(value="createExtend()") SequenceStorageNodes.ExtendNode extendNode) {
            int len = lenNode.execute(frame, inliningTarget, iterable);
            IAddNode.updateSequenceStorage(list, extendNode.execute(frame, list.getSequenceStorage(), iterable, len));
            return list;
        }

        private static void updateSequenceStorage(PList list, SequenceStorage s) {
            if (list.getSequenceStorage() != s) {
                list.setSequenceStorage(s);
            }
        }

        @NeverDefault
        protected static SequenceStorageNodes.ExtendNode createExtend() {
            return SequenceStorageNodes.ExtendNode.create(SequenceStorageNodes.ListGeneralizationNode.SUPPLIER);
        }
    }

    @Builtin(name="__add__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class AddNode
    extends PythonBinaryBuiltinNode {
        AddNode() {
        }

        @Specialization
        PList doPList(PList left, PList other, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached(value="createConcat()") SequenceStorageNodes.ConcatNode concatNode) {
            SequenceStorage newStore = concatNode.execute(left.getSequenceStorage(), other.getSequenceStorage());
            return this.factory().createList(getClassNode.execute(inliningTarget, left), newStore);
        }

        @Specialization(guards={"!isList(right)"})
        Object doGeneric(Object left, Object right) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.CAN_ONLY_CONCAT_S_NOT_P_TO_S, "list", right, "list");
        }

        @NeverDefault
        protected static SequenceStorageNodes.ConcatNode createConcat() {
            return SequenceStorageNodes.ConcatNode.create(() -> SequenceStorageNodes.ListGeneralizationNode.create());
        }
    }

    @Builtin(name="__len__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class LenNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        int doGeneric(PList list) {
            return list.getSequenceStorage().length();
        }
    }

    @Builtin(name="sort", minNumOfPositionalArgs=1, parameterNames={"$self"}, keywordOnlyNames={"key", "reverse"})
    @ArgumentClinic(name="reverse", conversion=ArgumentClinic.ClinicConversion.IntToBoolean, defaultValue="false")
    @GenerateNodeFactory
    public static abstract class ListSortNode
    extends PythonClinicBuiltinNode {
        public final Object execute(VirtualFrame frame, PList list) {
            return this.execute(frame, list, PNone.NO_VALUE, false);
        }

        public abstract Object execute(VirtualFrame var1, PList var2, Object var3, boolean var4);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        Object doGeneric(VirtualFrame frame, PList list, Object keyfunc, boolean reverse, @Cached SortNodes.SortSequenceStorageNode sortSequenceStorageNode) {
            SequenceStorage storage = list.getSequenceStorage();
            list.setSequenceStorage(EmptySequenceStorage.INSTANCE);
            try {
                sortSequenceStorageNode.execute(frame, storage, keyfunc, reverse);
                if (list.getSequenceStorage() != EmptySequenceStorage.INSTANCE) {
                    throw this.raise(PythonErrorType.ValueError, ErrorMessages.LIST_MODIFIED_DURING_SOFT);
                }
            }
            finally {
                list.setSequenceStorage(storage);
            }
            return PNone.NONE;
        }

        @NeverDefault
        public static ListSortNode create() {
            return ListBuiltinsFactory.ListSortNodeFactory.create(null);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ListBuiltinsClinicProviders.ListSortNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="reverse", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ListReverseNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static PList reverse(PList list) {
            list.reverse();
            return list;
        }
    }

    @Builtin(name="clear", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ListClearNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static PNone clear(PList list) {
            list.setSequenceStorage(EmptySequenceStorage.INSTANCE);
            return PNone.NONE;
        }
    }

    @Builtin(name="count", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class ListCountNode
    extends PythonBuiltinNode {
        @Specialization
        long count(VirtualFrame frame, PList self, Object value, @Bind(value="this") Node inliningTarget, @Cached(value="createNotNormalized()") SequenceStorageNodes.GetItemNode getItemNode, @Cached PyObjectRichCompareBool.EqNode eqNode) {
            long count = 0L;
            SequenceStorage s = self.getSequenceStorage();
            for (int i = 0; i < s.length(); ++i) {
                Object seqItem = getItemNode.execute(s, i);
                if (!eqNode.compare((Frame)frame, inliningTarget, seqItem, value)) continue;
                ++count;
            }
            return count;
        }
    }

    @Builtin(name="index", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=4)
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @ImportStatic(value={MathGuards.class})
    @GenerateNodeFactory
    public static abstract class ListIndexNode
    extends PythonBuiltinNode {
        protected static final TruffleString ERROR_TYPE_MESSAGE = ErrorMessages.SLICE_INDICES_TYPE_ERROR;

        public abstract int execute(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5);

        private static int correctIndex(SequenceStorage s, long index) {
            long resultIndex = index;
            if (resultIndex < 0L && (resultIndex += (long)s.length()) < 0L) {
                return 0;
            }
            return (int)Math.min(resultIndex, Integer.MAX_VALUE);
        }

        @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
        private static int correctIndex(SequenceStorage s, PInt index) {
            BigInteger value = index.getValue();
            if (value.compareTo(BigInteger.ZERO) < 0) {
                BigInteger resultAdd = value.add(BigInteger.valueOf(s.length()));
                if (resultAdd.compareTo(BigInteger.ZERO) < 0) {
                    return 0;
                }
                return resultAdd.intValue();
            }
            return value.min(BigInteger.valueOf(Integer.MAX_VALUE)).intValue();
        }

        private int findIndex(VirtualFrame frame, Node inliningTarget, SequenceStorageNodes.ItemIndexNode itemIndexNode, SequenceStorage s, Object value, int start, int end) {
            int idx = itemIndexNode.execute(frame, inliningTarget, s, value, start, end);
            if (idx != -1) {
                return idx;
            }
            throw this.raise(PythonErrorType.ValueError, ErrorMessages.X_NOT_IN_LIST);
        }

        @Specialization
        int index(VirtualFrame frame, PList self, Object value, PNone start, PNone end, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached SequenceStorageNodes.ItemIndexNode itemIndexNode) {
            SequenceStorage s = self.getSequenceStorage();
            return this.findIndex(frame, inliningTarget, itemIndexNode, s, value, 0, s.length());
        }

        @Specialization
        int index(VirtualFrame frame, PList self, Object value, long start, PNone end, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached SequenceStorageNodes.ItemIndexNode itemIndexNode) {
            SequenceStorage s = self.getSequenceStorage();
            return this.findIndex(frame, inliningTarget, itemIndexNode, s, value, ListIndexNode.correctIndex(s, start), s.length());
        }

        @Specialization
        int index(VirtualFrame frame, PList self, Object value, long start, long end, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached SequenceStorageNodes.ItemIndexNode itemIndexNode) {
            SequenceStorage s = self.getSequenceStorage();
            return this.findIndex(frame, inliningTarget, itemIndexNode, s, value, ListIndexNode.correctIndex(s, start), ListIndexNode.correctIndex(s, end));
        }

        @Specialization
        int indexPI(VirtualFrame frame, PList self, Object value, PInt start, PNone end, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached SequenceStorageNodes.ItemIndexNode itemIndexNode) {
            SequenceStorage s = self.getSequenceStorage();
            return this.findIndex(frame, inliningTarget, itemIndexNode, s, value, ListIndexNode.correctIndex(s, start), s.length());
        }

        @Specialization
        int indexPIPI(VirtualFrame frame, PList self, Object value, PInt start, PInt end, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached SequenceStorageNodes.ItemIndexNode itemIndexNode) {
            SequenceStorage s = self.getSequenceStorage();
            return this.findIndex(frame, inliningTarget, itemIndexNode, s, value, ListIndexNode.correctIndex(s, start), ListIndexNode.correctIndex(s, end));
        }

        @Specialization
        int indexLPI(VirtualFrame frame, PList self, Object value, long start, PInt end, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached SequenceStorageNodes.ItemIndexNode itemIndexNode) {
            SequenceStorage s = self.getSequenceStorage();
            return this.findIndex(frame, inliningTarget, itemIndexNode, s, value, ListIndexNode.correctIndex(s, start), ListIndexNode.correctIndex(s, end));
        }

        @Specialization
        int indexPIL(VirtualFrame frame, PList self, Object value, PInt start, Long end, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached SequenceStorageNodes.ItemIndexNode itemIndexNode) {
            SequenceStorage s = self.getSequenceStorage();
            return this.findIndex(frame, inliningTarget, itemIndexNode, s, value, ListIndexNode.correctIndex(s, start), ListIndexNode.correctIndex(s, end));
        }

        @Specialization
        int indexDO(PTuple self, Object value, double start, Object end) {
            throw this.raise(PythonErrorType.TypeError, ERROR_TYPE_MESSAGE);
        }

        @Specialization
        int indexOD(PTuple self, Object value, Object start, double end) {
            throw this.raise(PythonErrorType.TypeError, ERROR_TYPE_MESSAGE);
        }

        @Specialization(guards={"!isNumber(start)"})
        int indexO(VirtualFrame frame, PTuple self, Object value, Object start, PNone end, @Cached.Shared @Cached(value="createNumber(ERROR_TYPE_MESSAGE)") ListNodes.IndexNode startNode, @Cached.Shared @Cached(value="createIndexNode()") ListIndexNode indexNode) {
            Object startValue = startNode.execute(frame, start);
            return indexNode.execute(frame, self, value, startValue, end);
        }

        @Specialization(guards={"!isNumber(end)"})
        int indexLO(VirtualFrame frame, PTuple self, Object value, long start, Object end, @Cached.Shared @Cached(value="createNumber(ERROR_TYPE_MESSAGE)") ListNodes.IndexNode endNode, @Cached.Shared @Cached(value="createIndexNode()") ListIndexNode indexNode) {
            Object endValue = endNode.execute(frame, end);
            return indexNode.execute(frame, self, value, start, endValue);
        }

        @Specialization(guards={"!isNumber(start) || !isNumber(end)"})
        int indexOO(VirtualFrame frame, PTuple self, Object value, Object start, Object end, @Cached.Shared @Cached(value="createNumber(ERROR_TYPE_MESSAGE)") ListNodes.IndexNode startNode, @Cached.Shared @Cached(value="createNumber(ERROR_TYPE_MESSAGE)") ListNodes.IndexNode endNode, @Cached.Shared @Cached(value="createIndexNode()") ListIndexNode indexNode) {
            Object startValue = startNode.execute(frame, start);
            Object endValue = endNode.execute(frame, end);
            return indexNode.execute(frame, self, value, startValue, endValue);
        }

        @NeverDefault
        protected ListIndexNode createIndexNode() {
            return ListBuiltinsFactory.ListIndexNodeFactory.create(null);
        }
    }

    @Builtin(name="pop", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class ListPopNode
    extends PythonBinaryBuiltinNode {
        @Node.Child
        private SequenceStorageNodes.GetItemNode getItemNode;

        @Specialization
        public Object popLast(VirtualFrame frame, PList list, PNone none, @Cached.Shared @Cached(value="createDelete()") SequenceStorageNodes.DeleteNode deleteNode) {
            SequenceStorage store = list.getSequenceStorage();
            Object ret = this.getGetItemNode().execute(store, -1);
            deleteNode.execute(frame, store, -1);
            return ret;
        }

        @Specialization(guards={"!isNoValue(idx)", "!isPSlice(idx)"})
        public Object doIndex(VirtualFrame frame, PList list, Object idx, @Cached.Shared @Cached(value="createDelete()") SequenceStorageNodes.DeleteNode deleteNode) {
            SequenceStorage store = list.getSequenceStorage();
            Object ret = this.getGetItemNode().execute(frame, store, idx);
            deleteNode.execute(frame, store, idx);
            return ret;
        }

        @Fallback
        public Object doError(Object list, Object arg) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.OBJ_CANNOT_BE_INTERPRETED_AS_INTEGER, arg);
        }

        private SequenceStorageNodes.GetItemNode getGetItemNode() {
            if (this.getItemNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getItemNode = (SequenceStorageNodes.GetItemNode)this.insert(SequenceStorageNodes.GetItemNode.create(ListPopNode.createNormalize()));
            }
            return this.getItemNode;
        }

        @NeverDefault
        protected static SequenceStorageNodes.DeleteNode createDelete() {
            return SequenceStorageNodes.DeleteNode.create(ListPopNode.createNormalize());
        }

        @NeverDefault
        private static IndexNodes.NormalizeIndexNode createNormalize() {
            return IndexNodes.NormalizeIndexNode.create(ErrorMessages.POP_INDEX_OUT_OF_RANGE);
        }
    }

    @Builtin(name="remove", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class ListRemoveNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        PNone remove(VirtualFrame frame, PList list, Object value, @Bind(value="this") Node inliningTarget, @Cached(value="createNotNormalized()") SequenceStorageNodes.GetItemNode getItemNode, @Cached SequenceStorageNodes.DeleteNode deleteNode, @Cached PyObjectRichCompareBool.EqNode eqNode) {
            SequenceStorage listStore = list.getSequenceStorage();
            int len = listStore.length();
            for (int i = 0; i < len; ++i) {
                Object object = getItemNode.execute(listStore, i);
                if (!eqNode.compare((Frame)frame, inliningTarget, object, value)) continue;
                deleteNode.execute(frame, listStore, i);
                return PNone.NONE;
            }
            throw this.raise(PythonErrorType.ValueError, ErrorMessages.NOT_IN_LIST_MESSAGE);
        }
    }

    @Builtin(name="insert", minNumOfPositionalArgs=3)
    @GenerateNodeFactory
    public static abstract class ListInsertNode
    extends PythonTernaryBuiltinNode {
        protected static final TruffleString ERROR_MSG = ErrorMessages.OBJ_CANNOT_BE_INTERPRETED_AS_INTEGER;

        public abstract PNone execute(VirtualFrame var1, PList var2, Object var3, Object var4);

        @Specialization(guards={"isIntStorage(list)"})
        static PNone insertIntInt(PList list, int index, int value) {
            IntSequenceStorage target = (IntSequenceStorage)list.getSequenceStorage();
            target.insertIntItem(ListInsertNode.normalizeIndex(index, target.length()), value);
            return PNone.NONE;
        }

        @Specialization(guards={"isLongStorage(list)"})
        static PNone insertLongLong(PList list, int index, int value) {
            LongSequenceStorage target = (LongSequenceStorage)list.getSequenceStorage();
            target.insertLongItem(ListInsertNode.normalizeIndex(index, target.length()), value);
            return PNone.NONE;
        }

        @Specialization(guards={"isLongStorage(list)"})
        static PNone insertLongLong(PList list, int index, long value) {
            LongSequenceStorage target = (LongSequenceStorage)list.getSequenceStorage();
            target.insertLongItem(ListInsertNode.normalizeIndex(index, target.length()), value);
            return PNone.NONE;
        }

        @Specialization(guards={"isDoubleStorage(list)"})
        static PNone insertDoubleDouble(PList list, int index, double value) {
            DoubleSequenceStorage target = (DoubleSequenceStorage)list.getSequenceStorage();
            target.insertDoubleItem(ListInsertNode.normalizeIndex(index, target.length()), value);
            return PNone.NONE;
        }

        @Specialization(guards={"isNotSpecialCase(list, value)"})
        static PNone insert(PList list, int index, Object value, @Bind(value="this") Node inliningTarget, @Cached SequenceStorageNodes.InsertItemNode insertItem) {
            SequenceStorage store = list.getSequenceStorage();
            list.setSequenceStorage(insertItem.execute(inliningTarget, store, ListInsertNode.normalizeIndex(index, store.length()), value));
            return PNone.NONE;
        }

        @Specialization
        static PNone insertLongIndex(VirtualFrame frame, PList list, long index, Object value, @Cached.Shared @Cached ListInsertNode insertNode) {
            int where = index < Integer.MIN_VALUE ? 0 : (index > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)index);
            where = ListInsertNode.normalizeIndex(where, list.getSequenceStorage().length());
            return insertNode.execute(frame, list, (Object)where, value);
        }

        @Specialization
        static PNone insertPIntIndex(VirtualFrame frame, PList list, PInt index, Object value, @Cached.Shared @Cached ListInsertNode insertNode) {
            int where = ListInsertNode.normalizePIntForIndex(index);
            where = ListInsertNode.normalizeIndex(where, list.getSequenceStorage().length());
            return insertNode.execute(frame, list, (Object)where, value);
        }

        @Specialization(guards={"!isIntegerOrPInt(i)"})
        static PNone insert(VirtualFrame frame, PList list, Object i, Object value, @Cached(value="createInteger(ERROR_MSG)") ListNodes.IndexNode indexNode, @Cached.Shared @Cached ListInsertNode insertNode) {
            Object indexValue = indexNode.execute(frame, i);
            return insertNode.execute(frame, list, indexValue, value);
        }

        @CompilerDirectives.TruffleBoundary
        private static int normalizePIntForIndex(PInt index) {
            int where = 0;
            BigInteger bigIndex = index.getValue();
            where = bigIndex.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) < 0 ? 0 : (bigIndex.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0 ? Integer.MAX_VALUE : bigIndex.intValue());
            return where;
        }

        private static int normalizeIndex(int index, int len) {
            int idx = index;
            if (idx < 0 && (idx += len) < 0) {
                idx = 0;
            }
            if (idx > len) {
                idx = len;
            }
            return idx;
        }

        protected static boolean isNotSpecialCase(PList list, Object value) {
            return !(PGuards.isIntStorage(list) && value instanceof Integer || PGuards.isLongStorage(list) && PGuards.isInteger(value) || PGuards.isDoubleStorage(list) && value instanceof Double);
        }

        protected static boolean isIntegerOrPInt(Object index) {
            return index instanceof Integer || index instanceof PInt;
        }
    }

    @Builtin(name="copy", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ListCopyNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        PList copySequence(PList self, @Bind(value="this") Node inliningTarget, @Cached SequenceStorageNodes.CopyNode copy, @Cached GetClassNode getClassNode) {
            return this.factory().createList(getClassNode.execute(inliningTarget, self), copy.execute(inliningTarget, self.getSequenceStorage()));
        }
    }

    @Builtin(name="extend", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class ListExtendNode
    extends PythonBinaryBuiltinNode {
        public abstract PNone execute(VirtualFrame var1, PList var2, Object var3);

        @Specialization
        PNone extendSequence(VirtualFrame frame, PList list, Object iterable, @Bind(value="this") Node inliningTarget, @Cached IteratorNodes.GetLength lenNode, @Cached(value="createExtend()") SequenceStorageNodes.ExtendNode extendNode) {
            int len = lenNode.execute(frame, inliningTarget, iterable);
            ListExtendNode.updateSequenceStorage(list, extendNode.execute(frame, list.getSequenceStorage(), iterable, len));
            return PNone.NONE;
        }

        private static void updateSequenceStorage(PList list, SequenceStorage s) {
            if (list.getSequenceStorage() != s) {
                list.setSequenceStorage(s);
            }
        }

        @NeverDefault
        protected static SequenceStorageNodes.ExtendNode createExtend() {
            return SequenceStorageNodes.ExtendNode.create(SequenceStorageNodes.ListGeneralizationNode.SUPPLIER);
        }

        @NeverDefault
        public static ListExtendNode create() {
            return ListBuiltinsFactory.ListExtendNodeFactory.create();
        }
    }

    @Builtin(name="append", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class ListAppendNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        public PNone appendObjectGeneric(PList list, Object arg, @Cached ListNodes.AppendNode appendNode) {
            appendNode.execute(list, arg);
            return PNone.NONE;
        }
    }

    @Builtin(name="__setitem__", minNumOfPositionalArgs=3)
    @GenerateNodeFactory
    public static abstract class SetItemNode
    extends PythonTernaryBuiltinNode {
        @Specialization
        protected Object doInt(PList self, int index, Object value, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile generalizedProfile, @Cached.Shared(value="setItem") @Cached(value="createForList()") SequenceStorageNodes.SetItemNode setItemNode) {
            SetItemNode.updateStorage(inliningTarget, self, setItemNode.execute(self.getSequenceStorage(), index, value), generalizedProfile);
            return PNone.NONE;
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization(guards={"isIndexOrSlice(this, indexCheckNode, key)"})
        public Object doGeneric(VirtualFrame frame, PList primary, Object key, Object value, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile generalizedProfile, @Cached.Shared(value="indexCheckNode") @Cached PyIndexCheckNode indexCheckNode, @Cached.Shared(value="setItem") @Cached(value="createForList()") SequenceStorageNodes.SetItemNode setItemNode) {
            SetItemNode.updateStorage(inliningTarget, primary, setItemNode.execute(frame, primary.getSequenceStorage(), key, value), generalizedProfile);
            return PNone.NONE;
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization(guards={"!isIndexOrSlice(this, indexCheckNode, key)"})
        protected Object doError(Object self, Object key, Object value, @Cached.Shared(value="indexCheckNode") @Cached PyIndexCheckNode indexCheckNode) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.OBJ_INDEX_MUST_BE_INT_OR_SLICES, "list", key);
        }

        private static void updateStorage(Node inliningTarget, PList primary, SequenceStorage newStorage, InlinedConditionProfile generalizedProfile) {
            if (generalizedProfile.profile(inliningTarget, primary.getSequenceStorage() != newStorage)) {
                primary.setSequenceStorage(newStorage);
            }
        }

        @NeverDefault
        protected static SetItemNode create() {
            return ListBuiltinsFactory.SetItemNodeFactory.create();
        }
    }

    @Builtin(name="__getitem__", minNumOfPositionalArgs=2)
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @GenerateNodeFactory
    public static abstract class GetItemNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        protected static Object doInBounds(PList self, int index, @Cached.Shared(value="getItem") @Cached(value="createForList()") SequenceStorageNodes.GetItemNode getItemNode) {
            return getItemNode.execute(self.getSequenceStorage(), index);
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization(guards={"isIndexOrSlice(this, indexCheckNode, key)"})
        protected static Object doScalar(VirtualFrame frame, PList self, Object key, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyIndexCheckNode indexCheckNode, @Cached.Shared(value="getItem") @Cached(value="createForList()") SequenceStorageNodes.GetItemNode getItemNode) {
            return getItemNode.execute(frame, self.getSequenceStorage(), key);
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization(guards={"!isIndexOrSlice(this, indexCheckNode, key)"})
        protected Object doListError(VirtualFrame frame, Object self, Object key, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyIndexCheckNode indexCheckNode) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.OBJ_INDEX_MUST_BE_INT_OR_SLICES, "list", key);
        }

        @NeverDefault
        protected static GetItemNode create() {
            return ListBuiltinsFactory.GetItemNodeFactory.create();
        }
    }

    @Builtin(name="__delitem__", minNumOfPositionalArgs=2)
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @GenerateNodeFactory
    public static abstract class DelItemNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        protected Object doGeneric(VirtualFrame frame, PList self, Object key, @Cached SequenceStorageNodes.DeleteNode deleteNode) {
            deleteNode.execute(frame, self.getSequenceStorage(), key);
            return PNone.NONE;
        }

        @Fallback
        protected Object doGeneric(Object self, Object objectIdx) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.DESCRIPTOR_S_REQUIRES_S_OBJ_RECEIVED_P, "__delitem__", "list", self);
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class ListInitNode
    extends PythonBinaryBuiltinNode {
        public abstract PNone execute(VirtualFrame var1, PList var2, Object var3);

        @Specialization
        static PNone initTruffleString(PList list, TruffleString value, @Cached.Shared(value="cpIt") @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached.Shared(value="cpItNext") @Cached TruffleStringIterator.NextNode nextNode, @Cached.Shared(value="fromCp") @Cached TruffleString.FromCodePointNode fromCodePointNode, @Cached.Shared(value="appendNode") @Cached ListNodes.AppendNode appendNode) {
            ListInitNode.clearStorage(list);
            TruffleStringIterator iterator = createCodePointIteratorNode.execute((AbstractTruffleString)value, PythonUtils.TS_ENCODING);
            while (iterator.hasNext()) {
                int cp = nextNode.execute(iterator);
                appendNode.execute(list, fromCodePointNode.execute(cp, PythonUtils.TS_ENCODING, true));
            }
            return PNone.NONE;
        }

        @Specialization
        static PNone initPString(PList list, PString value, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode castStr, @Cached.Shared(value="cpIt") @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached.Shared(value="cpItNext") @Cached TruffleStringIterator.NextNode nextNode, @Cached.Shared(value="fromCp") @Cached TruffleString.FromCodePointNode fromCodePointNode, @Cached.Shared(value="appendNode") @Cached ListNodes.AppendNode appendNode) {
            return ListInitNode.initTruffleString(list, castStr.execute(inliningTarget, value), createCodePointIteratorNode, nextNode, fromCodePointNode, appendNode);
        }

        @Specialization(guards={"isNoValue(none)"})
        static PNone init(PList list, PNone none) {
            ListInitNode.clearStorage(list);
            return PNone.NONE;
        }

        @Specialization
        static PNone listRange(PList list, PIntRange range) {
            ListInitNode.clearStorage(list);
            int start = range.getIntStart();
            int step = range.getIntStep();
            int len = range.getIntLength();
            int[] array = new int[len];
            int value = start;
            for (int i = 0; i < len; ++i) {
                array[i] = value;
                value += step;
            }
            list.setSequenceStorage(new IntSequenceStorage(array));
            return PNone.NONE;
        }

        @Specialization(guards={"!isNoValue(iterable)", "!isString(iterable)"})
        static PNone listIterable(VirtualFrame frame, PList list, Object iterable, @Bind(value="this") Node inliningTarget, @Cached IteratorNodes.GetLength lenNode, @Cached PyObjectGetIter getIter, @Cached SequenceStorageNodes.CreateStorageFromIteratorNode storageNode) {
            ListInitNode.clearStorage(list);
            int len = lenNode.execute(frame, inliningTarget, iterable);
            Object iterObj = getIter.execute((Frame)frame, inliningTarget, iterable);
            list.setSequenceStorage(storageNode.execute(frame, iterObj, len));
            return PNone.NONE;
        }

        private static void clearStorage(PList list) {
            if (EmptySequenceStorage.INSTANCE != list.getSequenceStorage()) {
                list.setSequenceStorage(EmptySequenceStorage.INSTANCE);
            }
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public TruffleString repr(VirtualFrame frame, PList self, @Bind(value="this") Node inliningTarget, @Cached SequenceStorageNodes.GetItemNode getItem, @Cached PyObjectReprAsTruffleStringNode reprNode, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            SequenceStorage storage = self.getSequenceStorage();
            int length = storage.length();
            if (length == 0) {
                return StringLiterals.T_EMPTY_BRACKETS;
            }
            if (!PythonContext.get(this).reprEnter(self)) {
                return StringLiterals.T_ELLIPSIS_IN_BRACKETS;
            }
            try {
                TruffleStringBuilder buf = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
                appendStringNode.execute(buf, (AbstractTruffleString)StringLiterals.T_LBRACKET);
                boolean initial = true;
                for (int index = 0; index < length; ++index) {
                    if (initial) {
                        initial = false;
                    } else {
                        appendStringNode.execute(buf, (AbstractTruffleString)StringLiterals.T_COMMA_SPACE);
                    }
                    Object value = getItem.execute(storage, index);
                    appendStringNode.execute(buf, (AbstractTruffleString)reprNode.execute((Frame)frame, inliningTarget, value));
                }
                appendStringNode.execute(buf, (AbstractTruffleString)StringLiterals.T_RBRACKET);
                TruffleString truffleString = toStringNode.execute(buf);
                return truffleString;
            }
            finally {
                PythonContext.get(this).reprLeave(self);
            }
        }
    }
}

